/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.Main;
import charactermanaj.graphics.filters.ColorConvertParameter;
import charactermanaj.model.AppConfig;
import charactermanaj.model.ColorGroup;
import charactermanaj.model.Layer;
import charactermanaj.model.PartsCategory;
import charactermanaj.model.PartsIdentifier;
import charactermanaj.ui.ColorDialogTabPanel;
import charactermanaj.ui.model.ColorChangeEvent;
import charactermanaj.ui.model.ColorChangeListener;
import charactermanaj.util.LocalizedResourcePropertyLoader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Semaphore;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;

public class ColorDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(ColorDialog.class.getName());
    private final PartsCategory partsCategory;
    private HashMap<Layer, ColorDialogTabPanel> tabs = new HashMap();
    private JTabbedPane tabbedPane;
    private HashMap<Layer, Integer> tabbedPaneIndexMap = new HashMap();
    private LinkedList<ColorChangeListener> listeners = new LinkedList();
    private String captionBase;
    private PartsIdentifier partsIdentifier;
    private JCheckBox chkApplyAll;
    private Action actReset;

    public ColorDialog(JFrame parent, PartsCategory partsCategory, Collection<ColorGroup> colorGroups) {
        super(parent);
        this.partsCategory = partsCategory;
        Properties strings = LocalizedResourcePropertyLoader.getCachedInstance().getLocalizedProperties("languages/colordialog");
        String caption = strings.getProperty("colordialog.caption");
        String name = partsCategory.getLocalizedCategoryName();
        this.captionBase = caption + name;
        this.setTitle(this.captionBase);
        final AbstractAction actHide = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ColorDialog.this.setVisible(false);
            }
        };
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                actHide.actionPerformed(new ActionEvent(ColorDialog.this, 0, "closing"));
            }
        });
        Container container = this.getContentPane();
        this.tabbedPane = new JTabbedPane(1, 0);
        for (final Layer layer : partsCategory.getLayers()) {
            final ColorDialogTabPanel tabContainer = new ColorDialogTabPanel(this, layer, colorGroups);
            ColorChangeListener innerListener = new ColorChangeListener(){
                private Semaphore semaphore = new Semaphore(1);

                @Override
                public void onColorChange(ColorChangeEvent event) {
                    if (this.semaphore.tryAcquire()) {
                        try {
                            ColorDialog.this.fireColorChangeEvent(layer, false);
                        }
                        finally {
                            this.semaphore.release();
                        }
                    }
                }

                @Override
                public void onColorGroupChange(ColorChangeEvent event) {
                    if (this.semaphore.tryAcquire()) {
                        try {
                            ColorDialog.this.fireColorGroupChangeEvent(layer);
                            ColorDialog.this.fireColorChangeEvent(layer, false);
                        }
                        finally {
                            this.semaphore.release();
                        }
                    }
                }
            };
            tabContainer.addColorChangeListener(innerListener);
            tabContainer.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentShown(ComponentEvent e) {
                    ColorDialog.this.updateResetButton(tabContainer);
                }
            });
            tabContainer.addPropertyChangeListener("colorConvertParameter", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    ColorDialog.this.updateResetButton(tabContainer);
                }
            });
            this.tabbedPane.addTab(layer.getLocalizedName(), tabContainer);
            this.tabbedPaneIndexMap.put(layer, this.tabbedPane.getTabCount() - 1);
            this.tabs.put(layer, tabContainer);
        }
        AbstractAction actApply = new AbstractAction(strings.getProperty("button.apply")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ColorDialog.this.apply();
            }
        };
        this.actReset = new AbstractAction(strings.getProperty("button.reset")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ColorDialogTabPanel tab = (ColorDialogTabPanel)ColorDialog.this.tabbedPane.getSelectedComponent();
                if (tab != null) {
                    ColorDialog.this.resetColor(tab);
                    ColorDialog.this.apply();
                }
            }
        };
        JPanel btnPanel = new JPanel();
        btnPanel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        GridBagLayout gbl = new GridBagLayout();
        btnPanel.setLayout(gbl);
        int colIdx = 0;
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = colIdx++;
        gbc.gridy = 0;
        gbc.ipadx = 0;
        gbc.ipady = 0;
        gbc.anchor = 13;
        gbc.fill = 1;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        this.chkApplyAll = new JCheckBox(strings.getProperty("checkbox.applyAllItems"));
        this.chkApplyAll.setSelected(!partsCategory.isMultipleSelectable());
        this.chkApplyAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColorDialog.this.apply();
            }
        });
        btnPanel.add((Component)this.chkApplyAll, gbc);
        gbc.gridx = colIdx++;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        btnPanel.add(Box.createHorizontalGlue(), gbc);
        JButton btnApply = null;
        AppConfig appConfig = AppConfig.getInstance();
        if (!appConfig.isEnableAutoColorChange()) {
            gbc.gridx = colIdx++;
            gbc.gridy = 0;
            gbc.weightx = 0.0;
            btnApply = new JButton(actApply);
            btnPanel.add((Component)btnApply, gbc);
        }
        gbc.gridx = colIdx++;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        JButton btnReset = new JButton(this.actReset);
        btnPanel.add((Component)btnReset, gbc);
        container.setLayout(new BorderLayout());
        container.add((Component)this.tabbedPane, "Center");
        container.add((Component)btnPanel, "South");
        Toolkit tk = Toolkit.getDefaultToolkit();
        JRootPane rootPane = this.getRootPane();
        if (btnApply != null) {
            rootPane.setDefaultButton(btnApply);
        }
        InputMap im = rootPane.getInputMap(2);
        ActionMap am = rootPane.getActionMap();
        im.put(KeyStroke.getKeyStroke(87, tk.getMenuShortcutKeyMask()), "hideColorDialog");
        am.put("hideColorDialog", actHide);
        this.pack();
    }

    protected void updateResetButton(ColorDialogTabPanel panel) {
        ColorDialogTabPanel currentPanel = (ColorDialogTabPanel)this.tabbedPane.getSelectedComponent();
        if (currentPanel != null && currentPanel.equals(panel)) {
            this.actReset.setEnabled(panel.isColorConvertParameterModified());
        }
    }

    public PartsCategory getPartsCategory() {
        return this.partsCategory;
    }

    public boolean isSyncColorGroup(Layer layer) {
        ColorDialogTabPanel tab = this.tabs.get(layer);
        if (tab == null) {
            return false;
        }
        return tab.isSyncColorGroup();
    }

    public void setSyncColorGroup(Layer layer, boolean selected) {
        ColorDialogTabPanel tab = this.tabs.get(layer);
        if (tab != null) {
            tab.setSyncColorGroup(selected);
        }
    }

    public void setColorConvertParameters(Map<Layer, ColorConvertParameter> params) {
        if (params == null) {
            throw new IllegalArgumentException();
        }
        for (Layer layer : this.partsCategory.getLayers()) {
            ColorConvertParameter param = params.get(layer);
            if (param == null) {
                param = new ColorConvertParameter();
            }
            this.setColorConvertParameter(layer, param);
        }
    }

    public void setPartsIdentifier(PartsIdentifier partsIdentifier) {
        this.partsIdentifier = partsIdentifier;
        if (partsIdentifier == null) {
            this.setTitle(this.captionBase);
        } else {
            this.setTitle(this.captionBase + "(" + partsIdentifier.getLocalizedPartsName() + ")");
        }
    }

    public PartsIdentifier getPartsIdentifier() {
        return this.partsIdentifier;
    }

    public void setEnableLayers(Collection<Layer> layers) {
        for (Map.Entry<Layer, ColorDialogTabPanel> entry : this.tabs.entrySet()) {
            boolean enabled;
            Layer layer = entry.getKey();
            boolean bl = enabled = layers == null || layers.contains(layer);
            Integer tabIndex = this.tabbedPaneIndexMap.get(layer);
            if (tabIndex == null) continue;
            if (Main.isMacOSX()) {
                this.tabbedPane.setTitleAt(tabIndex, enabled ? layer.getLocalizedName() : "-");
            }
            this.tabbedPane.setEnabledAt(tabIndex, enabled);
            if (!logger.isLoggable(Level.FINEST)) continue;
            logger.log(Level.FINEST, "setEnableLayers(" + layer + ")=" + enabled);
        }
    }

    public boolean isApplyAll() {
        return this.chkApplyAll.isSelected();
    }

    public Map<Layer, ColorConvertParameter> getColorConvertParameters() {
        HashMap<Layer, ColorConvertParameter> params = new HashMap<Layer, ColorConvertParameter>();
        for (Layer layer : this.partsCategory.getLayers()) {
            ColorDialogTabPanel tab = this.tabs.get(layer);
            ColorConvertParameter param = tab.getColorConvertParameter();
            params.put(layer, param);
        }
        return params;
    }

    public void setColorConvertParameter(Layer layer, ColorConvertParameter param) {
        if (layer == null || param == null) {
            throw new IllegalArgumentException();
        }
        ColorDialogTabPanel tab = this.tabs.get(layer);
        if (tab == null) {
            throw new IllegalArgumentException("layer not found. " + layer + "/tabs=" + this.tabs);
        }
        tab.setColorConvertParameter(param);
    }

    public ColorConvertParameter getColorConvertParameter(Layer layer) {
        if (layer == null) {
            throw new IllegalArgumentException();
        }
        ColorDialogTabPanel tab = this.tabs.get(layer);
        if (tab == null) {
            throw new IllegalArgumentException("layer not found. " + layer);
        }
        return tab.getColorConvertParameter();
    }

    public ColorGroup getColorGroup(Layer layer) {
        if (layer == null) {
            throw new IllegalArgumentException();
        }
        ColorDialogTabPanel tab = this.tabs.get(layer);
        if (tab == null) {
            throw new IllegalArgumentException("layer not found. " + layer);
        }
        return tab.getColorGroup();
    }

    public void setColorGroup(Layer layer, ColorGroup colorGroup) {
        if (layer == null || colorGroup == null) {
            throw new IllegalArgumentException();
        }
        ColorDialogTabPanel tab = this.tabs.get(layer);
        if (tab != null) {
            tab.setColorGroup(colorGroup);
        }
    }

    public void addColorChangeListener(ColorChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        this.listeners.add(listener);
    }

    public void removeColorChangeListener(ColorChangeListener listener) {
        this.listeners.remove(listener);
    }

    protected void apply() {
        for (Layer layer : this.getPartsCategory().getLayers()) {
            this.fireColorChangeEvent(layer, true);
        }
    }

    protected void resetColor(ColorDialogTabPanel tab) {
        tab.resetColor();
    }

    protected void fireColorChangeEvent(Layer layer, boolean force) {
        AppConfig appConfig;
        if (layer == null) {
            throw new IllegalArgumentException();
        }
        if (!force && !(appConfig = AppConfig.getInstance()).isEnableAutoColorChange()) {
            return;
        }
        ColorChangeEvent event = new ColorChangeEvent(this, layer);
        for (ColorChangeListener listener : this.listeners) {
            listener.onColorChange(event);
        }
    }

    protected void fireColorGroupChangeEvent(Layer layer) {
        if (layer == null) {
            throw new IllegalArgumentException();
        }
        ColorChangeEvent event = new ColorChangeEvent(this, layer);
        for (ColorChangeListener listener : this.listeners) {
            listener.onColorGroupChange(event);
        }
    }

    @Override
    public String toString() {
        return "ColorDialog(partsCategory:" + this.partsCategory + ")";
    }
}

