/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.Main;
import charactermanaj.clipboardSupport.ClipboardUtil;
import charactermanaj.graphics.AsyncImageBuilder;
import charactermanaj.graphics.ColorConvertedImageCachedLoader;
import charactermanaj.graphics.ImageBuildJobAbstractAdaptor;
import charactermanaj.graphics.ImageBuilder;
import charactermanaj.graphics.io.ImageSaveHelper;
import charactermanaj.graphics.io.OutputOption;
import charactermanaj.graphics.io.UkagakaImageSaveHelper;
import charactermanaj.model.AppConfig;
import charactermanaj.model.CharacterData;
import charactermanaj.model.CharacterDataChangeEvent;
import charactermanaj.model.CharacterDataChangeListener;
import charactermanaj.model.CharacterDataChangeObserver;
import charactermanaj.model.ColorGroup;
import charactermanaj.model.CustomLayerOrder;
import charactermanaj.model.CustomLayerOrderKey;
import charactermanaj.model.LayerOrderMapper;
import charactermanaj.model.ObservableList;
import charactermanaj.model.PartsCategory;
import charactermanaj.model.PartsColorInfo;
import charactermanaj.model.PartsColorManager;
import charactermanaj.model.PartsIdentifier;
import charactermanaj.model.PartsSet;
import charactermanaj.model.RecommendationURL;
import charactermanaj.model.WorkingSet;
import charactermanaj.model.io.CharacterDataPersistent;
import charactermanaj.model.io.CustomLayerOrderPersist;
import charactermanaj.model.io.PartsImageDirectoryWatchAgent;
import charactermanaj.model.io.PartsImageDirectoryWatchAgentFactory;
import charactermanaj.model.io.PartsImageDirectoryWatchEvent;
import charactermanaj.model.io.PartsImageDirectoryWatchListener;
import charactermanaj.model.io.RecentDataPersistent;
import charactermanaj.model.io.WorkingSetPersist;
import charactermanaj.ui.AboutBox;
import charactermanaj.ui.AppConfigDialog;
import charactermanaj.ui.ColorDialog;
import charactermanaj.ui.ExportWizardDialog;
import charactermanaj.ui.ImageSelectPanel;
import charactermanaj.ui.ImageSelectPanelList;
import charactermanaj.ui.ImportWizardDialog;
import charactermanaj.ui.InformationDialog;
import charactermanaj.ui.LayerOrderCustomizeDialog;
import charactermanaj.ui.LayerOrderCustomizeDialogModel;
import charactermanaj.ui.ManageFavoriteDialog;
import charactermanaj.ui.MenuBuilder;
import charactermanaj.ui.MenuDataFactory;
import charactermanaj.ui.PartsManageDialog;
import charactermanaj.ui.PartsRandomChooserDialog;
import charactermanaj.ui.PreviewPanel;
import charactermanaj.ui.ProfileListManager;
import charactermanaj.ui.SearchPartsDialog;
import charactermanaj.ui.Wallpaper;
import charactermanaj.ui.WallpaperDialog;
import charactermanaj.ui.model.ActiveCustomLayerPatternMgr;
import charactermanaj.ui.model.ColorChangeEvent;
import charactermanaj.ui.model.ColorChangeListener;
import charactermanaj.ui.model.ColorGroupCoordinator;
import charactermanaj.ui.model.FavoritesChangeEvent;
import charactermanaj.ui.model.FavoritesChangeListener;
import charactermanaj.ui.model.FavoritesChangeObserver;
import charactermanaj.ui.model.PartsColorCoordinator;
import charactermanaj.ui.model.PartsSelectionManager;
import charactermanaj.ui.model.WallpaperFactory;
import charactermanaj.ui.model.WallpaperFactoryErrorRecoverHandler;
import charactermanaj.ui.model.WallpaperFactoryException;
import charactermanaj.ui.model.WallpaperInfo;
import charactermanaj.ui.scrollablemenu.JScrollableMenu;
import charactermanaj.ui.util.FileDropTarget;
import charactermanaj.ui.util.WindowAdjustLocationSupport;
import charactermanaj.util.DesktopUtilities;
import charactermanaj.util.ErrorMessageHelper;
import charactermanaj.util.LocalizedResourcePropertyLoader;
import charactermanaj.util.SystemUtil;
import charactermanaj.util.UIHelper;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JColorChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class MainFrame
extends JFrame
implements FavoritesChangeListener,
CharacterDataChangeListener,
CustomLayerOrderPersist.CustomLayerOrderPersistListener {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(MainFrame.class.getName());
    protected static final String STRINGS_RESOURCE = "languages/mainframe";
    protected static final String MENU_STRINGS_RESOURCE = "menu/menu";
    protected BufferedImage icon;
    private static volatile MainFrame activedMainFrame;
    protected CharacterData characterData;
    private PreviewPanel previewPane;
    protected PartsSelectionManager partsSelectionManager;
    private boolean minimizeMode;
    protected ImageSelectPanelList imageSelectPanels;
    protected JScrollPane imgSelectPanelsPanelSp;
    protected ColorGroupCoordinator colorGroupCoordinator;
    protected PartsColorCoordinator partsColorCoordinator;
    private ColorConvertedImageCachedLoader imageLoader;
    private AsyncImageBuilder imageBuilder;
    private ImageSaveHelper imageSaveHelper = new ImageSaveHelper();
    private UkagakaImageSaveHelper ukagakaImageSaveHelper = new UkagakaImageSaveHelper();
    private PartsImageDirectoryWatchAgent watchAgent;
    private String defaultPartsSetTitle;
    private PartsSet lastUsePresetParts;
    private SearchPartsDialog lastUseSearchPartsDialog;
    private ManageFavoriteDialog lastUseManageFavoritesDialog;
    private PartsRandomChooserDialog lastUsePartsRandomChooserDialog;
    private WallpaperInfo wallpaperInfo;
    private final ActiveCustomLayerPatternMgr customLayerPatternMgr = new ActiveCustomLayerPatternMgr();
    private FavoriteMenuItemBuilder favMenuItemBuilder = new FavoriteMenuItemBuilder(){
        private MenuBuilder menuBuilder = new MenuBuilder();

        @Override
        public JMenuItem createFavoriteMenuItem(String name, final PartsSet partsSet) {
            JMenuItem favoriteMenu = this.menuBuilder.createJMenuItem();
            favoriteMenu.setName(partsSet.getPartsSetId());
            favoriteMenu.setText(name);
            if (partsSet.isPresetParts()) {
                Font font = favoriteMenu.getFont();
                favoriteMenu.setFont(font.deriveFont(1));
            }
            favoriteMenu.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MainFrame.this.selectPresetParts(partsSet);
                }
            });
            this.addMouseWheelListener(favoriteMenu);
            return favoriteMenu;
        }

        @Override
        public JMenu createSubMenu(String name) {
            JMenu menu = this.menuBuilder.createJMenu();
            menu.setText(name);
            this.addMouseWheelListener(menu);
            return menu;
        }

        protected void addMouseWheelListener(final JMenuItem favoriteMenu) {
            if (JScrollableMenu.isScreenMenu()) {
                return;
            }
            favoriteMenu.addMouseWheelListener(new MouseWheelListener(){

                @Override
                public void mouseWheelMoved(MouseWheelEvent e) {
                    int rotation = e.getWheelRotation();
                    JPopupMenu popupMenu = (JPopupMenu)favoriteMenu.getParent();
                    JMenu parentMenu = (JMenu)popupMenu.getInvoker();
                    if (parentMenu != null && parentMenu instanceof JScrollableMenu) {
                        JScrollableMenu favMenu = (JScrollableMenu)parentMenu;
                        favMenu.doScroll(rotation < 0);
                    }
                    e.consume();
                }
            });
        }
    };
    private InformationDialog informationDialog;
    private HashMap<PartsIdentifier, Boolean> randomExcludePartsIdentifierMap = new HashMap();

    public static void setActivedMainFrame(MainFrame mainFrame) {
        if (mainFrame == null) {
            throw new IllegalArgumentException();
        }
        activedMainFrame = mainFrame;
    }

    public static MainFrame getActivedMainFrame() {
        return activedMainFrame;
    }

    @Override
    public void notifyChangeCharacterData(final CharacterDataChangeEvent e) {
        final CharacterData cd = e.getCharacterData();
        if (cd != null && cd.getDocBase().equals(this.characterData.getDocBase())) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        Cursor oldCur = MainFrame.this.getCursor();
                        MainFrame.this.setCursor(Cursor.getPredefinedCursor(3));
                        try {
                            if (e.isChangeStructure()) {
                                MainFrame.this.saveWorkingSet();
                                MainFrame.this.initComponent(cd);
                            }
                            if (e.isReloadPartsAndFavorites()) {
                                MainFrame.this.reloadPartsAndFavorites(cd, true);
                            }
                            MainFrame.this.setCursor(oldCur != null ? oldCur : Cursor.getDefaultCursor());
                        }
                        catch (Throwable throwable) {
                            MainFrame.this.setCursor(oldCur != null ? oldCur : Cursor.getDefaultCursor());
                            throw throwable;
                        }
                    }
                    catch (Exception ex) {
                        ErrorMessageHelper.showErrorDialog(MainFrame.this, ex);
                    }
                }
            });
        }
    }

    @Override
    public void notifyChangeFavorites(FavoritesChangeEvent e) {
        CharacterData cd = e.getCharacterData();
        if (cd != null && cd.getDocBase().equals(this.characterData.getDocBase())) {
            if (!this.equals(e.getSource()) && !this.characterData.equals(cd)) {
                this.characterData.clearPartsSets(false);
                for (Map.Entry<String, PartsSet> entry : cd.getPartsSets().entrySet()) {
                    PartsSet partsSet = entry.getValue();
                    this.characterData.addPartsSet(partsSet);
                }
            }
            if (this.lastUseManageFavoritesDialog != null && this.lastUseManageFavoritesDialog.isDisplayable()) {
                this.lastUseManageFavoritesDialog.initListModel();
            }
        }
    }

    @Override
    public void notifyChangeCustomLayerOrder(CustomLayerOrderPersist.CustomLayerOrderPersistListener.Change e) {
        Map<CustomLayerOrderKey, List<CustomLayerOrder>> map;
        if (!e.getSource().equals(this.characterData) && (map = e.getCustomLayerOrderMap()) != null) {
            this.customLayerPatternMgr.setMap(map);
            this.requestPreview();
        }
    }

    public MainFrame(CharacterData characterData) {
        try {
            if (characterData == null) {
                throw new IllegalArgumentException();
            }
            this.setDefaultCloseOperation(0);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    MainFrame.this.onCloseProfile();
                }

                @Override
                public void windowClosed(WindowEvent e) {
                    MainFrame.this.stopAgents();
                }

                @Override
                public void windowActivated(WindowEvent e) {
                    MainFrame.setActivedMainFrame(MainFrame.this);
                }

                @Override
                public void windowOpened(WindowEvent e) {
                }
            });
            this.icon = UIHelper.getInstance().getImage("icons/icon.png");
            this.setIconImage(this.icon);
            this.initComponent(characterData);
            JMenuBar menuBar = this.createMenuBar();
            this.setJMenuBar(menuBar);
            FavoritesChangeObserver.getDefault().addFavoritesChangeListener(this);
            CharacterDataChangeObserver.getDefault().addCharacterDataChangeListener(this);
            CustomLayerOrderPersist.newInstance(characterData).addCustomLayerOrderPersistListener(this);
        }
        catch (RuntimeException ex) {
            logger.log(Level.SEVERE, "\u30e1\u30a4\u30f3\u30d5\u30ec\u30fc\u30e0\u306e\u69cb\u7bc9\u4e2d\u306b\u4e88\u671f\u305b\u306c\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002", ex);
            this.dispose();
            throw ex;
        }
        catch (Error ex) {
            logger.log(Level.SEVERE, "\u30e1\u30a4\u30f3\u30d5\u30ec\u30fc\u30e0\u306e\u69cb\u7bc9\u4e2d\u306b\u81f4\u547d\u7684\u306a\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002", ex);
            this.dispose();
            throw ex;
        }
    }

    private void setDefaultWindowLocation() {
        GraphicsEnvironment genv = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Rectangle desktopSize = genv.getMaximumWindowBounds();
        logger.log(Level.CONFIG, "desktopSize=" + desktopSize);
        Dimension imageSize = this.characterData.getImageSize();
        AppConfig appConfig = AppConfig.getInstance();
        int maxWidth = Math.min(desktopSize.width, appConfig.getMainFrameMaxWidth());
        int maxHeight = Math.min(desktopSize.height, appConfig.getMainFrameMaxHeight());
        int imageWidth = Math.min(maxWidth, Math.max(300, imageSize != null ? imageSize.width : 0));
        int imageHeight = Math.min(maxHeight, Math.max(400, imageSize != null ? imageSize.height : 0));
        this.setSize(imageWidth - 300 + 600, imageHeight - 400 + 550);
        if (!this.isShowing()) {
            this.setLocationByPlatform(true);
        }
    }

    public void showMainFrame() {
        GraphicsEnvironment genv = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Rectangle desktopSize = genv.getMaximumWindowBounds();
        logger.log(Level.CONFIG, "desktopSize=" + desktopSize);
        this.setVisible(true);
        Point loc = this.getLocation();
        logger.log(Level.CONFIG, "windowLocation=" + loc);
        Dimension windowSize = this.getSize();
        if (loc.y + windowSize.height >= desktopSize.height) {
            loc.y = 0;
        }
        if (loc.x + windowSize.width >= desktopSize.width) {
            loc.x = 0;
        }
        if (loc.x == 0 || loc.y == 0) {
            this.setLocation(loc);
        }
        boolean resize = false;
        Dimension dim = this.getSize();
        if (dim.height > desktopSize.height) {
            dim.height = desktopSize.height;
            resize = true;
        }
        if (dim.width > desktopSize.width) {
            dim.width = desktopSize.width;
            resize = true;
        }
        if (resize) {
            this.setSize(dim);
        }
    }

    protected void stopAgents() {
        if (this.watchAgent != null) {
            try {
                this.watchAgent.disconnect();
            }
            catch (Throwable ex) {
                logger.log(Level.SEVERE, "\u30d5\u30a9\u30eb\u30c0\u76e3\u8996\u30b9\u30ec\u30c3\u30c9\u306e\u505c\u6b62\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", ex);
            }
            this.watchAgent = null;
        }
        if (this.imageBuilder != null) {
            try {
                this.imageBuilder.stop();
            }
            catch (Throwable ex) {
                logger.log(Level.SEVERE, "\u975e\u540c\u671f\u30a4\u30e1\u30fc\u30b8\u30d3\u30eb\u30c0\u30b9\u30ec\u30c3\u30c9\u306e\u505c\u6b62\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", ex);
            }
            this.imageBuilder = null;
        }
    }

    @Override
    public void dispose() {
        FavoritesChangeObserver.getDefault().removeFavoritesChangeListener(this);
        CharacterDataChangeObserver.getDefault().removeCharacterDataChangeListener(this);
        CustomLayerOrderPersist.newInstance(this.characterData).removeCustomLayerOrderPersistListener(this);
        this.imageLoader.close();
        this.stopAgents();
        super.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initComponent(CharacterData characterData) {
        CharacterData oldCd;
        MainFrame mainFrame = this;
        synchronized (mainFrame) {
            oldCd = this.characterData;
            if (oldCd != null) {
                ProfileListManager.unregisterUsedCharacterData(oldCd);
            }
            this.characterData = characterData;
            ProfileListManager.registerUsedCharacterData(characterData);
        }
        AppConfig appConfig = AppConfig.getInstance();
        Properties strings = LocalizedResourcePropertyLoader.getCachedInstance().getLocalizedProperties(STRINGS_RESOURCE);
        String title = Main.isMacOSX() ? "" : strings.getProperty("title");
        this.setTitle(title + characterData.getName());
        this.defaultPartsSetTitle = strings.getProperty("defaultPartsSetTitle");
        this.stopAgents();
        Container contentPane = this.getContentPane();
        for (Component comp : contentPane.getComponents()) {
            contentPane.remove(comp);
        }
        this.closeInformationDialog();
        this.closeSearchDialog();
        this.closeManageFavoritesDialog();
        this.closePartsRandomChooserDialog();
        PartsColorManager partsColorManager = characterData.getPartsColorManager();
        Color bgColor = appConfig.getDefaultImageBgColor();
        this.wallpaperInfo = new WallpaperInfo();
        this.wallpaperInfo.setBackgroundColor(bgColor);
        if (this.imageLoader != null) {
            this.imageLoader.close();
        }
        this.imageLoader = new ColorConvertedImageCachedLoader();
        this.imageBuilder = new AsyncImageBuilder(this.imageLoader);
        this.partsSelectionManager = new PartsSelectionManager(partsColorManager, new PartsSelectionManager.ImageBgColorProvider(){

            @Override
            public Color getImageBgColor() {
                return MainFrame.this.wallpaperInfo.getBackgroundColor();
            }

            @Override
            public void setImageBgColor(Color imageBgColor) {
                MainFrame.this.applyBackgroundColorOnly(imageBgColor);
            }
        }, new PartsSelectionManager.CustomLayerPatternsIDProvider(){

            @Override
            public Set<String> getActivePatternIds() {
                Set<CustomLayerOrderKey> keys = MainFrame.this.customLayerPatternMgr.getActivePatternNames();
                HashSet<String> ids = new HashSet<String>();
                for (CustomLayerOrderKey key : keys) {
                    ids.add(key.getId());
                }
                return ids;
            }

            @Override
            public void setActivePatternIds(Set<String> names) {
                HashSet<CustomLayerOrderKey> keys = new HashSet<CustomLayerOrderKey>();
                for (CustomLayerOrderKey key : MainFrame.this.customLayerPatternMgr.getMap().keySet()) {
                    if (!names.contains(key.getId())) continue;
                    keys.add(key);
                }
                MainFrame.this.customLayerPatternMgr.setActivePatternNames(keys);
            }
        });
        this.colorGroupCoordinator = new ColorGroupCoordinator(this.partsSelectionManager, partsColorManager);
        this.partsColorCoordinator = new PartsColorCoordinator(characterData, partsColorManager, this.colorGroupCoordinator);
        PartsImageDirectoryWatchAgentFactory agentFactory = PartsImageDirectoryWatchAgentFactory.getFactory();
        this.watchAgent = agentFactory.getAgent(characterData);
        this.previewPane = new PreviewPanel();
        this.previewPane.setTitle(this.defaultPartsSetTitle);
        this.previewPane.addPreviewPanelListener(new PreviewPanel.PreviewPanelListener(){

            @Override
            public void addFavorite(PreviewPanel.PreviewPanelEvent e) {
                if (!e.isShiftKeyPressed()) {
                    MainFrame.this.onRegisterFavorite();
                } else {
                    MainFrame.this.onManageFavorites();
                }
            }

            @Override
            public void changeBackgroundColor(PreviewPanel.PreviewPanelEvent e) {
                if (!e.isShiftKeyPressed()) {
                    MainFrame.this.onChangeWallpaper();
                } else {
                    MainFrame.this.onChangeBgColor();
                }
            }

            @Override
            public void copyPicture(PreviewPanel.PreviewPanelEvent e) {
                MainFrame.this.onCopy(e.isShiftKeyPressed());
            }

            @Override
            public void savePicture(PreviewPanel.PreviewPanelEvent e) {
                if (!e.isShiftKeyPressed()) {
                    MainFrame.this.onSavePicture();
                } else {
                    MainFrame.this.onSaveAsUkagaka();
                }
            }

            @Override
            public void showInformation(PreviewPanel.PreviewPanelEvent e) {
                MainFrame.this.onInformation();
            }

            @Override
            public void flipHorizontal(PreviewPanel.PreviewPanelEvent e) {
                MainFrame.this.onFlipHolizontal();
            }
        });
        this.imageSelectPanels = new ImageSelectPanelList();
        JPanel imgSelectPanelsPanel = new JPanel();
        BoxLayout bl = new BoxLayout(imgSelectPanelsPanel, 3);
        imgSelectPanelsPanel.setLayout(bl);
        for (PartsCategory category : characterData.getPartsCategories()) {
            ImageSelectPanel imageSelectPanel = new ImageSelectPanel(category, characterData);
            imgSelectPanelsPanel.add(imageSelectPanel);
            this.imageSelectPanels.add(imageSelectPanel);
            this.partsSelectionManager.register(imageSelectPanel);
        }
        this.imgSelectPanelsPanelSp = new JScrollPane(imgSelectPanelsPanel){
            private static final long serialVersionUID = 1L;

            @Override
            public JScrollBar createVerticalScrollBar() {
                JScrollBar sb = super.createVerticalScrollBar();
                sb.setUnitIncrement(12);
                return sb;
            }
        };
        this.imgSelectPanelsPanelSp.setVerticalScrollBarPolicy(22);
        JSplitPane splitPane = new JSplitPane(1, true, this.imgSelectPanelsPanelSp, this.previewPane);
        contentPane.add((Component)splitPane, "Center");
        this.imgSelectPanelsPanelSp.requestFocus();
        ArrayList<ColorGroup> colorGroups = new ArrayList<ColorGroup>();
        colorGroups.addAll(characterData.getColorGroups());
        ColorChangeListener colorChangeListener = new ColorChangeListener(){

            @Override
            public void onColorGroupChange(ColorChangeEvent event) {
            }

            @Override
            public void onColorChange(ColorChangeEvent event) {
                MainFrame.this.requestPreview();
            }
        };
        this.colorGroupCoordinator.addColorChangeListener(colorChangeListener);
        int idx = 0;
        while (idx < this.imageSelectPanels.size()) {
            ImageSelectPanel imageSelectPanel = this.imageSelectPanels.get(idx);
            PartsCategory partsCategory = imageSelectPanel.getPartsCategory();
            final ColorDialog colorDialog = new ColorDialog(this, partsCategory, colorGroups);
            this.colorGroupCoordinator.registerColorDialog(colorDialog);
            this.partsColorCoordinator.register(imageSelectPanel, colorDialog);
            final int curidx = idx++;
            imageSelectPanel.addImageSelectListener(new ImageSelectPanel.ImageSelectPanelListener(){

                @Override
                public void onChangeColor(ImageSelectPanel.ImageSelectPanelEvent event) {
                    WindowAdjustLocationSupport.alignRight(MainFrame.this, colorDialog, curidx, false);
                    colorDialog.setVisible(!colorDialog.isVisible());
                }

                @Override
                public void onPreferences(ImageSelectPanel.ImageSelectPanelEvent event) {
                }

                @Override
                public void onChange(ImageSelectPanel.ImageSelectPanelEvent event) {
                    MainFrame.this.requestPreview();
                }

                @Override
                public void onSelectChange(ImageSelectPanel.ImageSelectPanelEvent event) {
                }

                @Override
                public void onTitleClick(ImageSelectPanel.ImageSelectPanelEvent event) {
                    PartsCategory partsCategory = event != null ? event.getImageSelectPanel().getPartsCategory() : null;
                    MainFrame.this.onClickPartsCategoryTitle(partsCategory, false);
                }

                @Override
                public void onTitleDblClick(ImageSelectPanel.ImageSelectPanelEvent event) {
                    PartsCategory partsCategory = event != null ? event.getImageSelectPanel().getPartsCategory() : null;
                    MainFrame.this.onClickPartsCategoryTitle(partsCategory, true);
                }
            });
            imageSelectPanel.addAncestorListener(new AncestorListener(){

                @Override
                public void ancestorAdded(AncestorEvent event) {
                }

                @Override
                public void ancestorMoved(AncestorEvent event) {
                }

                @Override
                public void ancestorRemoved(AncestorEvent event) {
                    colorDialog.setVisible(false);
                }
            });
        }
        this.partsSelectionManager.loadParts();
        this.loadCustomLayerOrder();
        if (!this.loadWorkingSet()) {
            this.setDefaultWindowLocation();
            if (this.showDefaultParts(true)) {
                this.requestPreview();
            }
        }
        this.scrollToSelectedParts();
        if (!this.imageBuilder.isAlive()) {
            this.imageBuilder.start();
        }
        new DropTarget(this.imgSelectPanelsPanelSp, new FileDropTarget(){

            @Override
            protected void onDropFiles(final List<File> dropFiles) {
                if (dropFiles == null || dropFiles.isEmpty()) {
                    return;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MainFrame.this.onImport(dropFiles);
                    }
                });
            }

            @Override
            protected void onException(Exception ex) {
                ErrorMessageHelper.showErrorDialog(MainFrame.this, ex);
            }
        });
        this.watchAgent.addPartsImageDirectoryWatchListener(new PartsImageDirectoryWatchListener(){

            @Override
            public void detectPartsImageChange(PartsImageDirectoryWatchEvent e) {
                Runnable refreshJob = new Runnable(){

                    @Override
                    public void run() {
                        MainFrame.this.onDetectPartsImageChange();
                    }
                };
                if (SwingUtilities.isEventDispatchThread()) {
                    refreshJob.run();
                } else {
                    SwingUtilities.invokeLater(refreshJob);
                }
            }
        });
        if (appConfig.isEnableDirWatch() && characterData.isWatchDirectory()) {
            this.watchAgent.connect();
        }
        this.minimizeMode = false;
        if (appConfig.isEnableAutoShrinkPanel()) {
            this.onClickPartsCategoryTitle(null, true);
        }
        if (oldCd != null) {
            this.validate();
        }
    }

    protected void onDetectPartsImageChange() {
        try {
            this.reloadPartsAndFavorites(null, true);
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, "parts reload failed. " + this.characterData, ex);
        }
    }

    protected void scrollToSelectedParts() {
        this.partsSelectionManager.scrollToSelectedParts();
    }

    protected void onClickPartsCategoryTitle(PartsCategory partsCategory, boolean dblClick) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "onClickPartsCategoryTitle category=" + partsCategory + "/clickCount=" + dblClick);
        }
        if (dblClick) {
            boolean bl = this.minimizeMode = !this.minimizeMode;
            if (!this.minimizeMode) {
                this.partsSelectionManager.setMinimizeModeIfOther(null, false);
                return;
            }
        }
        if (this.minimizeMode) {
            if (this.partsSelectionManager.isNotMinimizeModeJust(partsCategory)) {
                this.partsSelectionManager.setMinimizeModeIfOther(null, true);
            } else {
                this.partsSelectionManager.setMinimizeModeIfOther(partsCategory, true);
                if (partsCategory != null) {
                    final ImageSelectPanel panel = this.imageSelectPanels.findByPartsCategory(partsCategory);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Point pt = panel.getLocation();
                            JViewport viewPort = MainFrame.this.imgSelectPanelsPanelSp.getViewport();
                            viewPort.setViewPosition(pt);
                            viewPort.revalidate();
                        }
                    });
                }
            }
        }
    }

    protected boolean showDefaultParts(boolean force) {
        try {
            List<PartsSet> partssets;
            PartsSet sel;
            if (!force && !(sel = this.partsSelectionManager.createPartsSet()).isEmpty()) {
                return false;
            }
            String defaultPresetId = this.characterData.getDefaultPartsSetId();
            PartsSet partsSet = null;
            if (defaultPresetId != null) {
                partsSet = this.characterData.getPartsSets().get(defaultPresetId);
            }
            if (partsSet == null && !(partssets = this.getPartsSetList()).isEmpty()) {
                partsSet = partssets.get(0);
            }
            if (partsSet == null) {
                this.partsColorCoordinator.initColorDialog();
            } else {
                this.selectPresetParts(partsSet);
            }
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "\u30d1\u30fc\u30c4\u306e\u30c7\u30d5\u30a9\u30eb\u30c8\u9069\u7528\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", ex);
            return false;
        }
        return true;
    }

    protected void selectPresetParts(PartsSet presetParts) {
        if (presetParts == null) {
            return;
        }
        try {
            this.lastUsePresetParts = presetParts;
            this.partsSelectionManager.selectPartsSet(presetParts);
            this.partsColorCoordinator.initColorDialog();
            this.requestPreview();
        }
        catch (Exception ex) {
            ErrorMessageHelper.showErrorDialog(this, ex);
        }
    }

    protected List<PartsSet> getPartsSetList() {
        ArrayList<PartsSet> partssets = new ArrayList<PartsSet>();
        partssets.addAll(this.characterData.getPartsSets().values());
        Collections.sort(partssets, PartsSet.DEFAULT_COMPARATOR);
        return partssets;
    }

    protected TreeMap<TreeLeaf, Object> buildFavoritesItemTree(List<PartsSet> partssets) {
        if (partssets == null) {
            partssets = Collections.emptyList();
        }
        TreeMap<TreeLeaf, Cloneable> favTree = new TreeMap<TreeLeaf, Cloneable>();
        for (PartsSet partsSet : partssets) {
            String flatname = partsSet.getLocalizedName();
            String[] tokens = flatname.split("\\|");
            if (tokens.length == 0) continue;
            TreeMap<TreeLeaf, Cloneable> r = favTree;
            for (int idx = 0; idx < tokens.length - 1; ++idx) {
                String name = tokens[idx];
                TreeLeaf leafName = new TreeLeaf(TreeLeaf.TreeLeafType.NODE, name);
                TreeMap<TreeLeaf, Cloneable> n = (TreeMap<TreeLeaf, Cloneable>)r.get(leafName);
                if (n == null) {
                    n = new TreeMap<TreeLeaf, Cloneable>();
                    r.put(leafName, n);
                }
                r = n;
            }
            String lastName = tokens[tokens.length - 1];
            TreeLeaf lastLeafName = new TreeLeaf(TreeLeaf.TreeLeafType.LEAF, lastName);
            ArrayList<PartsSet> leafValue = (ArrayList<PartsSet>)r.get(lastLeafName);
            if (leafValue == null) {
                leafValue = new ArrayList<PartsSet>();
                r.put(lastLeafName, leafValue);
            }
            leafValue.add(partsSet);
        }
        return favTree;
    }

    private void buildFavoritesMenuItems(List<JMenuItem> menuItems, FavoriteMenuItemBuilder favMenuItemBuilder, TreeMap<TreeLeaf, Object> favTree) {
        for (Map.Entry<TreeLeaf, Object> entry : favTree.entrySet()) {
            TreeLeaf treeLeaf = entry.getKey();
            String name = treeLeaf.getName();
            if (treeLeaf.getTyp() == TreeLeaf.TreeLeafType.LEAF) {
                List leafValue = (List)entry.getValue();
                for (PartsSet partsSet : leafValue) {
                    JMenuItem favoriteMenu = favMenuItemBuilder.createFavoriteMenuItem(name, partsSet);
                    menuItems.add(favoriteMenu);
                }
                continue;
            }
            if (treeLeaf.getTyp() == TreeLeaf.TreeLeafType.NODE) {
                TreeMap childNode = (TreeMap)entry.getValue();
                JMenu subMenu = favMenuItemBuilder.createSubMenu(name);
                menuItems.add(subMenu);
                ArrayList<JMenuItem> subMenuItems = new ArrayList<JMenuItem>();
                this.buildFavoritesMenuItems(subMenuItems, favMenuItemBuilder, childNode);
                for (JMenuItem subMenuItem : subMenuItems) {
                    subMenu.add(subMenuItem);
                }
                continue;
            }
            throw new RuntimeException("unknown type: " + treeLeaf);
        }
    }

    protected void onSelectedFavoriteMenu(JMenu menu) {
        List<PartsSet> partssets = this.getPartsSetList();
        TreeMap<TreeLeaf, Object> favTree = this.buildFavoritesItemTree(partssets);
        ArrayList<JMenuItem> favoritesMenuItems = new ArrayList<JMenuItem>();
        this.buildFavoritesMenuItems(favoritesMenuItems, this.favMenuItemBuilder, favTree);
        this.replaceMenuItems(menu, favoritesMenuItems);
    }

    private void replaceMenuItems(JMenu menu, List<JMenuItem> items) {
        if (menu instanceof JScrollableMenu) {
            JScrollableMenu favMenu = (JScrollableMenu)menu;
            favMenu.initScroller();
            favMenu.setScrollableItems(items);
            Toolkit tk = Toolkit.getDefaultToolkit();
            Dimension scrsiz = tk.getScreenSize();
            int height = scrsiz.height;
            favMenu.adjustMaxVisible(height);
            logger.log(Level.FINE, "scrollableMenu maxVisible=" + favMenu.getMaxVisible());
        } else {
            int mx = menu.getMenuComponentCount();
            int separatorIdx = -1;
            for (int idx = 0; idx < mx; ++idx) {
                Component item = menu.getMenuComponent(idx);
                if (!(item instanceof JSeparator)) continue;
                separatorIdx = idx;
                break;
            }
            if (separatorIdx > 0) {
                while (menu.getMenuComponentCount() > separatorIdx + 1) {
                    menu.remove(separatorIdx + 1);
                }
            }
            for (JMenuItem menuItem : items) {
                menu.add(menuItem);
            }
        }
    }

    protected void onSelectedCustomLayerMenu(JMenu menu) {
        ArrayList<JMenuItem> menuItems = new ArrayList<JMenuItem>();
        for (Map.Entry<CustomLayerOrderKey, List<CustomLayerOrder>> entry : this.customLayerPatternMgr.getOrderedEntries()) {
            final CustomLayerOrderKey patternKey = entry.getKey();
            String displayName = patternKey.getDisplayName();
            final JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem(displayName);
            menuItem.setSelected(this.customLayerPatternMgr.isSelected(patternKey));
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MainFrame.this.customLayerPatternMgr.setSelected(patternKey, menuItem.isSelected());
                    MainFrame.this.requestPreview();
                }
            });
            menuItems.add(menuItem);
        }
        this.replaceMenuItems(menu, menuItems);
    }

    protected void onSelectedRecommendationMenu(JMenu mnuRecomendation) {
        while (mnuRecomendation.getMenuComponentCount() > 0) {
            mnuRecomendation.remove(0);
        }
        List<RecommendationURL> recommendations = this.characterData.getRecommendationURLList();
        if (recommendations != null) {
            MenuBuilder menuBuilder = new MenuBuilder();
            for (RecommendationURL recommendation : recommendations) {
                String displayName = recommendation.getDisplayName();
                String url = recommendation.getUrl();
                JMenuItem mnuItem = menuBuilder.createJMenuItem();
                mnuItem.setText(displayName);
                mnuItem.addActionListener(DesktopUtilities.createBrowseAction(this, url, displayName));
                mnuRecomendation.add(mnuItem);
            }
        }
        mnuRecomendation.setEnabled(recommendations != null && !recommendations.isEmpty());
    }

    protected void showPresetName(PartsSet requestPartsSet) {
        String title = this.getSuggestPartsSetName(requestPartsSet, true);
        if (title == null) {
            title = this.defaultPartsSetTitle;
        }
        this.previewPane.setTitle(title);
    }

    private String getSuggestPartsSetName(PartsSet requestPartsSet, boolean markColorOrCustomLayerChange) {
        String partsSetTitle = null;
        if (this.lastUsePresetParts != null && PartsSet.isSameStructure(requestPartsSet, this.lastUsePresetParts)) {
            partsSetTitle = this.lastUsePresetParts.getLocalizedName();
            if (!(!markColorOrCustomLayerChange || PartsSet.isSameColor(requestPartsSet, this.lastUsePresetParts) && PartsSet.isSameCustomLayers(requestPartsSet, this.lastUsePresetParts) || partsSetTitle == null)) {
                partsSetTitle = partsSetTitle + "*";
            }
        }
        if (partsSetTitle != null && partsSetTitle.trim().length() > 0) {
            return partsSetTitle;
        }
        return null;
    }

    protected void requestPreview() {
        if (!this.characterData.isValid()) {
            return;
        }
        this.imageBuilder.requestJob(new ImageBuildJobAbstractAdaptor(this.characterData){
            private PartsSet requestPartsSet;
            private LayerOrderMapper layerOrderMapper;
            private long ticket;

            @Override
            public void onQueueing(long ticket) {
                this.ticket = ticket;
                MainFrame.this.previewPane.setLoadingRequest(ticket);
            }

            @Override
            public void buildImage(ImageBuilder.ImageOutput output) {
                final BufferedImage img = output.getImageOutput();
                Runnable refreshJob = new Runnable(){

                    @Override
                    public void run() {
                        MainFrame.this.previewPane.setPreviewImage(img);
                        MainFrame.this.previewPane.setLoadingComplete(ticket);
                        MainFrame.this.showPresetName(requestPartsSet);
                        if (MainFrame.this.informationDialog != null) {
                            MainFrame.this.informationDialog.showPartsInformation(requestPartsSet, layerOrderMapper);
                        }
                    }
                };
                if (SwingUtilities.isEventDispatchThread()) {
                    refreshJob.run();
                } else {
                    try {
                        SwingUtilities.invokeAndWait(refreshJob);
                    }
                    catch (Exception ex) {
                        logger.log(Level.WARNING, "build image failed.", ex);
                    }
                }
            }

            @Override
            public void handleException(final Throwable ex) {
                Runnable showExceptionJob = new Runnable(){

                    @Override
                    public void run() {
                        ErrorMessageHelper.showErrorDialog(MainFrame.this, ex);
                    }
                };
                if (SwingUtilities.isEventDispatchThread()) {
                    showExceptionJob.run();
                } else {
                    SwingUtilities.invokeLater(showExceptionJob);
                }
            }

            @Override
            protected PartsSet getPartsSet() {
                Runnable collectPartsSetJob = new Runnable(){

                    @Override
                    public void run() {
                        requestPartsSet = MainFrame.this.partsSelectionManager.createPartsSet();
                        layerOrderMapper = MainFrame.this.customLayerPatternMgr.getLayerOrderMapper();
                    }
                };
                if (SwingUtilities.isEventDispatchThread()) {
                    collectPartsSetJob.run();
                } else {
                    try {
                        SwingUtilities.invokeAndWait(collectPartsSetJob);
                    }
                    catch (InvocationTargetException e) {
                        throw new RuntimeException(e.getMessage(), e);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException("interrupted:" + e, e);
                    }
                }
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "preview: " + this.requestPartsSet);
                }
                return this.requestPartsSet;
            }

            @Override
            protected LayerOrderMapper getLayerOrderMapper() {
                return this.layerOrderMapper;
            }
        });
    }

    protected void onOpenProfile() {
        try {
            MainFrame main2 = ProfileListManager.openProfile(this);
            if (main2 != null) {
                main2.showMainFrame();
            }
        }
        catch (Exception ex) {
            ErrorMessageHelper.showErrorDialog(this, ex);
        }
    }

    protected void onChangeBgColor() {
        this.getJMenuBar().setEnabled(false);
        try {
            Properties strings = LocalizedResourcePropertyLoader.getCachedInstance().getLocalizedProperties(STRINGS_RESOURCE);
            Color color = this.wallpaperInfo.getBackgroundColor();
            color = JColorChooser.showDialog(this, strings.getProperty("chooseBgColor"), color);
            if (color != null) {
                this.applyBackgroundColorOnly(color);
            }
        }
        finally {
            this.getJMenuBar().setEnabled(true);
        }
    }

    protected void onChangeWallpaper() {
        try {
            WallpaperDialog wallpaperDialog = new WallpaperDialog(this);
            wallpaperDialog.setWallpaperInfo(this.wallpaperInfo);
            WallpaperInfo wallpaperInfo = wallpaperDialog.showDialog();
            if (wallpaperInfo == null) {
                return;
            }
            this.applyWallpaperInfo(wallpaperInfo, false);
        }
        catch (WallpaperFactoryException ex) {
            ErrorMessageHelper.showErrorDialog(this, ex);
        }
        catch (RuntimeException ex) {
            ErrorMessageHelper.showErrorDialog(this, ex);
        }
    }

    protected void applyBackgroundColorOnly(Color bgColor) {
        this.wallpaperInfo.setBackgroundColor(bgColor);
        this.previewPane.getWallpaper().setBackgroundColor(this.wallpaperInfo.getBackgroundColor());
    }

    protected void applyWallpaperInfo(WallpaperInfo wallpaperInfo, boolean ignoreError) throws WallpaperFactoryException {
        Wallpaper wallpaper;
        block7: {
            if (wallpaperInfo == null) {
                throw new IllegalArgumentException();
            }
            WallpaperFactory wallpaperFactory = WallpaperFactory.getInstance();
            wallpaper = null;
            try {
                WallpaperFactoryErrorRecoverHandler handler = null;
                if (ignoreError) {
                    handler = new WallpaperFactoryErrorRecoverHandler();
                }
                wallpaper = wallpaperFactory.createWallpaper(wallpaperInfo, handler);
            }
            catch (WallpaperFactoryException ex) {
                logger.log(Level.WARNING, "\u58c1\u7d19\u60c5\u5831\u306e\u9069\u7528\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", ex);
                if (!ignoreError) {
                    throw ex;
                }
            }
            catch (RuntimeException ex) {
                logger.log(Level.WARNING, "\u58c1\u7d19\u60c5\u5831\u306e\u9069\u7528\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", ex);
                if (ignoreError) break block7;
                throw ex;
            }
        }
        if (wallpaper == null) {
            return;
        }
        this.previewPane.setWallpaper(wallpaper);
        this.wallpaperInfo = wallpaperInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onSavePicture() {
        Toolkit tk = Toolkit.getDefaultToolkit();
        BufferedImage img = this.previewPane.getPreviewImage();
        Color imgBgColor = this.wallpaperInfo.getBackgroundColor();
        if (img == null) {
            tk.beep();
            return;
        }
        try {
            OutputOption outputOption = this.imageSaveHelper.getOutputOption();
            outputOption.setZoomFactor(this.previewPane.getZoomFactor());
            outputOption.changeRecommend();
            this.imageSaveHelper.setOutputOption(outputOption);
            File outFile = this.imageSaveHelper.showSaveFileDialog(this);
            if (outFile == null) {
                return;
            }
            logger.log(Level.FINE, "savePicture: " + outFile);
            logger.log(Level.FINE, "outputOption: " + outputOption);
            StringBuilder warnings = new StringBuilder();
            this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                this.imageSaveHelper.savePicture(img, imgBgColor, outFile, warnings);
            }
            finally {
                this.setCursor(Cursor.getDefaultCursor());
            }
            if (warnings.length() > 0) {
                JOptionPane.showMessageDialog(this, warnings.toString(), "WARNINGS", 2);
            }
        }
        catch (Exception ex) {
            ErrorMessageHelper.showErrorDialog(this, ex);
        }
    }

    protected void onSaveAsUkagaka() {
        BufferedImage img = this.previewPane.getPreviewImage();
        Color bgColor = this.wallpaperInfo.getBackgroundColor();
        if (img == null) {
            Toolkit tk = Toolkit.getDefaultToolkit();
            tk.beep();
            return;
        }
        try {
            this.ukagakaImageSaveHelper.save(this, img, bgColor);
        }
        catch (IOException ex) {
            ErrorMessageHelper.showErrorDialog(this, ex);
        }
    }

    protected void onConvertUkagaka() {
        try {
            Color colorKey = this.wallpaperInfo.getBackgroundColor();
            this.ukagakaImageSaveHelper.convertChooseFiles(this, colorKey);
        }
        catch (IOException ex) {
            ErrorMessageHelper.showErrorDialog(this, ex);
        }
    }

    protected void onBrowseProfileDir() {
        if (!this.characterData.isValid()) {
            Toolkit tk = Toolkit.getDefaultToolkit();
            tk.beep();
            return;
        }
        try {
            DesktopUtilities.browseBaseDir(this.characterData.getDocBase());
        }
        catch (Exception ex) {
            ErrorMessageHelper.showErrorDialog(this, ex);
        }
    }

    protected void onEditProfile() {
        if (!this.characterData.isValid()) {
            Toolkit tk = Toolkit.getDefaultToolkit();
            tk.beep();
            return;
        }
        try {
            CharacterData cd = this.characterData;
            CharacterData newCd = ProfileListManager.editProfile(this, cd);
            if (newCd != null) {
                CharacterDataChangeObserver.getDefault().notifyCharacterDataChange(this, newCd, true, true);
            }
        }
        catch (Exception ex) {
            ErrorMessageHelper.showErrorDialog(this, ex);
        }
    }

    protected void onManageParts() {
        if (!this.characterData.isValid()) {
            Toolkit tk = Toolkit.getDefaultToolkit();
            tk.beep();
            return;
        }
        PartsManageDialog mrgDlg = new PartsManageDialog(this, this.characterData);
        mrgDlg.setVisible(true);
        if (mrgDlg.isUpdated() && this.characterData.reloadPartsData()) {
            this.partsSelectionManager.loadParts();
            this.requestPreview();
        }
    }

    protected void openSearchDialog() {
        if (!this.characterData.isValid()) {
            Toolkit tk = Toolkit.getDefaultToolkit();
            tk.beep();
            return;
        }
        if (this.lastUseSearchPartsDialog != null && this.lastUseSearchPartsDialog.isDisplayable() && this.lastUseSearchPartsDialog.isVisible()) {
            this.lastUseSearchPartsDialog.requestFocus();
            return;
        }
        SearchPartsDialog searchPartsDlg = new SearchPartsDialog(this, this.characterData, this.partsSelectionManager);
        WindowAdjustLocationSupport.alignRight(this, searchPartsDlg, 0, true);
        searchPartsDlg.setVisible(true);
        this.lastUseSearchPartsDialog = searchPartsDlg;
    }

    protected void closeSearchDialog() {
        this.lastUseSearchPartsDialog = null;
        for (SearchPartsDialog dlg : SearchPartsDialog.getDialogs()) {
            if (dlg == null || !dlg.isDisplayable() || dlg.getParent() != this) continue;
            dlg.dispose();
        }
    }

    protected void closeManageFavoritesDialog() {
        if (this.lastUseManageFavoritesDialog != null) {
            if (this.lastUseManageFavoritesDialog.isDisplayable()) {
                this.lastUseManageFavoritesDialog.dispose();
            }
            this.lastUseManageFavoritesDialog = null;
        }
    }

    protected void closePartsRandomChooserDialog() {
        if (this.lastUsePartsRandomChooserDialog != null) {
            if (this.lastUsePartsRandomChooserDialog.isDisplayable()) {
                this.lastUsePartsRandomChooserDialog.dispose();
            }
            this.lastUsePartsRandomChooserDialog = null;
        }
    }

    protected void closeInformationDialog() {
        if (this.informationDialog != null) {
            this.informationDialog.dispose();
            this.informationDialog = null;
        }
    }

    protected void onCopy(boolean screenImage) {
        try {
            BufferedImage img = this.previewPane.getPreviewImage();
            if (img == null) {
                Toolkit tk = Toolkit.getDefaultToolkit();
                tk.beep();
                return;
            }
            if (screenImage) {
                img = this.previewPane.getScreenImage();
            }
            Color imgBgColor = this.wallpaperInfo.getBackgroundColor();
            ClipboardUtil.setImage(img, imgBgColor);
        }
        catch (Exception ex) {
            ErrorMessageHelper.showErrorDialog(this, ex);
        }
    }

    public void onPreferences() {
        AppConfigDialog appConfigDlg = new AppConfigDialog(this);
        appConfigDlg.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onImportNew() {
        block6: {
            if (!this.characterData.isValid()) {
                Toolkit tk = Toolkit.getDefaultToolkit();
                tk.beep();
                return;
            }
            try {
                CharacterData cd;
                ImportWizardDialog importWizDialog = new ImportWizardDialog(this, null, null);
                importWizDialog.setVisible(true);
                int exitCode = importWizDialog.getExitCode();
                if (exitCode != 2 || (cd = importWizDialog.getImportedCharacterData()) == null || !cd.isValid()) break block6;
                this.setCursor(Cursor.getPredefinedCursor(3));
                try {
                    MainFrame mainFrame = ProfileListManager.openProfile(cd);
                    mainFrame.setVisible(true);
                }
                finally {
                    this.setCursor(Cursor.getDefaultCursor());
                }
            }
            catch (Exception ex) {
                ErrorMessageHelper.showErrorDialog(this, ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onImport(List<File> initFiles) {
        if (!this.characterData.isValid()) {
            Toolkit tk = Toolkit.getDefaultToolkit();
            tk.beep();
            return;
        }
        try {
            this.watchAgent.suspend();
            try {
                ImportWizardDialog importWizDialog = new ImportWizardDialog(this, this.characterData, initFiles);
                importWizDialog.setVisible(true);
                if (importWizDialog.getExitCode() == 1) {
                    CharacterData importedCd = importWizDialog.getImportedCharacterData();
                    CharacterDataChangeObserver.getDefault().notifyCharacterDataChange(this, importedCd, false, true);
                }
            }
            finally {
                this.watchAgent.resume();
            }
        }
        catch (Exception ex) {
            ErrorMessageHelper.showErrorDialog(this, ex);
        }
    }

    protected synchronized void reloadPartsAndFavorites(CharacterData newCd, boolean forceRepaint) throws IOException {
        if (newCd != null) {
            this.characterData.setDescription(newCd.getDescription());
        }
        if (!this.characterData.isPartsLoaded()) {
            ProfileListManager.loadCharacterData(this.characterData);
            ProfileListManager.loadFavorites(this.characterData);
            this.partsSelectionManager.loadParts();
        } else {
            if (this.characterData.reloadPartsData()) {
                this.partsSelectionManager.loadParts();
            }
            CharacterDataPersistent persiste = CharacterDataPersistent.getInstance();
            persiste.loadFavorites(this.characterData);
            FavoritesChangeObserver.getDefault().notifyFavoritesChange(this, this.characterData);
        }
        if (this.showDefaultParts(false) || forceRepaint) {
            this.requestPreview();
        }
    }

    protected void onExport() {
        if (!this.characterData.isValid()) {
            Toolkit tk = Toolkit.getDefaultToolkit();
            tk.beep();
            return;
        }
        ExportWizardDialog exportWizDlg = new ExportWizardDialog(this, this.characterData, this.previewPane.getPreviewImage());
        exportWizDlg.setVisible(true);
    }

    protected void onResetColor() {
        if (!this.characterData.isValid()) {
            Toolkit tk = Toolkit.getDefaultToolkit();
            tk.beep();
            return;
        }
        Properties strings = LocalizedResourcePropertyLoader.getCachedInstance().getLocalizedProperties(STRINGS_RESOURCE);
        if (JOptionPane.showConfirmDialog(this, strings.get("confirm.resetcolors"), strings.getProperty("confirm"), 0, 3) != 0) {
            return;
        }
        this.characterData.getPartsColorManager().resetPartsColorInfo();
        this.partsColorCoordinator.initColorDialog();
        this.requestPreview();
    }

    protected void onCloseProfile() {
        this.saveWorkingSet();
        ProfileListManager.unregisterUsedCharacterData(this.characterData);
        if (this.characterData.isValid()) {
            try {
                RecentDataPersistent recentPersist = RecentDataPersistent.getInstance();
                recentPersist.saveRecent(this.characterData);
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, "recent data saving failed.", ex);
            }
        }
        this.stopAgents();
        this.dispose();
        logger.log(Level.FINE, "dispose mainframe.");
    }

    public static void closeAllProfiles() {
        MainFrame mainFrame = activedMainFrame;
        SystemUtil.gc();
        for (Frame frame : JFrame.getFrames()) {
            try {
                if (!frame.isDisplayable() || !(frame instanceof MainFrame) || frame == mainFrame) continue;
                ((MainFrame)frame).onCloseProfile();
            }
            catch (Throwable ex) {
                logger.log(Level.SEVERE, "mainframe closing failed.", ex);
            }
        }
        if (activedMainFrame != null && activedMainFrame.isDisplayable()) {
            try {
                activedMainFrame.onCloseProfile();
            }
            catch (Throwable ex) {
                logger.log(Level.SEVERE, "mainframe closing failed.", ex);
            }
        }
    }

    protected void saveWorkingSet() {
        if (!this.characterData.isValid()) {
            return;
        }
        try {
            WorkingSet workingSet = new WorkingSet();
            workingSet.setCharacterDocBase(this.characterData.getDocBase());
            workingSet.setCharacterDataRev(this.characterData.getRev());
            PartsSet partsSet = this.partsSelectionManager.createPartsSet();
            workingSet.setCurrentPartsSet(partsSet);
            workingSet.setPartsColorInfoMap(this.characterData.getPartsColorManager().getPartsColorInfoMap());
            workingSet.setLastUsedSaveDir(this.imageSaveHelper.getLastUsedSaveDir());
            workingSet.setLastUsedExportDir(ExportWizardDialog.getLastUsedDir());
            workingSet.setLastUsePresetParts(this.lastUsePresetParts);
            workingSet.setCharacterData(this.characterData.duplicateBasicInfo(false));
            workingSet.setWallpaperInfo(this.wallpaperInfo);
            workingSet.setZoomFactor(this.previewPane.getZoomFactor());
            workingSet.setViewPosition(this.previewPane.getViewPosition());
            Dimension windowSize = this.getSize();
            Point windowPos = this.getLocation();
            Rectangle windowRect = new Rectangle(windowPos, windowSize);
            workingSet.setWindowRect(windowRect);
            WorkingSetPersist workingSetPersist = WorkingSetPersist.getInstance();
            workingSetPersist.saveWorkingSet(workingSet);
        }
        catch (Exception ex) {
            ErrorMessageHelper.showErrorDialog(this, ex);
        }
    }

    protected void loadCustomLayerOrder() {
        try {
            CustomLayerOrderPersist persist = CustomLayerOrderPersist.newInstance(this.characterData);
            Map<CustomLayerOrderKey, List<CustomLayerOrder>> map = persist.load();
            if (map != null) {
                this.customLayerPatternMgr.setMap(map);
            }
        }
        catch (Exception ex) {
            ErrorMessageHelper.showErrorDialog(this, ex);
        }
    }

    protected boolean loadWorkingSet() {
        if (!this.characterData.isValid()) {
            return false;
        }
        try {
            WorkingSetPersist workingSetPersist = WorkingSetPersist.getInstance();
            WorkingSet workingSet = workingSetPersist.loadWorkingSet(this.characterData);
            if (workingSet == null) {
                return false;
            }
            AppConfig appConfig = AppConfig.getInstance();
            Rectangle windowRect = workingSet.getWindowRect();
            if (appConfig.isEnableRestoreWindow() && windowRect != null) {
                Point windowPos;
                GraphicsEnvironment genv = GraphicsEnvironment.getLocalGraphicsEnvironment();
                Rectangle desktopSize = genv.getMaximumWindowBounds();
                if (desktopSize.contains(windowPos = windowRect.getLocation())) {
                    this.setLocation(windowPos);
                }
                Dimension dim = windowRect.getSize();
                if (dim.width < 100) {
                    dim.width = 100;
                }
                if (dim.height < 100) {
                    dim.height = 100;
                }
                this.setSize(dim);
            } else {
                this.setDefaultWindowLocation();
            }
            Map<PartsIdentifier, PartsColorInfo> partsColorInfoMap = this.characterData.getPartsColorManager().getPartsColorInfoMap();
            partsColorInfoMap.putAll(workingSet.getPartsColorInfoMap());
            PartsSet partsSet = workingSet.getCurrentPartsSet();
            if (partsSet != null) {
                this.selectPresetParts(partsSet);
                PartsSet lastUsePresetParts = workingSet.getLastUsePresetParts();
                if (lastUsePresetParts != null && lastUsePresetParts.isSameStructure(partsSet)) {
                    this.lastUsePresetParts = lastUsePresetParts;
                    this.showPresetName(lastUsePresetParts);
                }
            }
            this.imageSaveHelper.setLastUseSaveDir(workingSet.getLastUsedSaveDir());
            ExportWizardDialog.setLastUsedDir(workingSet.getLastUsedExportDir());
            WallpaperInfo wallpaperInfo = workingSet.getWallpaperInfo();
            if (wallpaperInfo != null) {
                this.applyWallpaperInfo(wallpaperInfo, true);
            }
            Double zoomFactor = workingSet.getZoomFactor();
            if (appConfig.isEnableRestoreWindow() && zoomFactor != null) {
                this.previewPane.setZoomFactor(zoomFactor);
                Point viewPosition = workingSet.getViewPosition();
                if (viewPosition != null) {
                    this.previewPane.setViewPosition(viewPosition);
                }
            }
            return true;
        }
        catch (Exception ex) {
            ErrorMessageHelper.showErrorDialog(this, ex);
            return false;
        }
    }

    public void onAbout() {
        try {
            AboutBox aboutBox = new AboutBox(this);
            aboutBox.showAboutBox();
        }
        catch (Exception ex) {
            ErrorMessageHelper.showErrorDialog(this, ex);
        }
    }

    protected void onHelp() {
        Properties strings = LocalizedResourcePropertyLoader.getCachedInstance().getLocalizedProperties(STRINGS_RESOURCE);
        String helpURL = strings.getProperty("help.url");
        String helpDescription = strings.getProperty("help.show");
        DesktopUtilities.browse(this, helpURL, helpDescription);
    }

    protected void onFlipHolizontal() {
        if (!this.characterData.isValid()) {
            Toolkit tk = Toolkit.getDefaultToolkit();
            tk.beep();
            return;
        }
        double[] affineTransformParameter = this.partsSelectionManager.getAffineTransformParameter();
        if (affineTransformParameter == null) {
            Dimension siz = this.characterData.getImageSize();
            if (siz != null) {
                affineTransformParameter = new double[]{-1.0, 0.0, 0.0, 1.0, siz.width, 0.0};
            }
        } else {
            affineTransformParameter = null;
        }
        this.partsSelectionManager.setAffineTransformParameter(affineTransformParameter);
        this.requestPreview();
    }

    protected void onSetDefaultPicture() {
        if (!this.characterData.isValid()) {
            Toolkit tk = Toolkit.getDefaultToolkit();
            tk.beep();
            return;
        }
        try {
            BufferedImage samplePicture = this.previewPane.getPreviewImage();
            if (samplePicture != null) {
                CharacterDataPersistent persist = CharacterDataPersistent.getInstance();
                persist.saveSamplePicture(this.characterData, samplePicture);
            }
        }
        catch (Exception ex) {
            ErrorMessageHelper.showErrorDialog(this, ex);
        }
    }

    protected void onInformation() {
        if (!this.characterData.isValid()) {
            Toolkit tk = Toolkit.getDefaultToolkit();
            tk.beep();
            return;
        }
        PartsSet partsSet = this.partsSelectionManager.createPartsSet();
        LayerOrderMapper layerOrderMapper = this.customLayerPatternMgr.getLayerOrderMapper();
        if (this.informationDialog == null) {
            this.informationDialog = new InformationDialog(this, this.characterData, new Runnable(){

                @Override
                public void run() {
                    MainFrame.this.closeInformationDialog();
                }
            });
        }
        this.informationDialog.showPartsInformation(partsSet, layerOrderMapper);
        this.informationDialog.setVisible(true);
    }

    protected void onManageCustomLayer() {
        List<PartsCategory> categories = this.characterData.getPartsCategories();
        final LayerOrderCustomizeDialog layerOrderCustomDlg = new LayerOrderCustomizeDialog((Window)this, categories);
        layerOrderCustomDlg.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        layerOrderCustomDlg.addLayerOrderCustomizeListener(new LayerOrderCustomizeDialog.LayerOrderCustomizeListener(){

            @Override
            public void onChange(LayerOrderCustomizeDialog.LayerOrderCustomizeListener.Change e) {
                MainFrame.this.customLayerPatternMgr.initCustomLayerOrderMap(layerOrderCustomDlg.getEdittingCustomLayerOrderList());
                MainFrame.this.requestPreview();
            }
        });
        final LayerOrderCustomizeDialogModel layerOrderCustomDialogModel = new LayerOrderCustomizeDialogModel();
        for (Map.Entry<CustomLayerOrderKey, List<CustomLayerOrder>> entry : this.customLayerPatternMgr.getOrderedEntries()) {
            CustomLayerOrderKey orderKey = entry.getKey();
            List<CustomLayerOrder> customLayerOrderList = entry.getValue();
            layerOrderCustomDialogModel.put(orderKey, customLayerOrderList);
        }
        List<CustomLayerOrder> currentList = this.customLayerPatternMgr.getActiveCustomLayerOrderList();
        layerOrderCustomDialogModel.setCurrentList(currentList);
        layerOrderCustomDlg.setModel(layerOrderCustomDialogModel);
        layerOrderCustomDialogModel.addListChangeListener(new LayerOrderCustomizeDialogModel.ChangeListener(){

            @Override
            public void onChange(LayerOrderCustomizeDialogModel.ChangeListener.Change change) {
                try {
                    HashMap<CustomLayerOrderKey, List<CustomLayerOrder>> customLayerPatternMap = new HashMap<CustomLayerOrderKey, List<CustomLayerOrder>>();
                    for (CustomLayerOrderKey patternKey : layerOrderCustomDialogModel.getPatternNames()) {
                        ObservableList<CustomLayerOrder> customLayerOrderList = layerOrderCustomDialogModel.getCopy(patternKey);
                        if (customLayerOrderList == null) continue;
                        customLayerPatternMap.put(patternKey, customLayerOrderList);
                    }
                    MainFrame.this.customLayerPatternMgr.setMap(customLayerPatternMap);
                    CustomLayerOrderPersist persist = CustomLayerOrderPersist.newInstance(MainFrame.this.characterData);
                    persist.save(customLayerPatternMap);
                }
                catch (Exception ex) {
                    ErrorMessageHelper.showErrorDialog(MainFrame.this, ex);
                }
            }
        });
        layerOrderCustomDlg.setLocationByPlatform(true);
        layerOrderCustomDlg.setVisible(true);
        CustomLayerOrderKey lastPatternName = layerOrderCustomDlg.getLastPatternName();
        if (lastPatternName != null) {
            this.customLayerPatternMgr.setSelected(lastPatternName, true);
        }
        this.customLayerPatternMgr.initActiveCustomLayerOrderMap();
        this.requestPreview();
    }

    protected void onManageFavorites() {
        if (!this.characterData.isValid()) {
            Toolkit tk = Toolkit.getDefaultToolkit();
            tk.beep();
            return;
        }
        if (this.lastUseManageFavoritesDialog != null && this.lastUseManageFavoritesDialog.isDisplayable() && this.lastUseManageFavoritesDialog.isVisible()) {
            this.lastUseManageFavoritesDialog.requestFocus();
            return;
        }
        ManageFavoriteDialog dlg = new ManageFavoriteDialog(this, this.characterData);
        dlg.setFavoriteManageCallback(new ManageFavoriteDialog.FavoriteManageCallback(){

            @Override
            public void selectFavorites(PartsSet partsSet) {
                MainFrame.this.selectPresetParts(partsSet);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updateFavorites(CharacterData characterData, boolean savePreset) {
                try {
                    MainFrame.this.setCursor(Cursor.getPredefinedCursor(3));
                    try {
                        CharacterDataPersistent persiste = CharacterDataPersistent.getInstance();
                        if (savePreset) {
                            persiste.updateProfile(characterData);
                        }
                        persiste.saveFavorites(characterData);
                        FavoritesChangeObserver.getDefault().notifyFavoritesChange(MainFrame.this, characterData);
                    }
                    finally {
                        MainFrame.this.setCursor(Cursor.getDefaultCursor());
                    }
                }
                catch (Exception ex) {
                    ErrorMessageHelper.showErrorDialog(MainFrame.this, ex);
                }
            }
        });
        WindowAdjustLocationSupport.alignRight(this, dlg, 0, true);
        dlg.setVisible(true);
        this.lastUseManageFavoritesDialog = dlg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onRegisterFavorite() {
        if (!this.characterData.isValid()) {
            Toolkit tk = Toolkit.getDefaultToolkit();
            tk.beep();
            return;
        }
        try {
            PartsSet partsSet = this.partsSelectionManager.createPartsSet();
            if (partsSet.isEmpty()) {
                return;
            }
            Properties strings = LocalizedResourcePropertyLoader.getCachedInstance().getLocalizedProperties(STRINGS_RESOURCE);
            String initName = this.getSuggestPartsSetName(partsSet, false);
            JCheckBox chkColorInfo = new JCheckBox(strings.getProperty("input.favoritesColorInfo"));
            chkColorInfo.setSelected(true);
            String partsSetId = null;
            if (initName != null && this.lastUsePresetParts != null) {
                partsSetId = this.lastUsePresetParts.getPartsSetId();
            }
            JCheckBox chkOverwrite = new JCheckBox(strings.getProperty("input.favoritesOverwrite"));
            chkOverwrite.setSelected(partsSetId != null && partsSetId.length() > 0);
            chkOverwrite.setEnabled(partsSetId != null && partsSetId.length() > 0);
            Box checkboxsPanel = new Box(3);
            checkboxsPanel.add(chkColorInfo);
            checkboxsPanel.add(chkOverwrite);
            String name = (String)JOptionPane.showInputDialog(this, checkboxsPanel, strings.getProperty("input.favorites"), 3, null, null, initName == null ? "" : initName);
            if (name == null || name.trim().length() == 0) {
                return;
            }
            boolean includeColorInfo = chkColorInfo.isSelected();
            if (!includeColorInfo) {
                partsSet.removeColorInfo();
                partsSet.setActiveCustomLayerPatternIds(null);
            }
            if (partsSetId == null || !chkOverwrite.isSelected()) {
                partsSetId = "ps" + UUID.randomUUID().toString();
            }
            partsSet.setPartsSetId(partsSetId);
            partsSet.setLocalizedName(name);
            this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                CharacterDataPersistent persiste = CharacterDataPersistent.getInstance();
                this.characterData.clearPartsSets(true);
                persiste.loadFavorites(this.characterData);
                this.characterData.addPartsSet(partsSet);
                persiste.saveFavorites(this.characterData);
                FavoritesChangeObserver.getDefault().notifyFavoritesChange(this, this.characterData);
            }
            finally {
                this.setCursor(Cursor.getDefaultCursor());
            }
            this.lastUsePresetParts = partsSet;
            this.showPresetName(partsSet);
        }
        catch (Exception ex) {
            ErrorMessageHelper.showErrorDialog(this, ex);
        }
    }

    protected void onToolRandom() {
        if (!this.characterData.isValid()) {
            Toolkit tk = Toolkit.getDefaultToolkit();
            tk.beep();
            return;
        }
        if (this.lastUsePartsRandomChooserDialog != null && this.lastUsePartsRandomChooserDialog.isDisplayable() && this.lastUsePartsRandomChooserDialog.isVisible()) {
            this.lastUsePartsRandomChooserDialog.requestFocus();
            return;
        }
        PartsRandomChooserDialog dlg = new PartsRandomChooserDialog(this, this.characterData, new PartsRandomChooserDialog.PartsSetSynchronizer(){

            @Override
            public PartsSet getCurrentPartsSet() {
                return MainFrame.this.partsSelectionManager.createPartsSet();
            }

            @Override
            public void setPartsSet(PartsSet partsSet) {
                MainFrame.this.selectPresetParts(partsSet);
            }

            @Override
            public boolean isExcludePartsIdentifier(PartsIdentifier partsIdentifier) {
                Boolean exclude = (Boolean)MainFrame.this.randomExcludePartsIdentifierMap.get(partsIdentifier);
                return exclude != null && exclude != false;
            }

            @Override
            public void setExcludePartsIdentifier(PartsIdentifier partsIdentifier, boolean exclude) {
                MainFrame.this.randomExcludePartsIdentifierMap.put(partsIdentifier, exclude);
            }
        });
        WindowAdjustLocationSupport.alignRight(this, dlg, 0, true);
        dlg.setVisible(true);
        this.lastUsePartsRandomChooserDialog = dlg;
    }

    protected void onDeselectAll() {
        this.partsSelectionManager.deselectAll();
    }

    protected void onDeselectableAllCategory() {
        this.partsSelectionManager.setDeselectableSingleCategory(!this.partsSelectionManager.isDeselectableSingleCategory());
    }

    protected void onEnableZoom() {
        this.previewPane.setVisibleZoomBox(!this.previewPane.isVisibleZoomBox());
    }

    protected JMenuBar createMenuBar() {
        Properties strings = LocalizedResourcePropertyLoader.getCachedInstance().getLocalizedProperties(STRINGS_RESOURCE);
        MenuDataFactory[] menus = new MenuDataFactory[]{new MenuDataFactory("menu.file", new MenuDataFactory[]{new MenuDataFactory("file.openProfile", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.onOpenProfile();
            }
        }), new MenuDataFactory("file.savePicture", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.onSavePicture();
            }
        }), new MenuDataFactory("file.ukagaka", new MenuDataFactory[]{new MenuDataFactory("file.saveAsUkagaka", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.onSaveAsUkagaka();
            }
        }), new MenuDataFactory("file.convertUkagaka", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.onConvertUkagaka();
            }
        })}), null, new MenuDataFactory("file.editprofile", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.onEditProfile();
            }
        }), new MenuDataFactory("file.opendir", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.onBrowseProfileDir();
            }
        }), new MenuDataFactory("file.import", new MenuDataFactory[]{new MenuDataFactory("file.importMe", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.onImport(null);
            }
        }), new MenuDataFactory("file.importNew", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.onImportNew();
            }
        })}), new MenuDataFactory("file.export", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.onExport();
            }
        }), new MenuDataFactory("file.manageParts", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.onManageParts();
            }
        }), new MenuDataFactory("file.preferences", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.onPreferences();
            }
        }), null, new MenuDataFactory("file.closeProfile", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.onCloseProfile();
            }
        })}), new MenuDataFactory("menu.edit", new MenuDataFactory[]{new MenuDataFactory("edit.search", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.openSearchDialog();
            }
        }), new MenuDataFactory("edit.copy", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.onCopy((e.getModifiers() & 1) != 0);
            }
        }), new MenuDataFactory("edit.flipHorizontal", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.onFlipHolizontal();
            }
        }), new MenuDataFactory("edit.resetcolor", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.onResetColor();
            }
        }), null, new MenuDataFactory("edit.setDefaultPicture", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.onSetDefaultPicture();
            }
        }), new MenuDataFactory("edit.information", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.onInformation();
            }
        }), null, new MenuDataFactory("edit.deselectall", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.onDeselectAll();
            }
        }), new MenuDataFactory("edit.deselectparts", true, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.onDeselectableAllCategory();
            }
        }), new MenuDataFactory("edit.enableAutoShrink", true, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.onClickPartsCategoryTitle(null, true);
            }
        }), null, new MenuDataFactory("edit.enableZoomBox", true, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.onEnableZoom();
            }
        }), null, new MenuDataFactory("edit.changeBgColor", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.onChangeBgColor();
            }
        }), new MenuDataFactory("edit.changeWallpaper", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.onChangeWallpaper();
            }
        })}), new MenuDataFactory("menu.customlayer", new MenuDataFactory[]{new MenuDataFactory("customlayer.manage", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.onManageCustomLayer();
            }
        }), null}), new MenuDataFactory("menu.favorite", new MenuDataFactory[]{new MenuDataFactory("favorite.register", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.onRegisterFavorite();
            }
        }), new MenuDataFactory("favorite.manage", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.onManageFavorites();
            }
        }), null}), new MenuDataFactory("menu.tool", new MenuDataFactory[]{new MenuDataFactory("tool.random", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.onToolRandom();
            }
        })}), new MenuDataFactory("menu.help", new MenuDataFactory[]{new MenuDataFactory("help.recommendations", (ActionListener)null), null, new MenuDataFactory("help.help", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.onHelp();
            }
        }), new MenuDataFactory("help.forum", DesktopUtilities.createBrowseAction(this, strings.getProperty("help.forum.url"), strings.getProperty("help.forum.description"))), new MenuDataFactory("help.bugreport", DesktopUtilities.createBrowseAction(this, strings.getProperty("help.reportbugs.url"), strings.getProperty("help.reportbugs.description"))), new MenuDataFactory("help.about", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.onAbout();
            }
        })})};
        final MenuBuilder menuBuilder = new MenuBuilder();
        JMenuBar menuBar = menuBuilder.createMenuBar(menus);
        menuBuilder.getJMenu("menu.edit").addMenuListener(new MenuListener(){

            @Override
            public void menuCanceled(MenuEvent e) {
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuSelected(MenuEvent e) {
                menuBuilder.getJMenuItem("edit.copy").setEnabled(MainFrame.this.previewPane.getPreviewImage() != null);
                menuBuilder.getJMenuItem("edit.deselectparts").setSelected(MainFrame.this.partsSelectionManager.isDeselectableSingleCategory());
                menuBuilder.getJMenuItem("edit.enableAutoShrink").setSelected(MainFrame.this.minimizeMode);
                menuBuilder.getJMenuItem("edit.enableZoomBox").setSelected(MainFrame.this.previewPane.isVisibleZoomBox());
            }
        });
        final JMenu mnuFavorites = menuBuilder.getJMenu("menu.favorite");
        mnuFavorites.addMenuListener(new MenuListener(){

            @Override
            public void menuCanceled(MenuEvent e) {
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuSelected(MenuEvent e) {
                MainFrame.this.onSelectedFavoriteMenu(mnuFavorites);
            }
        });
        final JMenu mnuCustomLayer = menuBuilder.getJMenu("menu.customlayer");
        mnuCustomLayer.addMenuListener(new MenuListener(){

            @Override
            public void menuCanceled(MenuEvent e) {
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuSelected(MenuEvent e) {
                MainFrame.this.onSelectedCustomLayerMenu(mnuCustomLayer);
            }
        });
        if (System.getProperty("java.version").startsWith("1.5")) {
            menuBuilder.getJMenuItem("file.opendir").setEnabled(false);
        }
        final JMenu mnuRecomendation = menuBuilder.getJMenu("help.recommendations");
        JMenu mnuHelp = menuBuilder.getJMenu("menu.help");
        mnuHelp.addMenuListener(new MenuListener(){

            @Override
            public void menuCanceled(MenuEvent e) {
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuSelected(MenuEvent e) {
                MainFrame.this.onSelectedRecommendationMenu(mnuRecomendation);
            }
        });
        return menuBar;
    }

    protected static interface FavoriteMenuItemBuilder {
        public JMenuItem createFavoriteMenuItem(String var1, PartsSet var2);

        public JMenu createSubMenu(String var1);
    }

    protected static final class TreeLeaf
    implements Comparable<TreeLeaf> {
        private String name;
        private TreeLeafType typ;

        public TreeLeaf(TreeLeafType typ, String name) {
            if (name == null) {
                name = "";
            }
            this.typ = typ;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public TreeLeafType getTyp() {
            return this.typ;
        }

        public boolean equals(Object obj) {
            if (obj != null && obj instanceof TreeLeaf) {
                TreeLeaf o = (TreeLeaf)obj;
                return this.typ == o.typ && this.name.equals(o.name);
            }
            return false;
        }

        public int hashCode() {
            return this.typ.hashCode() ^ this.name.hashCode();
        }

        @Override
        public int compareTo(TreeLeaf o) {
            int ret = this.name.compareTo(o.name);
            if (ret == 0) {
                ret = this.typ.ordinal() - o.typ.ordinal();
            }
            return ret;
        }

        public String toString() {
            return this.name;
        }

        public static enum TreeLeafType {
            NODE,
            LEAF;

        }
    }
}

