/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.model.CharacterData;
import charactermanaj.model.CustomLayerOrder;
import charactermanaj.model.CustomLayerOrderKey;
import charactermanaj.model.PartsManageData;
import charactermanaj.model.io.CharacterDataDefaultProvider;
import charactermanaj.model.io.CharacterDataPersistent;
import charactermanaj.model.io.CustomLayerOrderPersist;
import charactermanaj.model.io.PartsDataLoader;
import charactermanaj.model.io.PartsDataLoaderFactory;
import charactermanaj.model.io.PartsInfoXMLReader;
import charactermanaj.model.io.PartsManageDataDecorateLoader;
import charactermanaj.model.io.PartsSpecDecorateLoader;
import charactermanaj.model.io.RecentDataPersistent;
import charactermanaj.ui.MainFrame;
import charactermanaj.ui.ProfileEditDialog;
import charactermanaj.ui.ProfileSelectorDialog;
import charactermanaj.util.ErrorMessageHelper;
import java.awt.Cursor;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JDialog;
import javax.swing.JFrame;

public final class ProfileListManager {
    private static final Logger logger = Logger.getLogger(ProfileListManager.class.getName());
    private static final HashMap<URI, Integer> activeCharacterDatas = new HashMap();

    private ProfileListManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isUsingCharacterData(CharacterData characterData) {
        URI characterDocBase = characterData == null ? null : characterData.getDocBase();
        HashMap<URI, Integer> hashMap = activeCharacterDatas;
        synchronized (hashMap) {
            Integer cnt = characterDocBase == null ? null : activeCharacterDatas.get(characterDocBase);
            return cnt != null && cnt > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerUsedCharacterData(CharacterData characterData) {
        if (characterData == null) {
            return;
        }
        HashMap<URI, Integer> hashMap = activeCharacterDatas;
        synchronized (hashMap) {
            URI characterDocBase = characterData.getDocBase();
            if (characterDocBase != null) {
                Integer cnt = activeCharacterDatas.get(characterDocBase);
                cnt = cnt == null ? Integer.valueOf(1) : Integer.valueOf(cnt + 1);
                activeCharacterDatas.put(characterDocBase, cnt);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterUsedCharacterData(CharacterData characterData) {
        if (characterData == null) {
            return;
        }
        HashMap<URI, Integer> hashMap = activeCharacterDatas;
        synchronized (hashMap) {
            Integer cnt;
            URI characterDocBase = characterData.getDocBase();
            if (characterDocBase != null && (cnt = activeCharacterDatas.get(characterDocBase)) != null) {
                if ((cnt = Integer.valueOf(cnt - 1)) <= 0) {
                    activeCharacterDatas.remove(characterDocBase);
                } else {
                    activeCharacterDatas.put(characterDocBase, cnt);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MainFrame openProfile(JFrame parent) throws IOException {
        MainFrame newFrame;
        CharacterDataPersistent persist = CharacterDataPersistent.getInstance();
        List<CharacterData> characterDatas = persist.listProfiles(new CharacterDataPersistent.ProfileListErrorHandler(){

            @Override
            public void occureException(File baseDir, Throwable ex) {
                logger.log(Level.WARNING, "invalid profile. :" + baseDir, ex);
            }
        });
        ProfileSelectorDialog selDlg = new ProfileSelectorDialog(parent, characterDatas);
        selDlg.setVisible(true);
        CharacterData characterData = selDlg.getSelectedCharacterData();
        if (characterData == null || !characterData.isValid()) {
            return null;
        }
        parent.setCursor(Cursor.getPredefinedCursor(3));
        try {
            newFrame = ProfileListManager.openProfile(characterData);
        }
        finally {
            parent.setCursor(Cursor.getDefaultCursor());
        }
        return newFrame;
    }

    public static MainFrame openProfile(CharacterData characterData) throws IOException {
        if (characterData == null || !characterData.isValid()) {
            throw new IOException("\u958b\u304f\u3053\u3068\u306e\u3067\u304d\u306a\u3044\u30ad\u30e3\u30e9\u30af\u30bf\u30fc\u30c7\u30fc\u30bf\u3067\u3059\u3002:" + characterData);
        }
        ProfileListManager.prepare(characterData);
        ProfileListManager.loadCharacterData(characterData);
        ProfileListManager.loadFavorites(characterData);
        MainFrame newFrame = new MainFrame(characterData);
        ProfileListManager.saveRecent(characterData);
        return newFrame;
    }

    public static CharacterData editProfile(final JDialog parent, CharacterData characterData) throws IOException {
        return ProfileListManager.internalEditProfile(characterData, new ProfileEditorDialogFactory(){

            @Override
            public ProfileEditDialog create(CharacterData characterData) {
                return new ProfileEditDialog(parent, characterData);
            }
        });
    }

    public static CharacterData editProfile(final JFrame parent, CharacterData characterData) throws IOException {
        return ProfileListManager.internalEditProfile(characterData, new ProfileEditorDialogFactory(){

            @Override
            public ProfileEditDialog create(CharacterData characterData) {
                return new ProfileEditDialog(parent, characterData);
            }
        });
    }

    private static CharacterData internalEditProfile(CharacterData characterData, ProfileEditorDialogFactory dialogFactory) throws IOException {
        if (characterData == null || !characterData.isValid()) {
            throw new IOException("\u958b\u304f\u3053\u3068\u306e\u3067\u304d\u306a\u3044\u30ad\u30e3\u30e9\u30af\u30bf\u30fc\u30c7\u30fc\u30bf\u3067\u3059\u3002:" + characterData);
        }
        CharacterData original = characterData.duplicateBasicInfo(true);
        original.clearPartsSets(true);
        try {
            ProfileListManager.loadFavorites(original);
        }
        catch (IOException ex) {
            ErrorMessageHelper.showErrorDialog(null, ex);
        }
        ProfileEditDialog editDlg = dialogFactory.create(original);
        editDlg.setVisible(true);
        CharacterData newCd = editDlg.getResult();
        if (newCd == null) {
            return null;
        }
        CharacterDataPersistent persist = CharacterDataPersistent.getInstance();
        persist.updateProfile(newCd);
        persist.saveFavorites(newCd);
        return newCd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MainFrame openDefaultProfile() throws IOException {
        CharacterData characterData;
        CharacterDataPersistent persistent = CharacterDataPersistent.getInstance();
        try {
            characterData = ProfileListManager.loadRecent();
            if (characterData != null) {
                ProfileListManager.prepare(characterData);
                ProfileListManager.loadCharacterData(characterData);
                ProfileListManager.loadFavorites(characterData);
            }
        }
        catch (Exception ex) {
            ErrorMessageHelper.showErrorDialog(null, ex);
            characterData = null;
        }
        if (characterData == null) {
            final ArrayList profiles = new ArrayList();
            Future<?> future = persistent.listProfileAsync(new CharacterDataPersistent.ListProfileCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public boolean receiveCharacterData(CharacterData characterData) {
                    try {
                        ProfileListManager.prepare(characterData);
                        ProfileListManager.loadCharacterData(characterData);
                        ProfileListManager.loadFavorites(characterData);
                        ArrayList arrayList = profiles;
                        synchronized (arrayList) {
                            profiles.add(characterData);
                        }
                        return false;
                    }
                    catch (Exception ex) {
                        logger.log(Level.SEVERE, "\u30d7\u30ed\u30d5\u30a1\u30a4\u30eb\u306e\u30ed\u30fc\u30c9\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002" + characterData, ex);
                        return true;
                    }
                }

                @Override
                public boolean occureException(File baseDir, Exception ex) {
                    logger.log(Level.WARNING, "invalid profile. :" + baseDir, ex);
                    return true;
                }
            });
            try {
                future.get();
                ArrayList arrayList = profiles;
                synchronized (arrayList) {
                    if (!profiles.isEmpty()) {
                        characterData = (CharacterData)profiles.get(0);
                    }
                }
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, "\u30d7\u30ed\u30d5\u30a1\u30a4\u30eb\u306e\u30ed\u30fc\u30c9\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002" + ex, ex);
            }
        }
        if (characterData == null) {
            logger.info("\u30aa\u30fc\u30d7\u30f3\u3067\u304d\u308b\u30d7\u30ed\u30d5\u30a1\u30a4\u30eb\u304c\u306a\u3044\u305f\u3081\u3001\u65b0\u898f\u30d7\u30ed\u30d5\u30a1\u30a4\u30eb\u3092\u4f5c\u6210\u3057\u307e\u3059\u3002");
            try {
                CharacterDataDefaultProvider defProv = new CharacterDataDefaultProvider();
                characterData = defProv.createDefaultCharacterData(CharacterDataDefaultProvider.DefaultCharacterDataVersion.V3);
                persistent.createProfile(characterData);
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, "default profile creation failed.", ex);
                characterData = new CharacterData();
            }
        }
        ProfileListManager.saveRecent(characterData);
        return new MainFrame(characterData);
    }

    public static void prepare(CharacterData characterData) {
        CustomLayerOrderPersist customLayerOrderPersist = CustomLayerOrderPersist.newInstance(characterData);
        if (!customLayerOrderPersist.exist()) {
            String structureSig = characterData.toStructureString();
            Map<CustomLayerOrderKey, List<CustomLayerOrder>> map = Collections.emptyMap();
            CharacterDataDefaultProvider defProv = new CharacterDataDefaultProvider();
            CharacterData v3 = defProv.createDefaultCharacterData(CharacterDataDefaultProvider.DefaultCharacterDataVersion.V3);
            if (v3.toStructureString().equals(structureSig)) {
                map = defProv.createDefaultCustomLayerOrderMap(characterData, CharacterDataDefaultProvider.DefaultCharacterDataVersion.V3);
            }
            try {
                customLayerOrderPersist.save(map);
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, "failed to save the custom layer mapping.", ex);
            }
        }
    }

    public static void loadCharacterData(final CharacterData characterData) throws IOException {
        if (characterData != null && characterData.isValid()) {
            final PartsInfoXMLReader xmlReader = new PartsInfoXMLReader();
            PartsDataLoaderFactory loaderFactory = PartsDataLoaderFactory.getInstance();
            PartsDataLoader loader = loaderFactory.createPartsLoader(characterData.getDocBase());
            PartsSpecDecorateLoader colorGroupInfoDecorater = new PartsSpecDecorateLoader(loader, characterData.getColorGroups());
            PartsManageDataDecorateLoader partsMngDecorater = new PartsManageDataDecorateLoader(colorGroupInfoDecorater, new PartsManageDataDecorateLoader.PartsManageDataFactory(){

                @Override
                public PartsManageData createPartsManageData() {
                    try {
                        return xmlReader.loadPartsManageData(characterData.getDocBase());
                    }
                    catch (Exception ex) {
                        logger.log(Level.WARNING, "parts-info.xml loading failed.", ex);
                        return new PartsManageData();
                    }
                }
            });
            characterData.loadPartsData(partsMngDecorater);
        }
    }

    public static void loadFavorites(CharacterData characterData) throws IOException {
        if (characterData != null && characterData.isValid()) {
            CharacterDataPersistent persistent = CharacterDataPersistent.getInstance();
            persistent.loadFavorites(characterData);
        }
    }

    public static void saveRecent(CharacterData characterData) throws IOException {
        RecentDataPersistent recentPersist = RecentDataPersistent.getInstance();
        recentPersist.saveRecent(characterData);
    }

    public static CharacterData loadRecent() throws IOException {
        RecentDataPersistent recentPersist = RecentDataPersistent.getInstance();
        return recentPersist.loadRecent();
    }

    private static interface ProfileEditorDialogFactory {
        public ProfileEditDialog create(CharacterData var1);
    }
}

