/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.model.AppConfig;
import charactermanaj.ui.util.ScrollPaneDragScrollSupport;
import charactermanaj.util.LocalizedResourcePropertyLoader;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.image.BufferedImage;
import java.util.Properties;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;

public class SamplePicturePanel
extends JPanel {
    private static final long serialVersionUID = 4026181978500938152L;
    protected BufferedImage samplePicture;
    protected boolean visiblePicture = true;
    protected Color sampleImageBgColor = AppConfig.getInstance().getSampleImageBgColor();
    protected String alternateText = "";
    protected boolean enableRealsize;
    protected ScrollPaneDragScrollSupport scrollSupport;

    @Override
    public void addNotify() {
        Container gparent;
        super.addNotify();
        Container parent = this.getParent();
        if (parent != null && parent instanceof JViewport && (gparent = parent.getParent()) != null && gparent instanceof JScrollPane) {
            JScrollPane scrollPane = (JScrollPane)gparent;
            this.scrollSupport = new ScrollPaneDragScrollSupport(scrollPane);
            this.scrollSupport.installDraggingListener(this, null);
        }
    }

    @Override
    public void removeNotify() {
        if (this.scrollSupport != null) {
            this.scrollSupport.uninstallDraggingListener();
            this.scrollSupport = null;
        }
        super.removeNotify();
    }

    public SamplePicturePanel() {
        this.setMinimumSize(new Dimension(64, 64));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    SamplePicturePanel.this.onDblClick();
                    e.consume();
                }
            }
        });
    }

    public SamplePicturePanel(BufferedImage samplePicture) {
        this.setMinimumSize(new Dimension(64, 64));
        this.addMouseListener(new /* invalid duplicate definition of identical inner class */);
        this.samplePicture = samplePicture;
        this.alternateText = "";
        this.enableRealsize = false;
        this.adjustPreferrerdSize(false);
    }

    public SamplePicturePanel(BufferedImage samplePicture, String alternateText) {
        this.setMinimumSize(new Dimension(64, 64));
        this.addMouseListener(new /* invalid duplicate definition of identical inner class */);
        if (alternateText == null) {
            alternateText = "";
        }
        this.samplePicture = samplePicture;
        this.alternateText = alternateText;
        this.enableRealsize = false;
        this.adjustPreferrerdSize(false);
    }

    @Override
    protected void paintComponent(Graphics g0) {
        Graphics2D g = (Graphics2D)g0;
        super.paintComponent(g);
        if (this.samplePicture != null && this.isVisiblePicture()) {
            Rectangle rct = this.getBounds();
            Insets insets = this.getInsets();
            int x = insets.left;
            int y = insets.top;
            int w = rct.width - insets.left - insets.right;
            int h = rct.height - insets.top - insets.bottom;
            int imgW = this.samplePicture.getWidth();
            int imgH = this.samplePicture.getHeight();
            double factor1 = (double)h / (double)imgH;
            double factor2 = (double)w / (double)imgW;
            double factor = Math.min(factor1, factor2);
            int scaledW = (int)((double)imgW * factor);
            int scaledH = (int)((double)imgH * factor);
            int offset_x = (w - scaledW) / 2;
            int offset_y = (h - scaledH) / 2;
            Object renderingHint = factor <= 1.0 ? RenderingHints.VALUE_INTERPOLATION_BILINEAR : (factor <= 2.0 ? RenderingHints.VALUE_INTERPOLATION_BICUBIC : RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, renderingHint);
            g.drawImage(this.samplePicture, x + offset_x, y + offset_y, x + offset_x + scaledW, y + offset_y + scaledH, 0, 0, imgW, imgH, this.sampleImageBgColor, null);
        } else if (this.alternateText.length() > 0) {
            Rectangle rct = this.getBounds();
            Insets insets = this.getInsets();
            int x = insets.left;
            int y = insets.top;
            int w = rct.width - insets.left - insets.right;
            int h = rct.height - insets.top - insets.bottom;
            Font font = g.getFont();
            FontRenderContext frc = g.getFontRenderContext();
            int textHeight = (int)font.getMaxCharBounds(frc).getHeight();
            Shape clipOld = g.getClip();
            g.setClip(x, y, w, h);
            g.drawString(this.alternateText, x, y + textHeight);
            g.setClip(clipOld);
        }
    }

    public void adjustPreferrerdSize(boolean fullsize) {
        Dimension minSize;
        Dimension siz = minSize = this.getMinimumSize();
        String tooltip = null;
        if (this.samplePicture != null) {
            int div = fullsize ? 1 : 2;
            Insets insets = this.getInsets();
            siz = new Dimension(this.samplePicture.getWidth() / div + insets.left + insets.right, this.samplePicture.getHeight() / div + insets.top + insets.bottom);
            Container parent = this.getParent();
            if (parent != null && parent instanceof JViewport) {
                Properties strings = LocalizedResourcePropertyLoader.getCachedInstance().getLocalizedProperties("languages/samplepicturepanel");
                tooltip = !fullsize ? strings.getProperty("dblclick.fullsize") : strings.getProperty("dblclick.fit");
            }
        }
        this.setToolTipText(tooltip);
        siz.width = Math.max(minSize.width, siz.width);
        siz.height = Math.max(minSize.height, siz.height);
        Dimension ord = this.getPreferredSize();
        if (ord == null || !ord.equals(siz)) {
            this.setPreferredSize(siz);
            this.revalidate();
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Container parent = this.getParent();
        if (!this.enableRealsize && parent != null && parent instanceof JViewport) {
            JViewport viewport = (JViewport)parent;
            Dimension siz = viewport.getExtentSize();
            Insets insets = viewport.getInsets();
            Dimension preferredSize = new Dimension(siz.width - insets.left - insets.right, siz.height - insets.top - insets.bottom);
            return preferredSize;
        }
        return super.getPreferredSize();
    }

    protected void onDblClick() {
        Container parent = this.getParent();
        if (parent != null && parent instanceof JViewport) {
            this.enableRealsize = !this.enableRealsize;
            this.adjustPreferrerdSize(this.enableRealsize);
        }
    }

    public boolean isVisiblePicture() {
        return this.visiblePicture;
    }

    public void setVisiblePicture(boolean visiblePicture) {
        if (this.visiblePicture != visiblePicture) {
            this.visiblePicture = visiblePicture;
            this.repaint();
        }
    }

    public void setSamplePicture(BufferedImage samplePicture) {
        if (this.samplePicture != samplePicture) {
            this.samplePicture = samplePicture;
            this.enableRealsize = false;
            this.adjustPreferrerdSize(false);
            this.repaint();
        }
    }

    public BufferedImage getSamplePictrue() {
        return this.samplePicture;
    }

    public Color getSamplePictureBgColor() {
        return this.sampleImageBgColor;
    }

    public void setSamplePictureBgColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException();
        }
        if (!this.sampleImageBgColor.equals(color)) {
            this.sampleImageBgColor = color;
            this.repaint();
        }
    }

    public String getAlternateText() {
        return this.alternateText;
    }

    public void setAlternateText(String alternateText) {
        if (alternateText == null) {
            alternateText = "";
        }
        if (!this.alternateText.equals(alternateText)) {
            this.alternateText = alternateText;
            this.repaint();
        }
    }
}

