/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.graphics.io;

import charactermanaj.graphics.io.OutputOption;
import charactermanaj.util.LocalizedMessageComboBoxRender;
import charactermanaj.util.LocalizedResourcePropertyLoader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

class OutputOptionPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JSpinner jpegQualitySpinner;
    private JCheckBox lblZoom;
    private JSpinner zoomSpinner;
    private JComboBox zoomAlgoCombo;
    private JComboBox pictureModeCombo;
    private JCheckBox checkForceBgColor;

    public OutputOptionPanel() {
        this(new OutputOption());
    }

    public OutputOptionPanel(OutputOption outputOption) {
        Properties strings = LocalizedResourcePropertyLoader.getCachedInstance().getLocalizedProperties("languages/imageSaveHelper");
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3), BorderFactory.createTitledBorder(strings.getProperty("ouputOption.caption"))));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 13;
        gbc.fill = 1;
        gbc.insets = new Insets(3, 3, 3, 3);
        gbc.gridheight = 1;
        gbc.ipadx = 0;
        gbc.ipady = 0;
        gbc.weighty = 0.0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        this.add(Box.createHorizontalStrut(6), gbc);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 3;
        gbc.weightx = 1.0;
        JLabel lblJpeg = new JLabel(strings.getProperty("outputOption.jpeg.caption"));
        lblJpeg.setFont(lblJpeg.getFont().deriveFont(1));
        this.add((Component)lblJpeg, gbc);
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        this.add((Component)new JLabel(strings.getProperty("outputOption.jpeg.quality"), 4), gbc);
        SpinnerNumberModel spmodel = new SpinnerNumberModel(100, 10, 100, 1);
        this.jpegQualitySpinner = new JSpinner(spmodel);
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        this.add((Component)this.jpegQualitySpinner, gbc);
        gbc.gridx = 3;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        this.add((Component)new JLabel("%"), gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 3;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(10, 3, 3, 3);
        this.lblZoom = new JCheckBox(strings.getProperty("outputOption.zoom.caption"));
        this.lblZoom.setFont(lblJpeg.getFont().deriveFont(1));
        this.add((Component)this.lblZoom, gbc);
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.insets = new Insets(3, 3, 3, 3);
        this.add((Component)new JLabel(strings.getProperty("outputOption.zoom.factor"), 4), gbc);
        SpinnerNumberModel zoomSpModel = new SpinnerNumberModel(100, 20, 800, 1);
        this.zoomSpinner = new JSpinner(zoomSpModel);
        gbc.gridx = 2;
        gbc.gridy = 3;
        gbc.gridwidth = 1;
        this.add((Component)this.zoomSpinner, gbc);
        gbc.gridx = 3;
        gbc.gridy = 3;
        gbc.gridwidth = 1;
        this.add((Component)new JLabel("%"), gbc);
        gbc.gridx = 1;
        gbc.gridy = 4;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        this.add((Component)new JLabel(strings.getProperty("outputOption.zoom.renderingMode"), 4), gbc);
        this.zoomAlgoCombo = new JComboBox<OutputOption.ZoomRenderingType>(OutputOption.ZoomRenderingType.values());
        this.zoomAlgoCombo.setRenderer(new LocalizedMessageComboBoxRender(strings));
        gbc.gridx = 2;
        gbc.gridy = 4;
        gbc.gridwidth = 2;
        gbc.weightx = 0.0;
        this.add((Component)this.zoomAlgoCombo, gbc);
        gbc.gridx = 0;
        gbc.gridy = 5;
        gbc.gridwidth = 3;
        gbc.insets = new Insets(10, 3, 3, 3);
        JLabel lblPictureMode = new JLabel(strings.getProperty("outputOption.picture"));
        lblPictureMode.setFont(lblJpeg.getFont().deriveFont(1));
        this.add((Component)lblPictureMode, gbc);
        gbc.gridx = 1;
        gbc.gridy = 6;
        gbc.gridwidth = 1;
        gbc.insets = new Insets(3, 3, 3, 3);
        this.add((Component)new JLabel(strings.getProperty("outputOption.picture.type"), 4), gbc);
        this.pictureModeCombo = new JComboBox<OutputOption.PictureMode>(OutputOption.PictureMode.values());
        this.pictureModeCombo.setRenderer(new LocalizedMessageComboBoxRender(strings));
        gbc.gridx = 2;
        gbc.gridy = 6;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        this.add((Component)this.pictureModeCombo, gbc);
        gbc.gridx = 1;
        gbc.gridy = 7;
        gbc.gridwidth = 3;
        gbc.weightx = 0.0;
        this.checkForceBgColor = new JCheckBox(strings.getProperty("outputOption.picture.forceBgColor"));
        this.add((Component)this.checkForceBgColor, gbc);
        JPanel pnlBgAlpha = new JPanel(new BorderLayout(3, 3));
        pnlBgAlpha.add((Component)new JLabel("\u80cc\u666f\u30a2\u30eb\u30d5\u30a1"), "West");
        SpinnerNumberModel bgAlphaModel = new SpinnerNumberModel(255, 0, 255, 1);
        JSpinner bgAlphaSpinner = new JSpinner(bgAlphaModel);
        pnlBgAlpha.add((Component)bgAlphaSpinner, "Center");
        gbc.gridx = 1;
        gbc.gridy = 8;
        gbc.gridwidth = 3;
        gbc.weightx = 0.0;
        this.add((Component)pnlBgAlpha, gbc);
        gbc.gridx = 0;
        gbc.gridy = 9;
        gbc.gridwidth = 4;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add(Box.createGlue(), gbc);
        this.setOutputOption(outputOption);
    }

    public void setOutputOption(OutputOption outputOption) {
        if (outputOption == null) {
            outputOption = new OutputOption();
        }
        this.jpegQualitySpinner.setValue((int)(outputOption.getJpegQuality() * 100.0));
        this.lblZoom.setSelected(outputOption.isEnableZoom());
        this.zoomSpinner.setValue((int)(outputOption.getZoomFactor() * 100.0));
        this.zoomAlgoCombo.setSelectedItem(outputOption.getZoomRenderingType());
        this.pictureModeCombo.setSelectedItem(outputOption.getPictureMode());
        this.checkForceBgColor.setSelected(outputOption.isForceBgColor());
    }

    public OutputOption getOutputOption() {
        OutputOption outputOption = new OutputOption();
        outputOption.setJpegQuality((double)((Integer)this.jpegQualitySpinner.getValue()).intValue() / 100.0);
        outputOption.setEnableZoom(this.lblZoom.isSelected());
        outputOption.setZoomFactor((double)((Integer)this.zoomSpinner.getValue()).intValue() / 100.0);
        outputOption.setZoomRenderingType((OutputOption.ZoomRenderingType)this.zoomAlgoCombo.getSelectedItem());
        outputOption.setPictureMode((OutputOption.PictureMode)this.pictureModeCombo.getSelectedItem());
        outputOption.setForceBgColor(this.checkForceBgColor.isSelected());
        return outputOption;
    }
}

