/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.model;

import charactermanaj.model.CustomLayerOrder;
import charactermanaj.model.Layer;
import charactermanaj.model.LayerOrderMapper;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class CustomLayerOrderMapper
implements LayerOrderMapper {
    private Map<Layer, Float> layerOrderMap;

    public CustomLayerOrderMapper() {
        this(null);
    }

    public CustomLayerOrderMapper(Collection<CustomLayerOrder> orders) {
        this.initMapping(orders);
    }

    public final void initMapping(Collection<CustomLayerOrder> orders) {
        this.layerOrderMap = CustomLayerOrderMapper.createLayerOrderMap(orders);
    }

    private static Map<Layer, Float> createLayerOrderMap(Collection<CustomLayerOrder> orders) {
        HashMap<Layer, Float> layerOrderMap = new HashMap<Layer, Float>();
        if (orders != null) {
            for (CustomLayerOrder layerOrder : orders) {
                Layer layer = layerOrder.getLayer();
                float order = layerOrder.getLayerOrder();
                layerOrderMap.put(layer, Float.valueOf(order));
            }
        }
        return layerOrderMap;
    }

    @Override
    public float getLayerOrder(Layer layer) {
        Float order = this.layerOrderMap.get(layer);
        if (order == null) {
            order = Float.valueOf(layer.getOrder());
        }
        return order.floatValue();
    }
}

