/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.model;

import charactermanaj.model.ListChangeListener;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.EventListenerList;

public class ObservableList<E>
extends AbstractList<E> {
    private final List<E> parent;
    private Hook<E> hook;
    private final EventListenerList listeners = new EventListenerList();

    public ObservableList() {
        this(new ArrayList());
    }

    public ObservableList(List<E> parent) {
        if (parent == null) {
            throw new NullPointerException();
        }
        this.parent = parent;
    }

    public static <E> ObservableList<E> wrap(List<E> parent) {
        return new ObservableList<E>(parent);
    }

    public Hook<E> getHook() {
        return this.hook;
    }

    public void setHook(Hook<E> hook) {
        this.hook = hook;
    }

    public List<E> unwrap() {
        return this.parent;
    }

    public void addListChangeListener(ListChangeListener<E> l) {
        this.listeners.add(ListChangeListener.class, l);
    }

    public void removeListChangeListener(ListChangeListener<E> l) {
        this.listeners.remove(ListChangeListener.class, l);
    }

    public void fireEvent(ListChangeListener.ChangeType type, int index, E oldValue, E newValue) {
        Object[] ll = this.listeners.getListenerList();
        ListChangeListener.Change<E> event = null;
        for (int i = ll.length - 2; i >= 0; i -= 2) {
            if (ll[i] != ListChangeListener.class) continue;
            if (event == null) {
                event = new ListChangeListener.Change<E>(this, type, index, oldValue, newValue);
            }
            ((ListChangeListener)ll[i + 1]).onChanged(event);
        }
    }

    @Override
    public E get(int index) {
        return this.parent.get(index);
    }

    @Override
    public int size() {
        return this.parent.size();
    }

    @Override
    public E set(int index, E element) {
        E ret = this.parent.set(index, element);
        this.fireEvent(ListChangeListener.ChangeType.MODIFIY, index, ret, element);
        if (this.hook != null) {
            if (ret != null && !ret.equals(element)) {
                this.hook.remove(ret);
            }
            if (element != null && !element.equals(ret)) {
                this.hook.add(element);
            }
        }
        return ret;
    }

    public void setAll(List<E> items) {
        this.clear();
        if (items != null) {
            this.addAll(items);
        }
    }

    @Override
    public void add(int index, E element) {
        this.parent.add(index, element);
        if (element != null && this.hook != null) {
            this.hook.add(element);
        }
        this.fireEvent(ListChangeListener.ChangeType.ADD, index, null, element);
    }

    @Override
    public E remove(int index) {
        E ret = this.parent.remove(index);
        this.fireEvent(ListChangeListener.ChangeType.REMOVE, index, ret, null);
        if (ret != null && this.hook != null) {
            this.hook.remove(ret);
        }
        return ret;
    }

    public static interface Hook<E> {
        public void add(E var1);

        public void remove(E var1);
    }
}

