/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.model.io;

import charactermanaj.model.CharacterData;
import charactermanaj.model.CustomLayerOrder;
import charactermanaj.model.CustomLayerOrderKey;
import charactermanaj.model.PartsCategoryResolver;
import charactermanaj.model.io.CharacterDataPersistent;
import charactermanaj.model.io.CharacterDataXMLReader;
import charactermanaj.model.io.CharacterDataXMLWriter;
import charactermanaj.model.io.CustomLayerOrderXMLReader;
import charactermanaj.model.io.CustomLayerOrderXMLWriter;
import charactermanaj.util.ConfigurationDirUtilities;
import charactermanaj.util.LocalizedResourcePropertyLoader;
import charactermanaj.util.ResourceLoader;
import charactermanaj.util.SetupLocalization;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CharacterDataDefaultProvider {
    public static final String DEFAULT_CHARACTER_PREFIX = "template/";
    public static final String TEMPLATE_LIST_XML = "characterDataTemplates";
    public static final String DEFAULT_CHARACTER_NAME_V2 = "character2.xml";
    public static final String DEFAULT_CHARACTER_NAME_V3 = "character3.xml";
    private static final String CUSTOM_LAYER_ORDERS_SUFFIX = "-customlayerorders.xml";
    private final ResourceLoader resourceLoader = new ResourceLoader(true);
    private static final Logger logger = Logger.getLogger(CharacterDataDefaultProvider.class.getName());

    public synchronized CharacterData createDefaultCharacterData(DefaultCharacterDataVersion version) {
        if (version == null) {
            throw new IllegalArgumentException();
        }
        return version.create(this);
    }

    public Map<CustomLayerOrderKey, List<CustomLayerOrder>> createDefaultCustomLayerOrderMap(PartsCategoryResolver partsCategoryResolver, DefaultCharacterDataVersion version) {
        if (partsCategoryResolver == null) {
            throw new NullPointerException("categories is required.");
        }
        if (version == null) {
            throw new NullPointerException("version is required.");
        }
        return version.createCustomLayerOrderMap(partsCategoryResolver, this);
    }

    public Map<String, String> getCharacterDataTemplates() {
        final LinkedHashMap<String, String> templateNameMap = new LinkedHashMap<String, String>();
        LocalizedResourcePropertyLoader propLoader = LocalizedResourcePropertyLoader.getNonCachedInstance();
        Properties props = propLoader.getLocalizedProperties("template/characterDataTemplates", null);
        String strOrders = props.getProperty("displayOrder");
        if (strOrders != null) {
            for (String templateFileName : strOrders.split(",")) {
                String resKey;
                String displayName = props.getProperty(templateFileName = templateFileName.trim());
                if (displayName == null || displayName.trim().length() <= 0 || this.getResource(resKey = DEFAULT_CHARACTER_PREFIX + templateFileName) == null) continue;
                templateNameMap.put(templateFileName, displayName);
            }
        }
        Enumeration<?> enm = props.propertyNames();
        while (enm.hasMoreElements()) {
            String templateFileName = (String)enm.nextElement();
            if (templateNameMap.containsKey(templateFileName) || !templateFileName.endsWith(".xml")) continue;
            String displayName = props.getProperty(templateFileName);
            String resKey = DEFAULT_CHARACTER_PREFIX + templateFileName;
            if (this.getResource(resKey) == null) continue;
            templateNameMap.put(templateFileName, displayName);
        }
        try {
            File templDir = this.getUserTemplateDir();
            if (templDir.exists() && templDir.isDirectory()) {
                File[] files = templDir.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File pathname) {
                        String name = pathname.getName();
                        if (templateNameMap.containsKey(name)) {
                            return false;
                        }
                        if (name.startsWith(CharacterDataDefaultProvider.TEMPLATE_LIST_XML)) {
                            return false;
                        }
                        if (name.endsWith(CharacterDataDefaultProvider.CUSTOM_LAYER_ORDERS_SUFFIX)) {
                            return false;
                        }
                        return pathname.isFile() && name.endsWith(".xml");
                    }
                });
                if (files == null) {
                    files = new File[]{};
                }
                CharacterDataPersistent persist = CharacterDataPersistent.getInstance();
                for (File file : files) {
                    try {
                        URI docBase = file.toURI();
                        CharacterData cd = persist.loadProfile(docBase);
                        if (cd == null || !cd.isValid()) continue;
                        String name = file.getName();
                        templateNameMap.put(name, cd.getName());
                    }
                    catch (IOException ex) {
                        logger.log(Level.WARNING, "failed to read templatedir." + file, ex);
                    }
                }
            }
        }
        catch (IOException ex) {
            logger.log(Level.FINE, "failed to read templatedir.", ex);
        }
        return templateNameMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CharacterData loadPredefinedCharacterData(String name) throws IOException {
        CharacterData cd;
        String resKey = DEFAULT_CHARACTER_PREFIX + name;
        URL predefinedCharacter = this.getResource(resKey);
        if (predefinedCharacter == null) {
            throw new FileNotFoundException(resKey);
        }
        InputStream is = predefinedCharacter.openStream();
        try {
            logger.log(Level.INFO, "load a predefined characterdata. resKey=" + resKey);
            CharacterDataXMLReader characterDataXmlReader = new CharacterDataXMLReader();
            cd = characterDataXmlReader.loadCharacterDataFromXML(is, null);
        }
        finally {
            is.close();
        }
        return cd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<CustomLayerOrderKey, List<CustomLayerOrder>> loadPredefinedCustomLayerOrder(PartsCategoryResolver partsCategoryResolver, String name) throws IOException {
        int pt = name.lastIndexOf(".");
        String nameBody = name.substring(0, pt);
        String customLayerMappingXml = nameBody + CUSTOM_LAYER_ORDERS_SUFFIX;
        String resKey = DEFAULT_CHARACTER_PREFIX + customLayerMappingXml;
        URL predefinedCharacter = this.getResource(resKey);
        if (predefinedCharacter == null) {
            return null;
        }
        InputStream is = predefinedCharacter.openStream();
        try {
            logger.log(Level.INFO, "load a predefined custom layer orders. resKey=" + resKey);
            CustomLayerOrderXMLReader xmlReader = new CustomLayerOrderXMLReader(partsCategoryResolver);
            Map<CustomLayerOrderKey, List<CustomLayerOrder>> map = xmlReader.read(is);
            return map;
        }
        finally {
            is.close();
        }
    }

    protected URL getResource(String resKey) {
        return this.resourceLoader.getResource(resKey);
    }

    public File getUserTemplateDir() throws IOException {
        File baseDir = ConfigurationDirUtilities.getUserDataDir();
        SetupLocalization setup = new SetupLocalization(baseDir);
        File resourceDir = setup.getResourceDir();
        return new File(resourceDir, DEFAULT_CHARACTER_PREFIX);
    }

    public boolean canFileSave(String name) {
        return !name.trim().startsWith(TEMPLATE_LIST_XML);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveTemplate(String name, CharacterData cd, String localizedName, Map<CustomLayerOrderKey, List<CustomLayerOrder>> customLayerPatterns) throws IOException {
        if (name == null || !this.canFileSave(name)) {
            throw new IllegalArgumentException();
        }
        File templDir = this.getUserTemplateDir();
        templDir.mkdirs();
        File templFile = new File(templDir, name);
        CharacterDataXMLWriter characterDataXmlWriter = new CharacterDataXMLWriter();
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(templFile));
        try {
            CharacterData templCd = cd.duplicateBasicInfo(false);
            templCd.setName(localizedName);
            characterDataXmlWriter.writeXMLCharacterData(templCd, bos);
        }
        finally {
            bos.close();
        }
        if (customLayerPatterns != null && cd.isEnableCustonLayerPattern()) {
            int pt = name.lastIndexOf(".");
            String nameBody = pt > 0 ? name.substring(0, pt) : name;
            File templCustomLayerFile = new File(templDir, nameBody + CUSTOM_LAYER_ORDERS_SUFFIX);
            CustomLayerOrderXMLWriter xmlWriter = new CustomLayerOrderXMLWriter();
            BufferedOutputStream bos2 = new BufferedOutputStream(new FileOutputStream(templCustomLayerFile));
            try {
                xmlWriter.write(customLayerPatterns, bos2);
            }
            finally {
                bos2.close();
            }
        }
        Properties userTemplDefProp = this.loadUserDefineTemplateDef();
        userTemplDefProp.put(name, localizedName);
        this.saveUserDefineTemplateDef(userTemplDefProp);
    }

    private File getUserTemplateDefPropertyFile() throws IOException {
        File templDir = this.getUserTemplateDir();
        return new File(templDir, "characterDataTemplates.xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadUserDefineTemplateDef() throws IOException {
        File userTemplDefPropFile = this.getUserTemplateDefPropertyFile();
        Properties userTemplDefProp = new Properties();
        if (userTemplDefPropFile.exists() && userTemplDefPropFile.length() > 0L) {
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(userTemplDefPropFile));
            try {
                userTemplDefProp.loadFromXML(is);
            }
            finally {
                ((InputStream)is).close();
            }
        }
        return userTemplDefProp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveUserDefineTemplateDef(Properties userTemplDefProp) throws IOException {
        if (userTemplDefProp == null) {
            userTemplDefProp = new Properties();
        }
        File userTemplDefPropFile = this.getUserTemplateDefPropertyFile();
        BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(userTemplDefPropFile));
        try {
            userTemplDefProp.storeToXML(fos, new Timestamp(System.currentTimeMillis()).toString());
        }
        finally {
            fos.close();
        }
    }

    public static enum DefaultCharacterDataVersion {
        V2("character2.xml"),
        V3("character3.xml");

        private final String reskey;

        private DefaultCharacterDataVersion(String reskey) {
            this.reskey = reskey;
        }

        public String getResourceName() {
            return this.reskey;
        }

        public CharacterData create(CharacterDataDefaultProvider prov) {
            if (prov == null) {
                throw new IllegalArgumentException();
            }
            try {
                return prov.loadPredefinedCharacterData(this.reskey);
            }
            catch (IOException ex) {
                throw new RuntimeException("can not create the default profile from application's resource", ex);
            }
        }

        public Map<CustomLayerOrderKey, List<CustomLayerOrder>> createCustomLayerOrderMap(PartsCategoryResolver partsCategoryResolver, CharacterDataDefaultProvider prov) {
            if (prov == null) {
                throw new IllegalArgumentException();
            }
            try {
                return prov.loadPredefinedCustomLayerOrder(partsCategoryResolver, this.reskey);
            }
            catch (IOException ex) {
                throw new RuntimeException("can not create the default profile from application's resource", ex);
            }
        }
    }
}

