/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.model.io;

import charactermanaj.model.AppConfig;
import charactermanaj.model.io.AbstractCharacterDataArchiveFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;

public class CharacterDataZipArchiveFile
extends AbstractCharacterDataArchiveFile {
    protected ZipFile zipFile;

    @Override
    public void close() throws IOException {
        this.zipFile.close();
    }

    public CharacterDataZipArchiveFile(File file) throws IOException {
        super(file);
        AppConfig appConfig = AppConfig.getInstance();
        String encoding = appConfig.getZipNameEncoding();
        this.zipFile = new ZipFile(file, encoding);
        this.load();
    }

    private void load() {
        Enumeration enm = this.zipFile.getEntries();
        while (enm.hasMoreElements()) {
            ZipEntry entry = (ZipEntry)enm.nextElement();
            this.addEntry(new ZipFileContent(entry));
        }
        this.searchRootPrefix();
    }

    protected class ZipFileContent
    implements AbstractCharacterDataArchiveFile.FileContent {
        private ZipEntry entry;

        protected ZipFileContent(ZipEntry entry) {
            this.entry = entry;
        }

        @Override
        public String getEntryName() {
            return this.entry.getName();
        }

        @Override
        public long lastModified() {
            return this.entry.getTime();
        }

        @Override
        public long length() {
            return this.entry.getSize();
        }

        @Override
        public InputStream openStream() throws IOException {
            return CharacterDataZipArchiveFile.this.zipFile.getInputStream(this.entry);
        }
    }
}

