/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.model.io;

import charactermanaj.model.CustomLayerOrder;
import charactermanaj.model.CustomLayerOrderKey;
import charactermanaj.model.Layer;
import charactermanaj.model.PartsCategory;
import charactermanaj.model.PartsCategoryResolver;
import charactermanaj.util.XMLUtilities;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CustomLayerOrderXMLReader {
    private PartsCategoryResolver categoryResolver;

    public CustomLayerOrderXMLReader(PartsCategoryResolver categoryResolver) {
        if (categoryResolver == null) {
            throw new NullPointerException("categories is required.");
        }
        this.categoryResolver = categoryResolver;
    }

    public Map<CustomLayerOrderKey, List<CustomLayerOrder>> read(InputStream is) throws IOException {
        if (is == null) {
            throw new IllegalArgumentException();
        }
        TreeMap<CustomLayerOrderKey, List<CustomLayerOrder>> map = new TreeMap<CustomLayerOrderKey, List<CustomLayerOrder>>();
        Document doc = XMLUtilities.loadDocument(is);
        String lang = Locale.getDefault().getLanguage();
        try {
            Element docElm = doc.getDocumentElement();
            if (!"custom-layer-orders".equals(docElm.getNodeName())) {
                throw new IOException("Invalid Format.");
            }
            String ns = docElm.getNamespaceURI();
            if (ns == null || !ns.startsWith("http://charactermanaj.osdn.jp/schema/customlayerorder.xsd")) {
                throw new IOException("unsupported xml format");
            }
            String docVersion = docElm.getAttribute("version").trim();
            if (!"1.0".equals(docVersion)) {
                throw new IOException("unsupported version: " + docVersion);
            }
            for (Element elmPattern : XMLUtilities.getChildElements(docElm, "pattern")) {
                String id = elmPattern.getAttribute("id");
                String patternName = elmPattern.getAttribute("name");
                if (id == null || id.length() == 0) {
                    id = patternName;
                }
                HashMap<String, String> localizedNames = new HashMap<String, String>();
                localizedNames.put("", patternName);
                for (Element element : XMLUtilities.getChildElements(elmPattern, "localized-name")) {
                    String localizedLang = element.getAttribute("lang");
                    String localizedName = element.getAttribute("name");
                    localizedNames.put(localizedLang, localizedName);
                    if (!lang.equals(localizedLang)) continue;
                    patternName = localizedName;
                }
                ArrayList<CustomLayerOrder> orders = new ArrayList<CustomLayerOrder>();
                for (Element elmMapping : XMLUtilities.getChildElements(elmPattern, "mapping")) {
                    Layer layer;
                    String categoryId = elmMapping.getAttribute("category");
                    String layerId = elmMapping.getAttribute("layer");
                    float layerOrder = Float.parseFloat(elmMapping.getAttribute("order"));
                    PartsCategory category = this.categoryResolver.getPartsCategory(categoryId);
                    if (category == null || (layer = category.getLayer(layerId)) == null) continue;
                    CustomLayerOrder order = new CustomLayerOrder();
                    order.setCategory(category);
                    order.setLayer(layer);
                    order.setLayerOrder(layerOrder);
                    orders.add(order);
                }
                CustomLayerOrderKey customLayerOrderKey = new CustomLayerOrderKey(id, patternName, localizedNames);
                map.put(customLayerOrderKey, orders);
            }
        }
        catch (RuntimeException ex) {
            IOException ex2 = new IOException("CustomLayerOrderXML invalid format.");
            ex2.initCause(ex);
            throw ex2;
        }
        return map;
    }
}

