/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.model.io;

import charactermanaj.model.CustomLayerOrder;
import charactermanaj.model.CustomLayerOrderKey;
import charactermanaj.model.Layer;
import charactermanaj.model.PartsCategory;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CustomLayerOrderXMLWriter {
    public static final String VERSION_SIG_1_0 = "1.0";
    public static final String NS = "http://charactermanaj.osdn.jp/schema/customlayerorder.xsd";

    public void write(Map<CustomLayerOrderKey, List<CustomLayerOrder>> map, OutputStream outstm) throws IOException {
        Transformer tfmr;
        Document doc = this.createDocument(map);
        TransformerFactory txFactory = TransformerFactory.newInstance();
        txFactory.setAttribute("indent-number", 4);
        try {
            tfmr = txFactory.newTransformer();
        }
        catch (TransformerConfigurationException ex) {
            throw new RuntimeException("JAXP Configuration Failed.", ex);
        }
        tfmr.setOutputProperty("indent", "yes");
        String encoding = "UTF-8";
        tfmr.setOutputProperty("encoding", "UTF-8");
        try {
            tfmr.transform(new DOMSource(doc), new StreamResult(new OutputStreamWriter(outstm, Charset.forName("UTF-8"))));
        }
        catch (TransformerException ex) {
            IOException ex2 = new IOException("XML Convert failed.");
            ex2.initCause(ex);
            throw ex2;
        }
    }

    public Document createDocument(Map<CustomLayerOrderKey, List<CustomLayerOrder>> map) {
        Document doc;
        if (map == null) {
            map = Collections.emptyMap();
        }
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            doc = builder.newDocument();
        }
        catch (ParserConfigurationException ex) {
            throw new RuntimeException("JAXP Configuration failed.", ex);
        }
        Element root = doc.createElementNS(NS, "custom-layer-orders");
        root.setAttribute("version", VERSION_SIG_1_0);
        root.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        root.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xml", "http://www.w3.org/XML/1998/namespace");
        root.setAttribute("xsi:schemaLocation", "http://charactermanaj.osdn.jp/schema/customlayerorder.xsd customlayerorder.xsd");
        for (Map.Entry<CustomLayerOrderKey, List<CustomLayerOrder>> entry : map.entrySet()) {
            CustomLayerOrderKey orderKey = entry.getKey();
            String id = orderKey.getId();
            String displayName = orderKey.getDisplayName();
            Map<String, String> localizedNames = orderKey.getLocalizedNames();
            String defaultName = localizedNames.get("");
            if (defaultName == null) {
                defaultName = displayName;
            }
            List<CustomLayerOrder> orders = entry.getValue();
            Element elmPattern = doc.createElementNS(NS, "pattern");
            elmPattern.setAttribute("id", id);
            elmPattern.setAttribute("name", defaultName);
            root.appendChild(elmPattern);
            for (Map.Entry<String, String> localizedEntry : localizedNames.entrySet()) {
                String localizedLang = localizedEntry.getKey();
                String localizedName = localizedEntry.getValue();
                if ("".equals(localizedLang)) continue;
                Element elmLocalizedName = doc.createElementNS(NS, "localized-name");
                elmLocalizedName.setAttribute("lang", localizedLang);
                elmLocalizedName.setAttribute("name", localizedName);
                elmPattern.appendChild(elmLocalizedName);
            }
            for (CustomLayerOrder order : orders) {
                Element elmMapping = doc.createElementNS(NS, "mapping");
                elmPattern.appendChild(elmMapping);
                PartsCategory category = order.getCategory();
                Layer layer = order.getLayer();
                float layerOrder = order.getLayerOrder();
                elmMapping.setAttribute("category", category.getCategoryId());
                elmMapping.setAttribute("layer", layer.getId());
                elmMapping.setAttribute("order", Float.toString(layerOrder));
            }
        }
        doc.appendChild(root);
        return doc;
    }
}

