/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.graphics.io.PNGFileImageHeader;
import charactermanaj.model.PartsCategory;
import charactermanaj.model.io.AbstractCharacterDataArchiveFile;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;

class ImportPartsImageSet
extends AbstractCollection<AbstractCharacterDataArchiveFile.PartsImageContent> {
    private String partsName;
    private ArrayList<AbstractCharacterDataArchiveFile.PartsImageContent> contentSet = new ArrayList();
    private Long lastModified;
    private int width;
    private int height;
    private boolean unmatchedSize;
    private boolean alphaColor;
    private Collection<PartsCategory> partsCategories;
    private boolean checked;

    public ImportPartsImageSet(String partsName) {
        if (partsName == null || partsName.length() == 0) {
            throw new IllegalArgumentException();
        }
        this.partsName = partsName;
    }

    public String getPartsName() {
        return this.partsName;
    }

    @Override
    public int size() {
        return this.contentSet.size();
    }

    @Override
    public Iterator<AbstractCharacterDataArchiveFile.PartsImageContent> iterator() {
        return this.contentSet.iterator();
    }

    @Override
    public boolean add(AbstractCharacterDataArchiveFile.PartsImageContent o) {
        if (o == null) {
            throw new IllegalArgumentException();
        }
        if (!this.partsName.equals(o.getPartsName())) {
            throw new IllegalArgumentException();
        }
        this.lastModified = null;
        return this.contentSet.add(o);
    }

    public int getWidth() {
        this.recheck();
        return this.width;
    }

    public int getHeight() {
        this.recheck();
        return this.height;
    }

    public boolean isUnmatchedSize() {
        this.recheck();
        return this.unmatchedSize;
    }

    public boolean isAlphaColor() {
        this.recheck();
        return this.alphaColor;
    }

    public long lastModified() {
        this.recheck();
        return this.lastModified;
    }

    public Collection<PartsCategory> getPartsCategories() {
        this.recheck();
        return this.partsCategories;
    }

    protected void recheck() {
        if (this.lastModified != null) {
            return;
        }
        long lastModified = 0L;
        int maxWidth = 0;
        int maxHeight = 0;
        int minWidth = 0;
        int minHeight = 0;
        boolean alphaColor = !this.contentSet.isEmpty();
        HashSet<PartsCategory> partsCategories = new HashSet<PartsCategory>();
        for (AbstractCharacterDataArchiveFile.PartsImageContent partsImageContent : this.contentSet) {
            PNGFileImageHeader header = partsImageContent.getPngFileImageHeader();
            maxWidth = Math.max(maxWidth, header.getWidth());
            maxHeight = Math.max(maxHeight, header.getHeight());
            minWidth = Math.max(minWidth, header.getWidth());
            minHeight = Math.max(minHeight, header.getHeight());
            if (header.getColorType() != 6 && !header.hasTransparencyInformation()) {
                alphaColor = false;
            }
            for (AbstractCharacterDataArchiveFile.CategoryLayerPair clPair : partsImageContent.getCategoryLayerPairs()) {
                partsCategories.add(clPair.getPartsCategory());
            }
            long tm = partsImageContent.lastModified();
            lastModified = Math.max(lastModified, tm);
        }
        this.lastModified = lastModified;
        this.width = maxWidth;
        this.height = maxHeight;
        this.unmatchedSize = minWidth != maxWidth || minHeight != maxHeight;
        this.alphaColor = alphaColor;
        this.partsCategories = Collections.unmodifiableCollection(partsCategories);
    }

    public void setChecked(boolean checked) {
        this.checked = checked;
    }

    public boolean isChecked() {
        return this.checked;
    }
}

