/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.util.ConfigurationDirUtilities;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.TreeMap;

public class RecentCharactersDir {
    private static final String RECENT_CHARACTERDIRS_XML = "recent-characterdirs.xml";
    private static final String DIRS_PREFIX = "characterDataDirs.";
    private File lastUseCharacterDir;
    private ArrayList<File> recentCharacterDirs = new ArrayList();
    private boolean doNotAskAgain;

    public List<File> getRecentCharacterDirs() {
        return this.recentCharacterDirs;
    }

    public List<File> getRecentCharacterDirsOrderByNewly() {
        ArrayList<File> dirs = new ArrayList<File>(this.recentCharacterDirs);
        Collections.reverse(dirs);
        return Collections.unmodifiableList(dirs);
    }

    public void setLastUseCharacterDir(File lastUseCharacterDir) {
        this.lastUseCharacterDir = lastUseCharacterDir;
    }

    public File getLastUseCharacterDir() {
        return this.lastUseCharacterDir;
    }

    public void clrar() {
        this.doNotAskAgain = false;
        this.lastUseCharacterDir = null;
        this.recentCharacterDirs.clear();
    }

    public boolean isDoNotAskAgain() {
        return this.doNotAskAgain;
    }

    public void setDoNotAskAgain(boolean doNotAskAgain) {
        this.doNotAskAgain = doNotAskAgain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RecentCharactersDir load() throws IOException {
        Properties props = new Properties();
        File localUserDataDir = ConfigurationDirUtilities.getLocalUserDataDir();
        File recentUseDirs = new File(localUserDataDir, RECENT_CHARACTERDIRS_XML);
        if (recentUseDirs.exists()) {
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(recentUseDirs));
            try {
                props.loadFromXML(is);
            }
            finally {
                ((InputStream)is).close();
            }
        }
        RecentCharactersDir inst = new RecentCharactersDir();
        inst.doNotAskAgain = Boolean.parseBoolean(props.getProperty("doNotAskAgain"));
        String lastUseCharacterDataDir = props.getProperty("lastUseCharacterDataDir");
        File lastUseCharacterDir = null;
        TreeMap<String, File> dirsMap = new TreeMap<String, File>();
        try {
            if (lastUseCharacterDataDir != null && lastUseCharacterDataDir.trim().length() > 0 && !(lastUseCharacterDir = new File(new URI(lastUseCharacterDataDir))).isDirectory()) {
                lastUseCharacterDir = null;
            }
            Enumeration<?> enmKeys = props.propertyNames();
            while (enmKeys.hasMoreElements()) {
                File dir;
                String value;
                String key = (String)enmKeys.nextElement();
                if (!key.startsWith(DIRS_PREFIX) || (value = props.getProperty(key)) == null || value.trim().length() <= 0 || !(dir = new File(new URI(value))).isDirectory()) continue;
                dirsMap.put(key, dir);
            }
        }
        catch (URISyntaxException ex) {
            IOException ex2 = new IOException("invalid file name: " + ex);
            ex2.initCause(ex);
            throw ex2;
        }
        inst.lastUseCharacterDir = lastUseCharacterDir;
        for (File dir : dirsMap.values()) {
            if (dir.equals(lastUseCharacterDir)) continue;
            inst.recentCharacterDirs.add(dir);
        }
        if (lastUseCharacterDir != null) {
            inst.recentCharacterDirs.add(lastUseCharacterDir);
        }
        return inst;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveRecents() throws IOException {
        Properties props = new Properties();
        if (this.lastUseCharacterDir != null) {
            props.put("lastUseCharacterDataDir", this.lastUseCharacterDir.toURI().toString());
            this.recentCharacterDirs.remove(this.lastUseCharacterDir);
            this.recentCharacterDirs.add(this.lastUseCharacterDir);
        } else {
            props.put("lastUseCharacterDataDir", "");
        }
        int idx = 0;
        for (File dir : this.recentCharacterDirs) {
            String key = DIRS_PREFIX + String.format("%04d", idx);
            props.put(key, dir.toURI().toString());
            ++idx;
        }
        props.put("doNotAskAgain", this.doNotAskAgain ? "true" : "false");
        File localUserDataDir = ConfigurationDirUtilities.getLocalUserDataDir();
        File recentUseDirs = new File(localUserDataDir, RECENT_CHARACTERDIRS_XML);
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(recentUseDirs));
        try {
            props.storeToXML(os, "recent-characterdirs");
        }
        finally {
            ((OutputStream)os).close();
        }
    }
}

