/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.Main;
import charactermanaj.model.io.WorkingSetPersist;
import charactermanaj.ui.RecentCharactersDir;
import charactermanaj.ui.util.FileDropTarget;
import charactermanaj.ui.util.ScaleSupport;
import charactermanaj.util.ErrorMessageHelper;
import charactermanaj.util.LocalizedResourcePropertyLoader;
import charactermanaj.util.UIHelper;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;

public class SelectCharatersDirDialog
extends JDialog {
    private static final long serialVersionUID = -888834575856349442L;
    private static final Logger logger = Logger.getLogger(SelectCharatersDirDialog.class.getName());
    private final RecentCharactersDir recentCharactersDir;
    private File defaultCharactersDir;
    private File selectedCharacterDir;
    private boolean doNotAskAgain;
    private JComboBox combDir;
    private JCheckBox chkDoNotAsk;

    public File getDefaultCharactersDir() {
        return this.defaultCharactersDir;
    }

    public void setDefaultCharactersDir(File defaultCharactersDir) {
        this.defaultCharactersDir = defaultCharactersDir;
    }

    public File getSelectedCharacterDir() {
        return this.selectedCharacterDir;
    }

    public boolean isDoNotAskAgain() {
        return this.doNotAskAgain;
    }

    protected SelectCharatersDirDialog(JFrame parent, RecentCharactersDir recentCharactersDir) {
        super((Frame)parent, true);
        try {
            if (recentCharactersDir == null) {
                throw new IllegalArgumentException("recentCharactersDir\u306bnull\u306f\u6307\u5b9a\u3067\u304d\u307e\u305b\u3093\u3002");
            }
            this.recentCharactersDir = recentCharactersDir;
            this.setDefaultCloseOperation(0);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    SelectCharatersDirDialog.this.onClose();
                }
            });
            this.initComponent();
        }
        catch (RuntimeException ex) {
            logger.log(Level.SEVERE, "\u30ad\u30e3\u30e9\u30af\u30bf\u30fc\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u9078\u629e\u30c0\u30a4\u30a2\u30ed\u30b0\u306e\u751f\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", ex);
            this.dispose();
            throw ex;
        }
    }

    private void initComponent() {
        Properties strings = LocalizedResourcePropertyLoader.getCachedInstance().getLocalizedProperties("languages/selectCharatersDirDialog");
        AbstractAction actOk = new AbstractAction(strings.getProperty("btn.ok")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectCharatersDirDialog.this.onOK();
            }
        };
        AbstractAction actClose = new AbstractAction(strings.getProperty("btn.cancel")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectCharatersDirDialog.this.onClose();
            }
        };
        AbstractAction actBrowse = new AbstractAction(strings.getProperty("btn.chooseDir")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectCharatersDirDialog.this.onBrowse();
            }
        };
        AbstractAction actRemoveRecent = new AbstractAction(strings.getProperty("btn.clearRecentList")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectCharatersDirDialog.this.onRemoveRecent();
            }
        };
        AbstractAction actRemoveWorkingSets = new AbstractAction(strings.getProperty("btn.clearWorkingSets")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectCharatersDirDialog.this.onRemoveWorkingSets();
            }
        };
        JButton btnRemoveWorkingSets = new JButton(actRemoveWorkingSets);
        JButton btnRemoveRecent = new JButton(actRemoveRecent);
        final JButton btnOK = new JButton(actOk);
        JButton btnCancel = new JButton(actClose);
        JButton btnBroseForDir = new JButton(actBrowse);
        Toolkit tk = Toolkit.getDefaultToolkit();
        final JRootPane rootPane = this.getRootPane();
        FocusAdapter focusAdapter = new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                JButton btn = (JButton)e.getSource();
                rootPane.setDefaultButton(btn);
            }

            @Override
            public void focusLost(FocusEvent e) {
                rootPane.setDefaultButton(btnOK);
            }
        };
        rootPane.setDefaultButton(btnOK);
        InputMap im = rootPane.getInputMap();
        im.put(KeyStroke.getKeyStroke(27, 0), "close");
        im.put(KeyStroke.getKeyStroke(87, tk.getMenuShortcutKeyMask()), "close");
        rootPane.getActionMap().put("close", actClose);
        btnRemoveWorkingSets.addFocusListener(focusAdapter);
        btnRemoveRecent.addFocusListener(focusAdapter);
        btnOK.addFocusListener(focusAdapter);
        btnCancel.addFocusListener(focusAdapter);
        btnBroseForDir.addFocusListener(focusAdapter);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        ScaleSupport scaleSupport = ScaleSupport.getInstance(this);
        JLabel lbl = new JLabel(strings.getProperty("caption"));
        lbl.setFont(lbl.getFont().deriveFont(1));
        lbl.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        Dimension dim = lbl.getPreferredSize();
        dim.width = Integer.parseInt(strings.getProperty("width"));
        dim = scaleSupport.manualScaled(dim);
        lbl.setPreferredSize(dim);
        Box header = Box.createHorizontalBox();
        header.add(lbl);
        contentPane.add(header);
        JPanel dirPanel = new JPanel(new GridBagLayout());
        dirPanel.setBorder(BorderFactory.createEmptyBorder(3, 10, 3, 3));
        this.combDir = new JComboBox();
        this.combDir.setEditable(true);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(3, 3, 3, 3);
        dirPanel.add((Component)new JLabel(strings.getProperty("lbl.dir")), gbc);
        gbc.gridx = 1;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        dirPanel.add((Component)this.combDir, gbc);
        gbc.gridx = 2;
        gbc.weightx = 0.0;
        dirPanel.add((Component)btnBroseForDir, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weighty = 1.0;
        dirPanel.add(Box.createGlue(), gbc);
        contentPane.add(dirPanel);
        this.chkDoNotAsk = new JCheckBox(strings.getProperty("chk.doNotAskAgein"));
        this.chkDoNotAsk.setSelected(this.recentCharactersDir.isDoNotAskAgain());
        Box chkPanel = Box.createHorizontalBox();
        chkPanel.add(this.chkDoNotAsk);
        chkPanel.add(Box.createHorizontalGlue());
        contentPane.add(chkPanel);
        Box btnsBox = Box.createHorizontalBox();
        btnsBox.add(btnRemoveRecent);
        btnsBox.add(btnRemoveWorkingSets);
        btnsBox.add(Box.createHorizontalGlue());
        if (!Main.isLinuxOrMacOSX()) {
            btnsBox.add(btnOK);
            btnsBox.add(btnCancel);
        } else {
            btnsBox.add(btnCancel);
            btnsBox.add(btnOK);
        }
        btnsBox.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 24));
        contentPane.add(btnsBox);
        this.setTitle(strings.getProperty("title"));
        this.setResizable(true);
        new DropTarget(this, new FileDropTarget(){

            @Override
            protected void onDropFiles(List<File> dropFiles) {
                SelectCharatersDirDialog.this.setSelectFile(dropFiles);
            }

            @Override
            protected void onException(Exception ex) {
                ErrorMessageHelper.showErrorDialog(SelectCharatersDirDialog.this, ex);
            }
        });
        this.pack();
        this.setLocationRelativeTo(null);
    }

    protected void setSelectFile(List<File> dropFiles) {
        if (dropFiles.isEmpty()) {
            return;
        }
        File dropFile = dropFiles.get(0);
        if (!dropFile.exists() || !dropFile.isDirectory()) {
            return;
        }
        this.combDir.setSelectedItem(dropFile);
    }

    protected void onClose() {
        this.selectedCharacterDir = null;
        this.dispose();
    }

    protected void onOK() {
        try {
            Object value = this.combDir.getSelectedItem();
            if (value != null && value instanceof String) {
                value = new File((String)value);
            }
            if (value != null && value instanceof File) {
                File file = (File)value;
                if (!file.exists()) {
                    boolean result = file.mkdirs();
                    logger.log(Level.INFO, "mkdirs(" + file + ") succeeded=" + result);
                }
                if (file.isDirectory()) {
                    logger.log(Level.CONFIG, "selectedCharactersDir=" + file);
                    this.selectedCharacterDir = file;
                    this.doNotAskAgain = this.chkDoNotAsk.isSelected();
                    this.dispose();
                    return;
                }
            }
            Toolkit tk = Toolkit.getDefaultToolkit();
            tk.beep();
        }
        catch (Exception ex) {
            ErrorMessageHelper.showErrorDialog(this, ex);
        }
    }

    protected void onBrowse() {
        try {
            Object selectedItem = this.combDir.getSelectedItem();
            String directoryTxt = null;
            if (selectedItem != null) {
                directoryTxt = selectedItem.toString();
            }
            JFileChooser dirChooser = new JFileChooser(directoryTxt);
            dirChooser.setFileSelectionMode(1);
            if (dirChooser.showOpenDialog(this) != 0) {
                return;
            }
            File dir = dirChooser.getSelectedFile();
            if (dir != null) {
                this.combDir.setSelectedItem(dir);
            }
        }
        catch (Exception ex) {
            ErrorMessageHelper.showErrorDialog(this, ex);
        }
    }

    protected void onRemoveWorkingSets() {
        try {
            Properties strings = LocalizedResourcePropertyLoader.getCachedInstance().getLocalizedProperties("languages/selectCharatersDirDialog");
            if (JOptionPane.showConfirmDialog(this, strings.getProperty("confirm.clearWorkingSets"), strings.getProperty("confirm.clearWorkingSets.title"), 0, 2) != 0) {
                return;
            }
            WorkingSetPersist workingSetPersist = WorkingSetPersist.getInstance();
            workingSetPersist.removeAllWorkingSet();
        }
        catch (Exception ex) {
            ErrorMessageHelper.showErrorDialog(this, ex);
        }
    }

    protected void onRemoveRecent() {
        try {
            Object current = this.combDir.getSelectedItem();
            this.recentCharactersDir.clrar();
            this.setRecents();
            if (current != null) {
                this.combDir.setSelectedItem(current);
            }
        }
        catch (Exception ex) {
            ErrorMessageHelper.showErrorDialog(this, ex);
        }
    }

    protected void setRecents() {
        while (this.combDir.getItemCount() > 0) {
            this.combDir.removeItemAt(0);
        }
        ArrayList<File> priorityDirs = new ArrayList<File>();
        File lastUseCatacterDir = this.recentCharactersDir.getLastUseCharacterDir();
        if (lastUseCatacterDir != null && this.defaultCharactersDir != null && !lastUseCatacterDir.equals(this.defaultCharactersDir)) {
            this.combDir.addItem(lastUseCatacterDir);
            priorityDirs.add(lastUseCatacterDir);
        }
        if (this.defaultCharactersDir != null) {
            this.combDir.addItem(this.defaultCharactersDir);
            priorityDirs.add(this.defaultCharactersDir);
        }
        for (File charactersDir : this.recentCharactersDir.getRecentCharacterDirsOrderByNewly()) {
            if (charactersDir == null || priorityDirs.contains(charactersDir)) continue;
            this.combDir.addItem(charactersDir);
        }
        if (this.combDir.getItemCount() > 0) {
            this.combDir.setSelectedIndex(0);
        }
    }

    public static File getCharacterDir(File defaultCharacterDir) {
        RecentCharactersDir recentChars;
        try {
            recentChars = RecentCharactersDir.load();
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "\u6700\u5f8c\u306b\u4f7f\u7528\u3057\u305f\u30ad\u30e3\u30e9\u30af\u30bf\u30fc\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u60c5\u5831\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", ex);
            recentChars = null;
        }
        if (recentChars == null) {
            recentChars = new RecentCharactersDir();
        }
        logger.log(Level.CONFIG, "RecentCharacterDirs.doNotAskAgain=" + recentChars.isDoNotAskAgain());
        if (recentChars.isDoNotAskAgain()) {
            File recentCharDir = recentChars.getLastUseCharacterDir();
            if (recentCharDir != null && recentCharDir.exists() && recentCharDir.isDirectory()) {
                return recentCharDir;
            }
            recentChars.setDoNotAskAgain(false);
        }
        JFrame dummyFrame = new JFrame();
        dummyFrame.setUndecorated(true);
        dummyFrame.setSize(0, 0);
        dummyFrame.setLocation(GraphicsEnvironment.getLocalGraphicsEnvironment().getCenterPoint());
        dummyFrame.setIconImage(UIHelper.getInstance().getImage("icons/icon.png"));
        dummyFrame.setVisible(true);
        SelectCharatersDirDialog dlg = new SelectCharatersDirDialog(dummyFrame, recentChars);
        dlg.setDefaultCharactersDir(defaultCharacterDir);
        dlg.setRecents();
        dlg.setVisible(true);
        dummyFrame.dispose();
        File selectedCharacterDir = dlg.getSelectedCharacterDir();
        if (selectedCharacterDir != null) {
            recentChars.setLastUseCharacterDir(selectedCharacterDir);
            try {
                recentChars.setDoNotAskAgain(dlg.isDoNotAskAgain());
                recentChars.saveRecents();
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, "\u6700\u5f8c\u306b\u4f7f\u7528\u3057\u305f\u30ad\u30e3\u30e9\u30af\u30bf\u30fc\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u60c5\u5831\u306e\u4fdd\u5b58\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", ex);
            }
        }
        return selectedCharacterDir;
    }
}

