/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui.scrollablemenu;

import charactermanaj.ui.scrollablemenu.ScrollableMenuEvent;
import charactermanaj.ui.scrollablemenu.ScrollableMenuEventListener;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.event.EventListenerList;

public class JScrollerMenuItem
extends JMenuItem {
    private static final long serialVersionUID = -1749741596476938310L;
    protected EventListenerList _listeners = new EventListenerList();

    public JScrollerMenuItem(Icon icon) {
        this.setIcon(icon);
    }

    public void addScrollableMenuEventListener(ScrollableMenuEventListener l) {
        this._listeners.add(ScrollableMenuEventListener.class, l);
    }

    public void removeScrollableMenuEventListener(ScrollableMenuEventListener l) {
        this._listeners.remove(ScrollableMenuEventListener.class, l);
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        ScrollableMenuEvent ee = null;
        int mouseEventId = e.getID();
        if (mouseEventId == 501) {
            ee = new ScrollableMenuEvent(this, true);
        }
        if (mouseEventId == 502) {
            ee = new ScrollableMenuEvent(this, false);
        }
        if (ee != null) {
            this.fireScrollableMenuEvent(ee);
        }
    }

    protected void fireScrollableMenuEvent(ScrollableMenuEvent e) {
        for (ScrollableMenuEventListener l : (ScrollableMenuEventListener[])this._listeners.getListeners(ScrollableMenuEventListener.class)) {
            if (e.isScrolling()) {
                l.start(e);
                continue;
            }
            l.end(e);
        }
    }
}

