/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.util;

import charactermanaj.ui.util.ScaleSupport;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public final class ErrorMessageHelper {
    private static final Logger logger = Logger.getLogger(ErrorMessageHelper.class.getName());

    private ErrorMessageHelper() {
    }

    public static void showErrorDialog(Component parent, Throwable ex) {
        if (ex == null) {
            return;
        }
        logger.log(Level.SEVERE, ex.getLocalizedMessage(), ex);
        JTextArea textArea = new JTextArea();
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        ex.printStackTrace(pw);
        pw.close();
        textArea.setText(sw.toString());
        textArea.setSelectionStart(0);
        textArea.setSelectionEnd(0);
        textArea.setEditable(false);
        JScrollPane scr = new JScrollPane(textArea);
        scr.setPreferredSize(new Dimension(400, 150));
        scr.setHorizontalScrollBarPolicy(32);
        scr.setVerticalScrollBarPolicy(22);
        JOptionPane pane = new JOptionPane(scr, 0);
        Window window = ErrorMessageHelper.getWindowForComponent(parent);
        String title = "ERROR";
        final JDialog dialog = window instanceof Frame ? new JDialog((Frame)window, title, true) : new JDialog((Dialog)window, title, true);
        Container contentPane = dialog.getContentPane();
        dialog.setDefaultCloseOperation(2);
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)pane, "Center");
        dialog.setResizable(true);
        ScaleSupport scaleSupport = ScaleSupport.getInstance(dialog);
        Dimension wnddim = dialog.getPreferredSize();
        wnddim = scaleSupport.manualScaled(wnddim);
        dialog.setSize(wnddim);
        dialog.setLocationRelativeTo(parent);
        pane.addPropertyChangeListener("value", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                if (dialog.isVisible() && event.getNewValue() != null) {
                    dialog.dispose();
                }
            }
        });
        dialog.setVisible(true);
    }

    static Window getWindowForComponent(Component parentComponent) throws HeadlessException {
        if (parentComponent == null) {
            return JOptionPane.getRootFrame();
        }
        if (parentComponent instanceof Frame || parentComponent instanceof Dialog) {
            return (Window)parentComponent;
        }
        return ErrorMessageHelper.getWindowForComponent(parentComponent.getParent());
    }
}

