/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.util;

import charactermanaj.util.ResourceLoader;
import charactermanaj.util.ResourceNames;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

public class LocalizedResourcePropertyLoader {
    private Map<ResourceNames, Properties> propCache;
    private static final LocalizedResourcePropertyLoader inst = new LocalizedResourcePropertyLoader(new HashMap<ResourceNames, Properties>());

    protected LocalizedResourcePropertyLoader() {
        this.propCache = null;
    }

    protected LocalizedResourcePropertyLoader(Map<ResourceNames, Properties> propCache) {
        if (propCache == null) {
            throw new NullPointerException("propCache is required.");
        }
        this.propCache = propCache;
    }

    public static LocalizedResourcePropertyLoader getCachedInstance() {
        return inst;
    }

    public static LocalizedResourcePropertyLoader getNonCachedInstance() {
        return new LocalizedResourcePropertyLoader();
    }

    public Properties getLocalizedProperties(String name) {
        return this.getLocalizedProperties(name, null);
    }

    public Properties getLocalizedProperties(String name, Locale locale) {
        return this.getLocalizedProperties(name, locale, false);
    }

    public Properties getLocalizedProperties(String name, Locale locale, boolean preferredNatural) {
        ResourceNames resNames = LocalizedResourcePropertyLoader.getResourceNames(name, locale);
        if (preferredNatural) {
            resNames = resNames.reverse();
        }
        return this.getProperties(resNames);
    }

    protected static ResourceNames getResourceNames(String name, Locale locale) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException();
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        String language = locale.getLanguage();
        String country = locale.getCountry();
        String variant = locale.getVariant();
        String[] resourceNames = new String[]{name + ".xml", name + "_" + language + ".xml", name + "_" + language + "_" + country + ".xml", name + "_" + language + "_" + country + "_" + variant + ".xml"};
        return new ResourceNames(resourceNames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties getProperties(ResourceNames resourceNames) {
        Properties prop;
        if (resourceNames == null) {
            throw new IllegalArgumentException();
        }
        if (this.propCache != null) {
            Map<ResourceNames, Properties> map = this.propCache;
            synchronized (map) {
                prop = this.propCache.get(resourceNames);
                if (prop == null) {
                    prop = this.loadProperties(resourceNames);
                    this.propCache.put(resourceNames, prop);
                }
            }
        } else {
            prop = this.loadProperties(resourceNames);
        }
        if (prop == null) {
            throw new RuntimeException("missing resource: " + resourceNames);
        }
        return prop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Properties loadProperties(ResourceNames resourceNames) {
        if (resourceNames == null) {
            throw new IllegalArgumentException();
        }
        ClassLoader[] loaders = new ClassLoader[]{ResourceLoader.getDefaultClassLoader(), ResourceLoader.getUsersResourceDirClassLoader(null, true)};
        boolean foundResource = false;
        Properties props = new Properties();
        for (ClassLoader loader : loaders) {
            if (loader == null) continue;
            for (String resourceName : resourceNames) {
                URL resource = loader.getResource(resourceName);
                if (resource == null) continue;
                Properties org = new Properties();
                try {
                    InputStream is = resource.openStream();
                    try {
                        org.loadFromXML(is);
                    }
                    finally {
                        is.close();
                    }
                }
                catch (Exception ex) {
                    throw new RuntimeException("resource loading error." + resource, ex);
                }
                foundResource = true;
                props.putAll((Map<?, ?>)org);
            }
        }
        if (foundResource) {
            return props;
        }
        return null;
    }
}

