/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.graphics.io;

import charactermanaj.graphics.io.ImageResource;
import charactermanaj.util.ResourceLoader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EmbeddedImageResource
implements ImageResource {
    private static final Logger logger = Logger.getLogger(EmbeddedImageResource.class.getName());
    private final ResourceLoader resourceLoader = new ResourceLoader(ResourceLoader.getDefaultClassLoader());
    private String resourceName;

    public EmbeddedImageResource(String resourceName) {
        if (resourceName == null) {
            throw new IllegalArgumentException();
        }
        this.resourceName = resourceName;
    }

    @Override
    public int compareTo(ImageResource o) {
        return this.getFullName().compareTo(o.getFullName());
    }

    @Override
    public int hashCode() {
        return this.getFullName().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ImageResource) {
            ImageResource o = (ImageResource)obj;
            return this.getFullName().equals(o.getFullName());
        }
        return false;
    }

    @Override
    public String getFullName() {
        return this.resourceName;
    }

    @Override
    public URI getURI() {
        URL url = this.getResource(this.resourceName);
        if (url != null) {
            try {
                return url.toURI();
            }
            catch (URISyntaxException ex) {
                logger.log(Level.WARNING, "resource name is invalid. " + this.resourceName, ex);
            }
        }
        return null;
    }

    @Override
    public long lastModified() {
        URL url = this.getResource(this.resourceName);
        if (url == null) {
            return 1L;
        }
        return 0L;
    }

    @Override
    public InputStream openStream() throws IOException {
        URL url = this.getResource(this.resourceName);
        if (url == null) {
            return null;
        }
        return url.openStream();
    }

    public String toString() {
        return this.getFullName();
    }

    private URL getResource(String resourceName) {
        return this.resourceLoader.getResource(resourceName);
    }
}

