/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui.util;

import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import javax.swing.JFrame;

public final class WindowAdjustLocationSupport {
    private WindowAdjustLocationSupport() {
    }

    public static void alignRight(JFrame mainWindow, Window window, int offset_y, boolean sameHeight) {
        Point pt = mainWindow.getLocation();
        Insets insets = mainWindow.getInsets();
        pt.x += mainWindow.getWidth();
        pt.y += offset_y * insets.top;
        GraphicsEnvironment genv = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Rectangle desktopSize = genv.getMaximumWindowBounds();
        if (pt.x + window.getWidth() > desktopSize.width) {
            pt.x -= pt.x + window.getWidth() - desktopSize.width;
        }
        if (pt.y + window.getHeight() > desktopSize.height) {
            pt.y -= pt.y + window.getHeight() - desktopSize.height;
        }
        window.setLocation(pt);
        if (sameHeight) {
            Dimension siz = window.getSize();
            siz.height = mainWindow.getHeight() - offset_y;
            window.setSize(siz);
        }
    }
}

