/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.util;

import charactermanaj.model.AppConfig;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public final class FileUtilities {
    private static final Method methodMoveToTrash = FileUtilities.getMethodMoveToTrash();

    private FileUtilities() {
    }

    private static Method getMethodMoveToTrash() {
        try {
            Desktop.Action moveToTrashType = Enum.valueOf(Desktop.Action.class, "MOVE_TO_TRASH");
            Desktop desktop = Desktop.getDesktop();
            if (!desktop.isSupported(moveToTrashType)) {
                return null;
            }
            return Desktop.class.getMethod("moveToTrash", File.class);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static boolean isSupportMoveToTrash() {
        return methodMoveToTrash != null;
    }

    public static void moveToTrash(File file) throws IOException {
        if (file == null) {
            throw new NullPointerException();
        }
        if (!FileUtilities.isSupportMoveToTrash()) {
            throw new UnsupportedOperationException("moveToTrash is not supported.");
        }
        if (!file.exists()) {
            return;
        }
        try {
            Desktop desktop = Desktop.getDesktop();
            Boolean ret = (Boolean)methodMoveToTrash.invoke((Object)desktop, file);
            if (ret == null || !ret.booleanValue()) {
                throw new IOException("failed to move to recyclebin. " + file);
            }
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
        catch (InvocationTargetException ex) {
            Throwable cause = ex.getCause();
            throw new IOException("failed to move to recyclebin. " + file, cause);
        }
    }

    public static void deleteRecursive(File file) throws IOException {
        File[] children;
        if (file == null) {
            throw new IllegalArgumentException();
        }
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory() && (children = file.listFiles()) != null) {
            for (File child : children) {
                FileUtilities.deleteRecursive(child);
            }
        }
        if (!file.delete()) {
            throw new IOException("can't delete file. " + file);
        }
    }

    public static void delete(File file) throws IOException {
        AppConfig appConfig = AppConfig.getInstance();
        if (FileUtilities.isSupportMoveToTrash() && appConfig.isUseRecycleBinIfSupported()) {
            FileUtilities.moveToTrash(file);
        } else {
            FileUtilities.deleteRecursive(file);
        }
    }
}

