/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.util;

import charactermanaj.util.LocalizedMessageAware;
import java.awt.Component;
import java.util.Properties;
import javax.swing.JList;
import javax.swing.plaf.basic.BasicComboBoxRenderer;

public class LocalizedMessageComboBoxRender
extends BasicComboBoxRenderer {
    private static final long serialVersionUID = 2148264299941543651L;
    private Properties strings;

    public LocalizedMessageComboBoxRender(Properties strings) {
        if (strings == null) {
            throw new IllegalArgumentException();
        }
        this.strings = strings;
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        String localizedString = this.getLocalizedString(value);
        return super.getListCellRendererComponent((JList<?>)list, localizedString, index, isSelected, cellHasFocus);
    }

    protected String getLocalizedString(Object value) {
        if (value == null) {
            return "(null)";
        }
        if (value instanceof LocalizedMessageAware) {
            LocalizedMessageAware o = (LocalizedMessageAware)value;
            String id = o.getLocalizedResourceId();
            String localizedString = null;
            if (id != null && (localizedString = this.strings.getProperty(id)) == null) {
                return id;
            }
            if (localizedString != null) {
                return localizedString;
            }
        }
        return value.toString();
    }
}

