<?php
/**
* ñʥե륯饹
*
* PHP version 5
*
* @package    forms
* @author     stk2k <stk2k@sazysoft.com>
* @copyright  2008 stk2k, sazysoft
*/


class charcoal_SimpleForm implements charcoal_IForm
{
	var $_dto;
	var $_model;
	var $_transformer;

	/*
	 * 󥹥ȥ饯
	 */
	public function __construct()
	{
		$this->_dto = new charcoal_DTO();
	}

	/*
	 * ե̾
	 */
	public function getFormName()
	{
		return "SimpleForm form";
	}

	/*
	 * ե
	 */
	public function init( charcoal_Config $config )
	{
		$model_class                = $config->getString( 'model_class' );
		$transformer_name           = $config->getString( 'transformer_name' );
		$this->_auto_input_request  = $config->getBoolean( 'auto_input_request' );
		$this->_auto_output         = $config->getBoolean( 'auto_output' );

		// եǥ
		$this->_model = charcoal_ClassUtil::newInstance( $model_class );
		
		// ȥ󥹥եޤ
		$this->_transformer = charcoal_TransformerFactory::create( $transformer_name );

	}

	/*
	 * եǥ
	 */
	public function getFormModel()
	{
		return $this->_model;
	}

	/*
	 * եǡ
	 */
	public function get( $key )
	{
		return $this->_form_values[ $key ];
	}

	/*
	 * ե˴Ϣդ줿DTO
	 */
	public function getDTO()
	{
		return $this->_dto;
	}

	/*
	 * ꥯȼưϤ뤫
	 */
	public function isAutoInputRequest()
	{
		return $this->_auto_input_request;
	}

	/*
	 * ưϤ뤫
	 */
	public function isAutoOutput()
	{
		return $this->_auto_output;
	}

	/*
	 * եХǡԤ
	 */
	public function validate()
	{
		return true;
	}

	/*
	 * DTOեϤԤ
	 */
	public function inputDTO( charcoal_DTO $dto, charcoal_IModel $model )
	{
		// ѴDTO顢FormModelؤѴԤ
		$dto = $this->_transformer->transform( $dto, $model, new charcoal_DTO(), $this->_model );

		$this->_dto = $dto;
	}

	/*
	 * RequstեϤԤ
	 */
	public function inputRequest( charcoal_Request $request )
	{
		$conv = charcoal_EncodingConverter::fromString( 'HTML_TO_PHP' );

		$model = $this->_model;
		$dto = new charcoal_DTO();

		$fields = $model->getFieldList();
		if ( $fields ){
			foreach( $fields as $field ){
				$value = $request->get( $field );
				if ( is_string($value) ){
					$value = $conv->convertEncoding( $value );
				}
				$dto->$field = $value;
			}
		}

		$this->_dto = $dto;
	}

	/*
	 * եͤDTOѴ
	 */
	public function toDTO( charcoal_IModel $model )
	{
		// ѴDTO顢FormModelؤѴԤ
		return $this->_transformer->transform( $this->_dto, $this->_model, new charcoal_DTO(), $model );
	}

	/*
	 * HTML֥ȤѴ
	 */
	public function toHTMLObject( charcoal_ProcedureContext $context, $read_only = FALSE )
	{
		return charcoal_HTMLFormFactory::create( $context, $this->_model, $this->_dto, $read_only );
	}
}
