<?php
/**
* ʸ󥯥饹
*
* PHP version 5
*
* @package    base
* @author     stk2k <stk2k@sazysoft.com>
* @copyright  2008 stk2k, sazysoft
*/

class String
{
	private $_value;
	private $_encoding;

	/*
	 *	󥹥ȥ饯
	 */
	public function __construct( $value, $encoding = NULL )
	{
		$this->_value      = $value;
		$this->_encoding   = $encoding;
	}

	/*
	 *	󥳡ǥѴ
	 */
	public function convertEncoding( $to_encoding )
	{
		$encoding = $this->_encoding ? $this->_encoding : Profile::getString('PHP_CODE');

		// Ѵ󥳡ǥ󥰤
		switch ( $this->_encoding ){
		case 'HTML_CODE':
		case 'DB_CODE':
		case 'PHP_CODE':
		case 'LOG_CODE':
			$from_encoding = chacoal_Profile::getString( $this->_encoding );
		default:
			$from_encoding = $this->_encoding;
		}

		// Ѵ襨󥳡ǥ󥰤
		switch ( $to_encoding ){
		case 'HTML_CODE':
		case 'DB_CODE':
		case 'PHP_CODE':
		case 'LOG_CODE':
			$to_encoding = Profile::getString( $to_encoding );
		}

		$str = mb_convert_encoding( $this->_value, $to_encoding, $from_encoding );

		return new String( $str, $to_encoding );
	}

	/*
	 *	ͤ
	 */
	public function getValue()
	{
		return $this->_value;
	}

	/*
	 *	Ĺ
	 */
	public function length()
	{
		return $this->_value && is_string($this->_value) ? strlen($this->_value) : -1;
	}

	/*
	 *	
	 */
	public function isEmpty()
	{
		if ( !$this->_value ){
			return TRUE;
		}
		if ( is_string($this->_value) ){
			return strlen($this->_value) === 0;
		}
		return TRUE;
	}

	/*
	 *	ʸ
	 */
	public function __toString()
	{
//		return $this->_value . "(" . $this->_encoding . ")";
		return is_string($this->_value) ? $this->_value : '';
	}

}
