<?php
/**
*
* YAMLѡSpycˤˤʥå嵡ǽդ
*
* PHP version 5
*
* @package    config_providers
* @author     stk2k <stk2k@sazysoft.com>
* @copyright  2008 stk2k, sazysoft
*/
require_once('Cache/Lite.php');

class CachedSpycConfigProvider extends Object implements IConfigProvider
{
	var $_cache;
	var $_config_file;

	/**
	 *    󥹥ȥ饯
	 *
	 * @access    public
	 */
	public function __construct()
	{
		parent::__construct();

		// åǥ쥯ȥ
		$cache_dir = ResourceLocator::getPath( ResourcePath::TEMP );

		// å奪ץ
		$options = array(
			'cacheDir' => "$cache_dir/",
			'lifeTime' => 999999999,
			'automaticSerialization' => TRUE
		);
		
		// å奪֥
		$this->_cache = new Cache_Lite($options);
	}

	/**
	 * ץХ̾
	 *
	 * @access    public
	 * @return    String
	 */
	public function getProviderName()
	{
		return "Cached Spyc Config Provider";
	}

	/**
	 *
	 *
	 * @access    public
	 * @param     config_name ̾
	 */
	public function load( $config_root, $config_name )
	{
		$config_file = ResourceLocator::getPath( ResourcePath::CONFIG, "$config_name.yml" );

		log_info( "system",  "ե[$config_file]ɤ߹ߤޤ", __FILE__, __LINE__ );

		// å夬뤫
		$cache_data = $this->_cache->get($config_file);
		if ( $cache_data )
		{
			// Ф
			$config = $cache_data;
		}
		else{
			require_once('spyc.php');

			if ( is_file($config_file) )
			{
				// Υ
				$config = Spyc::YAMLLoad($config_file);

				// å¸
				$ret = $this->_cache->save( $config, $config_file );
			}
		}

		log_info( "system",  "ե[$config_file]ɤ߹ߤޤ", __FILE__, __LINE__ );

		return $config;
	}

}
