<?php
/**
* ͤݻ륯饹
*
* PHP version 5
*
* @package    core
* @author     stk2k <stk2k@sazysoft.com>
* @copyright  2008 stk2k, sazysoft
*/

class Config extends Object
{
	private $_config;

	/*
	 *    󥹥ȥ饯
	 */
	public function __construct( $data = NULL )
	{
		parent::__construct();

		$this->_config = $data ? $data : array();
	}

	/*
	 *
	 */
	public function isEmptry()
	{
		return (count($this->_config) == 0);
	}

	/*
	 *¸ߤ뤫
	 */
	public function keyExists( $key )
	{
		return isset($this->_config[ $key ]);
	}

	/*
	 *ɲ
	 */
	public function append( $add )
	{
		if ( $add ){
			if ( is_array( $add ) ){
				$this->_config = array_merge( $this->_config, $add );
			}
			else{
				$this->_config[] = $add;
			}
		}
	}

	/*
	 *쳬ؤΥ
	 */
	public function getKeys()
	{
		return array_keys( $this->_config );
	}

	/*
	 * ͤʸȤƼ
	 */
	public function getString( $key, $default_value = NULL )
	{
		// ̤ʤʸ֤
		if ( !isset($this->_config[ $key ]) ){
			return $default_value;
		}

		// ͤ
		$value = $this->_config[ $key ];

		// եޥåȳǧ
		if ( !is_string($value) ){
			throw new StringFormatException( $value, "key=[$key]" );
		}

		$value = s($value);

		// ֵ
		return ConfigUtil::processMacro($value);
	}

	/*
	 * ͤȤƼ
	 */
	public function getArray( $key, $default_value = NULL )
	{
		// ̤ʤ֤
		if ( !isset($this->_config[ $key ]) ){
			return $default_value;
		}

		// ͤ
		$value = $this->_config[ $key ];

		// ޤʬ
		$array = explode( ',', $value );

		// ǤĤǶʤǥե֤ͤ
		if ( count($array) == 1 && $array[0] === '' ){
			return $default_value;
		}

		// եޥåȳǧ
		if ( !is_array($array) ){
			throw new ArrayFormatException( $value, "key=[$key]" );
		}

		// ֵ
		return  $array;
	}

	/*
	 * ͤϢȤƼ
	 */
	public function getAssoc( $key, $recursive = TRUE, $default_value = NULL )
	{
		// ̤ʤ֤
		if ( !isset($this->_config[ $key ]) ){
			return $default_value;
		}

		// ͤ
		$value = $this->_config[ $key ];

		// եޥåȳǧ
		if ( !is_array($value) ){
			throw new ArrayFormatException( $value, "key=[$key]" );
		}

		// ֵ
		return  $value;
	}

	/*
	 * ͤ֡ͤȤƼ
	 */
	public function getBoolean( $key, $default_value = NULL )
	{
		// ̤ʤFALSE֤
		if ( !isset($this->_config[ $key ]) ){
			return $default_value;
		}

		// ͤ
		$value = $this->_config[ $key ];

		if ( is_string($value) ){
			$value = ($value === 'true' || $value === 'on' || $alue === '1' );
		}

		// եޥåȳǧ
		if ( !is_bool($value) ){
			throw new BooleanFormatException( $value, "key=[$key]" );
		}

		// ֡뷿ˤֵ
		return $value;
	}

	/*
	 * ͤͤȤƼ
	 */
	public function getInteger( $key, $default_value = NULL )
	{
		// ̤ʤNULL֤
		if ( !isset($this->_config[ $key ]) ){
			return $default_value;
		}

		// ͤ
		$value = $this->_config[ $key ];

		// եޥåȳǧ
		if ( !is_integer($value) ){
			throw new IntegerFormatException( $value, "key=[$key]" );
		}

		// ˤֵ
		return (int)$value;
	}

	/*
	 *ͤ
	 */
	public function dump( $key = NULL )
	{
		$title     = get_class($this);
		$line_end  = '<BR>';
		$indent    = '---';
		if ( $key ){
			// ΥФͤ
			$value = $this->_config[ $key ];
			System::dumpVar( $value, $title, $line_end, $indent );
		}
		else{
			// ٤Ƥͤ
			System::dumpArray( $this->_config, $title, $line_end, $indent );
		}
	}

}