<?php

/**
* DB饹
*
* PHP version 5
*
* @package    core
* @author     stk2k <stk2k@sazysoft.com>
* @copyright  2008 stk2k, sazysoft
*/
class DB
{
	private $_source;
	private $_builder;
	private $_models;

	/*
	 *	󥹥ȥ饯
	 */
	public function __construct()
	{
		if ( Profile::getBoolean('USE_DB') )
		{
			// ǡɤ߹
			$data_source_name = Profile::getString( 'DB_DATA_SOURCE' );
			$this->_source = Factory::createDataSource( $data_source_name );

			// SQLӥɤ߹
			$builder_name = $this->_source->getBackend();
			if ( $builder_name ){
				$this->_builder = Factory::createSQLBuilder( $builder_name );
			}
		}
	}

	/*
	 *	ǡ
	 */
	public function getDataSource()
	{
		return $this->_source;
	}

	/*
	 *	SQLӥ
	 */
	public function getSQLBuilder()
	{
		return $this->_builder;
	}

	/*
	 *	ơ֥ǥμ
	 */
	public function getModel( $model_name )
	{
		// åˤФ֤
		if ( isset($this->_models[$model_name]) ){
			return $this->_models[$model_name];
		}
		// ʤΤǺ
		$model = Factory::createTableModel( $model_name );
		$this->_models[$model_name] = $model;

		return $model;
	}

	/*
	 *	¸
	 */
	public  function save( ITableModel $model, DTO $dto, $converter_str = NULL )
	{
		$conv = $converter_str ? EncodingConverter::fromString($converter_str) : NULL;

		try{
			// UPDATEINSERTȽ
			$pk = $model->getPrimaryKey();

			if ( isset($dto[$pk]) ){
				// ץ饤ޥꥭǸƤߤƥ쥳ɤʤINSERTUPDATE
				$db_dto = $this->findByID( $model, $dto[$pk] );
				$is_new = ($db_dto === NULL);
			}
			else{
				// ץ饤ޥꥭͤꤵƤʤINSERT
				$is_new = TRUE;
			}

			// SQL
			if ( $is_new ){
				list( $sql, $params ) = $this->_builder->buildInsertSQL( $model, $dto );
			}
			else{
				list( $sql, $params ) = $this->_builder->buildUpdateSQL( $model, $dto );
			}

			// ʸѴ
			if ( $conv ){
				foreach( $params as $key => $value ){
					if ( is_string($value) ){
						$value = $conv->convertEncoding( $value );
						$params[$key] = $value;
					}
				}
			}

			// SQL¹
			$this->_source->prepareExecute( $sql, $params );

			// ID֤
			if ( $is_new ){
				$sql = $this->_builder->buildLastIdSQL();
				
				// ¹
				$result = $this->_source->prepareExecute( $sql );

				// եå
				$row = $this->_source->fetchArray( $result );

				$new_id = $row[0];
			}
			else{
				$new_id = $dto[$pk];
			}

			return $new_id;
		}
		catch ( Exception $e )
		{
			ExceptionStack::push( $e );

			throw new DBException( "DB#save failed" );
		}
	}

	/*
	 *	SQL¹(INSERT/DELETE/UPDATE)
	 */
	public  function execute( $sql, $params = NULL )
	{
		try{
			// ¹
			$this->_source->prepareExecute( $sql, $params );
		}
		catch ( Exception $e ) 
		{
			ExceptionStack::push( $e );

			// ̤throw
			throw new DBException( "exec_SQL failed" );
		}
	}

	/*
	 *	SQL¹(SELECT)
	 */
	public  function query( $sql, $params = NULL, $converter_str = NULL )
	{
		$conv = $converter_str ? EncodingConverter::fromString($converter_str) : NULL;

		// ƥʤDataSourceݡͥȤ
		$ds = $this->_source;

		$a = array();

		try{

			// ¹
			$result = $ds->prepareExecute( $sql, $params );

			// եå
			while( $row = $ds->fetchAssoc( $result ) ){
				foreach( $row as $key => $value ){
					// ʸʤ饨󥳡ǥѴ
					if ( $conv && is_string($value) ){
						$value = $conv->convertEncoding($value);
						$row[$key] = $value;
					}
				}
				$a[] = $row;
			}
		}
		catch ( Exception $e ) 
		{
			ExceptionStack::push( $e );

			// ̤throw
			throw new DBException( "exec_SQL failed" );
		}

		return $a;
	}

	/*
	 *	SQL
	 */
	public  function findBySQL( ITableModel $model, $sql, $params = NULL, $converter_str = NULL ) 
	{
		$conv = $converter_str ? EncodingConverter::fromString($converter_str) : NULL;

		$a = NULL;

		// Ϣ
		$relation_list = $model->getRelationList();
		$relation_map = array();
		foreach ($relation_list as $field) 
		{
			// @target
			$target = $model->getAnnotationValue( $field, 'target' );
			if ( !$target ){
				throw new DBException( "@target is missing for @relation: field=$field" );
			}
			$target = $this->getModel( $target );

			// @foreign_key
			$foreign_key = $model->getAnnotationValue( $field, 'foreign_key' );

			// @key_field
			$key_field = $model->getAnnotationValue( $field, 'key_field' );

			// @linkage
			$linkage = $model->getAnnotationValue( $field, 'linkage', 'inner' );
			if ( $linkage !== 'inner' && $linkage !== 'outer' ){
				throw new DBException( "Invalid linkage anottation : $linkage" );
			}

			// @extract
			$extract = $model->getAnnotationValue( $field, 'extract' );

			// ȥեɤά줿ν
			if ( !$foreign_key ){
				if ( $linkage === 'inner' ){
					$foreign_key = $model->getForeignKey( $target->getModelID() );
				}
				else if ( $linkage === 'outer' ){
					$foreign_key = $target->getForeignKey( $model );
				}
			}
			if ( !$key_field ){
				if ( $linkage === 'inner' ){
					$key_field = $target->getPrimaryKey();
				}
				else if ( $linkage === 'outer' ){
					$key_field = $model->getPrimaryKey();
				}
			}

			// ޥåפ¸Ƥ
			$relation_map[ $field ] = new DBRelation( $target, $foreign_key, $key_field, $linkage, $extract );
		}

		// DataSource
		$ds = $this->_source;

		try{
			// եɰ
			$field_list = $model->getFieldList();

			// ¹
			$result = $ds->prepareExecute( $sql, $params );

			// եå
			while( $row = $ds->fetchAssoc( $result ) )
			{
				$dto = new DTO();

				// ץ饤ޥꥭ
				$pk = $model->getPrimaryKey();
				$id = $row[ $pk ];
				// Ϣ
				foreach ($relation_list as $field) 
				{
					// Ϣ
					$relation = $relation_map[ $field ];
					// Ϣơ֥ǥ
					$target = $relation->getTarget();
					// ̾
					$foreign_key = $relation->getForeignKey();
					// ե̾
					$key_field = $relation->getKeyField();
					// 󥱡
					$linkage = $relation->getLinkage();
					// Ÿե
					$extract = $relation->getExtract();
					// Ϣơ֥̾
					$table_name = $target->getTableName();

					// SQL
					switch ( $linkage ){
					case 'inner':
						{
							// 󥱡 : ơ֥¦ˤ
							$key_value = $row[ $foreign_key ];
							$sql = "select * from $table_name where $key_field = ?";
						}
						break;
					case 'outer':
						{
							// 󥱡 : Ϣơ֥¦ˤ
							$key_value = $row[ $key_field ];
							$sql = "select * from $table_name where $foreign_key = ?";
						}
						break;
					default:
						{
							// ˤϤʤϤ
							throw new DBException( "Invalid linkage anottation : $linkage" );
						}
						break;
					}
					// ̤DTO˥ޡ
					$child_result = $this->findBySQL( $target, $sql, array($key_value), $converter_str );
					switch ( $extract ){
					case 'field':
						{
							// եɤŸ
							if ( $child_result && is_array($child_result) ){
								$child = array_shift( $child_result );
								if ( $child ){
									foreach( $child as $key => $value ){
										$extract_field = $model->getExtractField( $target->getModelID(), $key );
										if ( $extract_field ){
											$dto->$extract_field = $value;
										}
									}
								}
							}
						}
						break;
					case 'array':
					default:
						{
							// ˥å
							$dto->$field = $child_result;
						}
						break;
					}
				}
				// SQL̥åȤDTOͤ򥳥ԡ
				foreach ($field_list as $name) 
				{
					// ե
					$value = $row[ $name ];
					// ʸʤ饨󥳡ǥѴ
					if ( $conv && is_string($value) ){
						$value = $conv->convertEncoding($value);
					}
					// ֵ
					$dto->$name = $value;
				}
				$a[] = $dto;
			}
		}
		catch ( Exception $e ) 
		{
			ExceptionStack::push( $e );

			// ̤throw
			throw new DBException( "findBySQL failed" );
		}

		return $a;
	}

	/*
	 *	ǽΣ
	 */
	public  function findFirst( $dto, SQLCriteria $condition = NULL, $converter_str = NULL ) 
	{
		if ( !$condition ){
			$condition = new SQLCriteria();
		}

		// LIMIT=1
		$condition->setLimit( 1 );

		// ¹
		$result = $this->findAll( $dto, $condition, $converter_str );

		return array_shift($result);
	}

	/*
	 *	
	 */
	public  function findAll( ITableModel $model, SQLCriteria $criteria = NULL, $converter_str = NULL ) 
	{
		try{
			// ơ֥̾
			$table = $model->getTableName();

			// SQLӥ
			$builder = $this->_builder;

			// SQLκ
			$sql = $builder->buildSelectSQL( $model, $criteria );

			// ѥ᡼
			$params = $criteria ? $criteria->getParams() : NULL;

			// ¹
			$result = $this->findBySQL( $model, $sql, $params, $converter_str );

			return $result;
		}
		catch ( Exception $e )
		{
			ExceptionStack::push( $e );

			throw new DBException( "DB#findAll failed" );
		}
	}

	/*
	 *	ĤΥեɤΤߤǸ
	 */
	public  function findAllBy( ITableModel $model, $field, $value, SQLCriteria $criteria = NULL, $converter_str = NULL )
	{
		if ( !$criteria ){
			$criteria = new SQLCriteria();
		}

		$criteria->setWhereClause( "$field = ?" );
		$criteria->setParams( array( $value ) );

		$a = $this->findAll( $model, $criteria, $converter_str );

		return $a;
	}

	/*
	 *	ID鸡(Ĥꤷ)
	 */
	public  function findByID( ITableModel $model, $id, $converter_str = NULL ) 
	{
		// Ĥꤷ
		$where_clause = 'id = ?';
		$params = array( $id );

		$criteria = new SQLCriteria( $where_clause, $params );

		$a = $this->findAll( $model, $criteria, $converter_str );

		return $a ? current($a) : NULL;
	}

	/*
	 *	ID鸡
	 */
	public  function findAllByID( ITableModel $model, $id_array ) 
	{
		// ʣĻꤷ
		$where = array();
		$params = array();
		
		foreach( $id_array as $id ){
			$where[] = "?";
			$params[] = $id;
		}

		$where_clause = "id in (" . implode(",",$where) . ")";

		$condition = new SQLCriteria( $where_clause, $params );

		$a = $this->findAll( $dto, $condition );

		return $a;
	}

	/*
	 *	ʣĤꤷ
	 */
	public  function destroyById( ITableModel $model, $id ) 
	{
		try{
			// ե̾
			$pk = $model->getPrimaryKey();

			// SQLѥ᡼
			$params = array( "$id" );

			// 
			$criteria = new SQLCriteria();
			$criteria->setWhereClause( "$pk = ?" );
			$criteria->setParams( $params );

			// SQLӥȤSQL
			$sql = $this->_builder->buildDeleteSQL( $model, $criteria );

			$this->execute( $sql, $params );
		}
		catch ( Exception $e )
		{
			ExceptionStack::push( $e );

			throw new DBException( "DB#destroyById failed" );
		}
	}

	/*
	 *	ʣꤷ
	 */
	public  function destroyAllById( ITableModel $model, $id_array ) 
	{
		try{
			// ơ֥̾
			$table = self::getTableNameFromDTO( $dto );

			// ʣĻꤷ
			$where = array();
			$params = array();
			
			foreach( $id_array as $id ){
				$where[] = "?";
				$params[] = $id;
			}

			$sql = "delete from $table where id in (" . implode(",",$where) . ")";

			$this->execute( $sql, $params );
		}
		catch ( Exception $e )
		{
			ExceptionStack::push( $e );

			throw new DBException( "DB#destroyById failed" );
		}
	}

	/*
	 *	ĤΥեɤ˹פ쥳ɤ
	 */
	public  function destroyBy( ITableModel $model, $field, $value )
	{
		$where_clause = "$field = ?";
		$params = array( $value );

		$this->destroyAll( $dto, $where_clause, $params );
	}


	/*
	 *	˹פ쥳ɤ
	 */
	public  function destroyAll( ITableModel $model, $where_clause = NULL, $params = NULL ) 
	{
		try{
			// ơ֥̾
			$table = self::getTableNameFromDTO( $dto );

			$sql = "delete from $table where $where_clause";

			$this->execute( $sql, $params );
		}
		catch ( Exception $e )
		{
			ExceptionStack::push( $e );

			throw new DBException( "DB#destroyAll failed" );
		}
	}

	/*
	 *	ơ֥Υ쥳ɿ
	 */
	public  function count( ITableModel $model, $where_clause = NULL, $params = NULL ) 
	{
		try{
			if ( $where_clause ){
				$criteria = new SQLCriteria();
				$criteria->setWhereClause( $where_clause );
				$criteria->setParams( $params );
			}
			else{
				$criteria = NULL;
			}

			// SQL
			$sql = $this->_builder->buildCountSQL( $model, $criteria );

			// SQL¹
			$result = $this->_source->prepareExecute( $sql, $params );

			// եå
			$rows = $this->_source->fetchArray( $result );

			return $rows[0];
		}
		catch ( Exception $e )
		{
			ExceptionStack::push( $e );

			throw new DBException( "DB#count failed" );
		}
	}

	/*
	 *	եɤκͤ
	 */
	public  function max( ITableModel $model, $field_name, $where_clause = NULL, $params = NULL ) 
	{
		try{
			if ( $where_clause ){
				$criteria = new SQLCriteria();
				$criteria->setWhereClause( $where_clause );
				$criteria->setParams( $params );
			}
			else{
				$criteria = NULL;
			}

			// SQL
			$sql = $this->_builder->buildMaxSQL( $model, $field_name, $criteria );

			// SQL¹
			$result = $this->_source->prepareExecute( $sql, $params );

			// եå
			$rows = $this->_source->fetchArray( $result );

			return $rows[0];
		}
		catch ( Exception $e )
		{
			ExceptionStack::push( $e );

			throw new DBException( "DB#count failed" );
		}
	}


	/*
	 *	DB
	 */
	public  function createDatabase( $db_name, $charset ) 
	{
		try{
			// SQLӥȤSQL
			$sql = $this->_builder->buildCreateDatabaseSQL( $db_name, $charset );

			// SQL¹
			$this->_source->execute( $sql );

		}
		catch ( Exception $e )
		{
			ExceptionStack::push( $e );

			throw new DBException( "DB#createDB failed" );
		}
	}

	/*
	 *	ơ֥
	 */
	public  function createTable( ITableModel $model ) 
	{
		try{
			// SQLӥȤSQL
			$sql = $this->_builder->buildCreateTableSQL( $model );

			// SQL¹
			$this->_source->execute( $sql );

		}
		catch ( Exception $e )
		{
			ExceptionStack::push( $e );

			throw new DBException( "DB#createDB failed" );
		}
	}
}
