<?php
/**
* 㳰å
*
* PHP version 5
*
* @package    base
* @author     stk2k <stk2k@sazysoft.com>
* @copyright  2008 stk2k, sazysoft
*/

class ExceptionStack 
{
	static $stack;

	/**
	 *	󥹥ȥ饯
	 */
	private function __construct()
	{
	}

	/**
	 *	㳰å
	 */
	private static function init()
	{
		if ( !self::$stack ){
			self::$stack = new Stack();
		}
	}

	/**
	 *	åƬˤ㳰
	 */
	public static function getHead()
	{
		self::init();

		$entry = self::$stack->getHead();

		return array( $entry->getException(), $entry->getFile(), $entry->getLine() );
	}

	/**
	 *	㳰å
	 */
	public static function isEmpty()
	{
		self::init();

		return self::$stack->isEmpty();
	}

	/**
	 *	åˤ
	 */
	public static function clear()
	{
		self::init();

		self::$stack->clear();
	}

	/**
	 *	ϿƤ㳰
	 */
	public static function count()
	{
		self::init();

		return self::$stack->count();
	}

	/**
	 *	å㳰ɲ
	 */
	public static function push( Exception $e )
	{
		self::init();

		list( $file, $line ) = System::caller();
		$entry = new ExceptionStackEntry( $e, $file, $line );
		return self::$stack->push( $entry );
	}

	/**
	 *	å㳰Ф
	 *
	 *	@return list($exception,$file,$line) 㳰եֹ̾
	 */
	public static function pop()
	{
		self::init();

		$entry = self::$stack->pop();

		return array( $entry->getException(), $entry->getFile(), $entry->getLine() );
	}
}
