<?php
/**
* եȥꥯ饹
*
* PHP version 5
*
* @package    core
* @author     stk2k <stk2k@sazysoft.com>
* @copyright  2008 stk2k, sazysoft
*/

class Factory
{
	/*
	 * åե
	 */
	public static function createCacheFile( $cache_file_name, $data = NULL )
	{
		log_info( "system",  "åե[$cache_file_name]ɤޤ", __FILE__, __LINE__ );

		// åեեɤ߹
		$cache_file_config = ConfigLoader::loadConfig( $cache_file_name, "cache_file" );

		// åեΥ󥹥
		$cache_file = new CacheFile( $cache_file_name, $data );

		log_info( "system",  "åե[$cache_file_name]ޤ", __FILE__, __LINE__ );

		// åե
		$cache_file->initCacheFile( $cache_file_config );

		log_info( "system",  "åե[$cache_file_name]ɤޤ", __FILE__, __LINE__ );

		// ɤåեֵ
		return $cache_file;
	}

	/*
	 *    饹
	 */
	public static function createClassLoader( $class_loader_name )
	{
		log_info( "system",  "饹[$class_loader_name]ޤ", __FILE__, __LINE__ );

		// ץХ
		$provider = Factory::createConfigProvider();

		// ͳǼѥ֥Ȥ
		$config= new Config();

		// 롼ȥѥ
		$config_root_webapp = ResourceLocator::getWebAppPath('config');
		$config_root_system = ResourceLocator::getSystemPath('config');

		// եɤ߹
		$config_name = "class_loaders/$class_loader_name.class_loader";
		$config->append( $provider->load( $config_root_system, $config_name ) );
		$config->append( $provider->load( $config_root_webapp, $config_name ) );

		// 饹̾
		$class_name = $config->getString( 'class_name' );

		// 饹̾γǧ
		if ( !$class_name || !ClassUtil::validateClassName($class_name) ){
			throw new ClassLoaderConfigException( 'class_name', 'mandatory' );
		}

		// ѥ
		$source_file = $config->getString( 'source_file' );

		if ( !$source_file || $source_file->isEmpty() ){
			throw new ClassLoaderConfigException( 'source_file', 'mandatory' );
		}

		// μ
//		require_once( "$source_file" );
		require( "$source_file" );

		// 饹Υ󥹥
		$classloader = ClassUtil::newInstance( $class_name );

		// 󥹥󥹤IClassLoader󥿥եƤ뤫ǧ
		if ( !($classloader instanceof IClassLoader) ){
			// 㳰
			throw new InterfaceImplementException( $class_name, "IClassLoader" );
		}

		log_info( "system",  "饹[$class_loader_name]ޤ", __FILE__, __LINE__ );

		// ɤ饹ֵ
		return $classloader;
	}

	/*
	 * ץХ
	 */
	public static function createConfigProvider()
	{
//		log_info( "system",  "ץХɤޤ", __FILE__, __LINE__ );

		// ץХ饹̾
		$class_name = Profile::getString( 'CONFIG_PROVIDER_CLASS' );

		// ̤ʤǥեȤץХ
		if ( !$class_name || $class_name->isEmpty() ){
			$class_name = s('IniConfigProvider');
		}

		// ץХΥ󥹥
		$provider = ClassUtil::newInstance( $class_name );

		// 󥹥󥹤IConfigProvider󥿥եƤ뤫ǧ
		if ( !($provider instanceof IConfigProvider) ){
			// provider
			throw new InterfaceImplementException( $class_name, "IConfigProvider" );
		}

//		log_info( "system",  "ץХɤޤ", __FILE__, __LINE__ );

		// ɤץХֵ
		return $provider;
	}

	/*
	 * ǡ
	 */
	public static function createDataSource( $data_source_name )
	{
		log_info( "system",  "ǡ[$data_source_name]ɤޤ", __FILE__, __LINE__ );

		// Config
		$config = ConfigLoader::loadConfig( $data_source_name, "data_source" );

		// 饹̾
		$class_name = $config->getString( "class_name" );

		// 饹̾γǧ
		if ( !$class_name || !ClassUtil::validateClassName($class_name) ){
			throw new DataSourceConfigException( 'class_name', 'mandatory' );
		}

		// ǡΥ󥹥
		$data_source = ClassUtil::newInstance( $class_name );

		// 󥹥󥹤IValidator󥿥եƤ뤫ǧ
		if ( !($data_source instanceof IDataSource) ){
			// 㳰
			throw new InterfaceImplementException( $class_name, "IDataSource" );
		}

		log_info( "system",  "ǡ[$data_source_name]ޤ", __FILE__, __LINE__ );

		// ǡ
		$data_source->init( $config );

		log_info( "system",  "ǡ[$data_source_name]ɤޤ", __FILE__, __LINE__ );

		// ɤǡֵ
		return $data_source;
	}

	/*
	 * ٥Ȥ
	 */
	public static function createEvent( $event_name, IRequest $request )
	{
		log_info( "system",  "٥[$event_name]ɤޤ", __FILE__, __LINE__ );

		// ValidatorConfig
		$event_config = ConfigLoader::loadConfig( $event_name, "event" );

		// 饹̾
		$class_name = $event_config->getString( "class_name" );

		// 饹̾γǧ
		if ( !$class_name || !ClassUtil::validateClassName($class_name) ){
			throw new EventConfigException( 'class_name', 'mandatory' );
		}

		// ٥ȤΥ󥹥
		$event = ClassUtil::newInstance( $class_name, $request );

		// 󥹥󥹤IEvent󥿥եƤ뤫ǧ
		if ( !($event instanceof IEvent) ){
			// 㳰
			throw new InterfaceImplementException( $class_name, "IEvent" );
		}

		log_info( "system",  "٥[$event_name]ޤ", __FILE__, __LINE__ );

		// ٥Ȥ
		$event->init( $event_config );

		log_info( "system",  "٥[$event_name]ɤޤ", __FILE__, __LINE__ );

		// ɤ٥Ȥֵ
		return $event;
	}

	/*
	 * ե륿
	 */
	public static function createFilter( $filter_name )
	{
		log_info( "system",  "ե륿[$filter_name]ɤޤ", __FILE__, __LINE__ );

		// FilterConfig
		$config = ConfigLoader::loadConfig( $filter_name, 'filter' );

		// 饹̾
		$class_name = $config->getString( 'class_name' );

		// 饹̾γǧ
		if ( !$class_name || !ClassUtil::validateClassName($class_name) ){
			throw new FilterConfigException( 'class_name', 'mandatory' );
		}

		// ե륿Υ󥹥
		$filter = ClassUtil::newInstance( $class_name );

		// 󥹥󥹤IFilter󥿥եƤ뤫ǧ
		if ( !($filter instanceof IFilter) ){
			// 㳰
			throw new InterfaceImplementException( $class_name, "IFilter" );
		}

		log_info( "system",  "ե륿[$filter_name]ޤ", __FILE__, __LINE__ );

		// ե륿
		$filter->init( $config );

		log_info( "system",  "ե륿[$filter_name]ɤޤ", __FILE__, __LINE__ );

		// ɤե륿ֵ
		return $filter;
	}

	/*
	 * ե
	 */
	public static function createForm( $form_name )
	{
		log_info( "system",  "ե[$form_name]ɤޤ", __FILE__, __LINE__ );

		// FormConfig
		$config = ConfigLoader::loadConfig( $form_name, "form" );

		// 饹̾
		$class_name = $config->getString( 'class_name' );

		// 饹̾γǧ
		if ( !$class_name || !ClassUtil::validateClassName($class_name) ){
			throw new FormConfigException( 'class_name', 'mandatory' );
		}

		// եΥ󥹥
		$form = ClassUtil::newInstance( $class_name );

		// 󥹥󥹤Iform󥿥եƤ뤫ǧ
		if ( !($form instanceof IForm) ){
			// 㳰
			throw new InterfaceImplementException( $class_name, "IForm" );
		}

		log_info( "system",  "ե[$form_name]ޤ", __FILE__, __LINE__ );

		// ե
		$form->init( $config );

		log_info( "system",  "ե[$form_name]ɤޤ", __FILE__, __LINE__ );

		// ɤեֵ
		return $form;
	}

	/*
	 * 쥤ȥޥ͡
	 */
	public static function createLayoutManager( $layout_manager_name )
	{
		log_info( "system",   "쥤ȥޥ͡[$layout_manager_name]ɤޤ", __FILE__, __LINE__ );

		// DispatcherConfig
		$config = ConfigLoader::loadConfig( $layout_manager_name, "layout_manager" );

		// 饹̾
		$class_name = $config->getString( "class_name" );

		// 饹̾γǧ
		if ( !$class_name || !ClassUtil::validateClassName($class_name) ){
			throw new LayoutManagerConfigException( 'class_name', 'mandatory' );
		}

		// 쥤ȥޥ͡Υ󥹥
		$layout_manager = ClassUtil::newInstance( $class_name );

		// 󥹥󥹤ILayoutManager󥿥եƤ뤫ǧ
		if ( !($layout_manager instanceof ILayoutManager) ){
			// 㳰
			throw new InterfaceImplementException( $class_name, "ILayoutManager" );
		}

		log_info( "system",   "쥤ȥޥ͡[$layout_manager_name]ޤ", __FILE__, __LINE__ );

		// 쥤ȥޥ͡
		$layout_manager->init( $config );

		log_info( "system",   "쥤ȥޥ͡[$layout_manager_name]ɤޤ", __FILE__, __LINE__ );

		// ɤ쥤ȥޥֵ͡
		return $layout_manager;
	}

	/*
	 * 
	 */
	public static function createLogger( $logger_name )
	{
		if ( strlen("$logger_name") == 0 ){
			throw new ParameterException();
		}

		// ץХ
		$provider = Factory::createConfigProvider();

		// ͳǼѥ֥Ȥ
		$config= new Config();

		// 롼ȥѥ
		$config_root_webapp = ResourceLocator::getWebAppPath('config');
		$config_root_system = ResourceLocator::getSystemPath('config');

		// եɤ߹
		$config_name = "loggers/$logger_name.logger";
		$config->append( $provider->load( $config_root_system, $config_name ) );
		$config->append( $provider->load( $config_root_webapp, $config_name ) );

		// 饹̾
		$class_name = $config->getString( 'class_name' );

		// 饹̾γǧ
		if ( !$class_name || !ClassUtil::validateClassName($class_name) ){
			throw new LoggerConfigException( 'class_name', "invalid class name:$class_name" );
		}

		// Υ󥹥
		$logger = ClassUtil::newInstance( $class_name );

		// 󥹥󥹤ILogger󥿥եƤ뤫ǧ
		if ( !($logger instanceof ILogger) ){
			// 㳰
			throw new InterfaceImplementException( $class_name, "ILogger" );
		}

		// 
		$logger->init( $config );

		// ɤֵ
		return $logger;
	}

	/*
	 * ⥸塼
	 */
	public static function createModule( $module_name )
	{
		log_info( "system",  "⥸塼[$module_name]ɤޤ", __FILE__, __LINE__ );

		// ⥸塼եɤ߹
		$config = ConfigLoader::loadConfig( $module_name, 'module' );

		// 饹̾
		$class_name = $config->getString( 'class_name' );

		// 饹̾γǧ
		if ( !$class_name || !ClassUtil::validateClassName($class_name) ){
			throw new ModuleConfigException( 'class_name', 'mandatory' );
		}

		// ⥸塼Υ󥹥
		$module = ClassUtil::newInstance( $class_name );

		log_info( "system",  "module[$module]", __FILE__, __LINE__ );

		// 󥹥󥹤IModule󥿥եƤ뤫ǧ
		if ( !($module instanceof IModule) ){
			// 㳰
			throw new InterfaceImplementException( $class_name, "IModule" );
		}

		log_info( "system",  "⥸塼[$module_name]ޤ", __FILE__, __LINE__ );

		// ⥸塼
		$module->init( $config );

		log_info( "system",  "⥸塼[$module_name]ɤޤ", __FILE__, __LINE__ );

		// ɤ⥸塼ֵ
		return $module;
	}

	/*
	 * ץ
	 */
	public static function createProcedure( $proc_key )
	{
		log_info( "system",  "ץ[$proc_key]ޤ", __FILE__, __LINE__ );

		// proc_list.iniɤ߹
		$config_file = ResourceLocator::getWebAppPath( 'config', "proc_list.ini" );
		if ( is_file($config_file) ){
			$proc_list = parse_ini_file($config_file,FALSE);
		}
		else{
			$proc_list = array();
		}

		// ϿƤʤꤵ줿404
		if ( !isset($proc_list[ "$proc_key" ]) ){
			log_error( 'system,error', "ϿƤʤץ㥭Ǥ:$proc_key", __FILE__, __LINE__ );
			throw new HttpException( 404 );
		}

		// ץ㥭ץ̾Ѵ
		$proc_name = $proc_list[ "$proc_key" ];

		// ProcedureConfig
		$config = ConfigLoader::loadConfig( $proc_name, "procedure" );

		// 饹̾
		$class_name = $config->getString( 'class_name' );

		// 饹̾γǧ
		if ( !$class_name || !ClassUtil::validateClassName($class_name) ){
			throw new ProcedureConfigException( 'class_name', 'mandatory' );
		}

		// ץΥ󥹥
		$procedure = ClassUtil::newInstance( $class_name );

		// 󥹥󥹤Iprocedure󥿥եƤ뤫ǧ
		if ( !($procedure instanceof IProcedure) ){
			// 㳰
			throw new InterfaceImplementException( $class_name, "IProcedure" );
		}

		log_info( "system",  "ץ[$proc_key]ޤ", __FILE__, __LINE__ );

		// ץ
		$procedure->init( $config );

		log_info( "system",  "ץ[$proc_key]ޤ", __FILE__, __LINE__ );

		// ץ㡢ץֵ̾
		return array( $procedure, $proc_name );
	}

	/*
	 * 顼
	 */
	public static function createRenderer( $renderer_name )
	{
		log_info( "system",  "顼[$renderer_name]ɤޤ", __FILE__, __LINE__ );

		// RendererConfig
		$config = ConfigLoader::loadConfig( $renderer_name, 'renderer' );

		// 饹̾
		$class_name = $config->getString( 'class_name' );

		// 饹̾γǧ
		if ( !$class_name || !ClassUtil::validateClassName($class_name) ){
			throw new RendererConfigException( 'class_name', 'mandatory' );
		}

		// 顼Υ󥹥
		$renderer = ClassUtil::newInstance( $class_name );

		// 󥹥󥹤IRenderer󥿥եƤ뤫ǧ
		if ( !($renderer instanceof IRenderer) ){
			// 㳰
			throw new InterfaceImplementException( $class_name, "IRenderer" );
		}

		log_info( "system",  "顼[$renderer_name]ޤ", __FILE__, __LINE__ );

		// 顼
		$renderer->init( $config );

		log_info( "system",  "顼[$renderer_name]ɤޤ", __FILE__, __LINE__ );

		// ɤ顼ֵ
		return $renderer;
	}

	/*
	 * ꥽
	 */
	public static function createResource( $resource_name )
	{
		log_info( 'system', "꥽[$resource_name]ɤޤ", __FILE__, __LINE__ );

		// ꥽եɤ߹
		$config = ConfigLoader::loadConfig( $resource_name, 'resource' );

		// 饹̾
		$class_name = $config->getString( 'class_name' );

		// 饹̾γǧ
		if ( !$class_name || !ClassUtil::validateClassName($class_name) ){
			throw new ResourceConfigException( 'class_name', 'mandatory' );
		}

		// ꥽Υ󥹥
		$resource = ClassUtil::newInstance( $class_name );

		// 󥹥󥹤IResource󥿥եƤ뤫ǧ
		if ( !($resource instanceof IResource) ){
			// 㳰
			throw new InterfaceImplementException( $class_name, "IResource" );
		}

		log_info( 'system',  "꥽[$resource_name]ޤ", __FILE__, __LINE__ );

		// ꥽
		$resource->init( $config );

		log_info( 'system', "꥽[$resource_name]ɤޤ", __FILE__, __LINE__ );

		// ɤ꥽ֵ
		return $resource;
	}

	/*
	 * åϥɥ
	 */
	public static function createSessionHandler( $session_handler_name )
	{
		log_info( "system",  "åϥɥ[$session_handler_name]ɤޤ", __FILE__, __LINE__ );

		// session_handlerConfig
		$config = ConfigLoader::loadConfig( $session_handler_name, "session_handler" );

		// 饹̾
		$class_name = $config->getString( "class_name" );

		// 饹̾γǧ
		if ( !$class_name || !ClassUtil::validateClassName($class_name) ){
			throw new SessionHandlerConfigException( 'class_name', 'mandatory' );
		}

		// åϥɥΥ󥹥
		$session_handler = ClassUtil::newInstance( $class_name );

		// 󥹥󥹤Isession_handler󥿥եƤ뤫ǧ
		if ( !($session_handler instanceof ISessionHandler) ){
			// 㳰
			throw new InterfaceImplementException( $class_name, "ISessionHandler" );
		}

		log_info( "system",  "åϥɥ[$session_handler_name]ޤ", __FILE__, __LINE__ );

		// åϥɥ
		$session_handler->init( $config );

		ini_set('session.save_handler', 'user');

		// åϥɥΥХåؿϿ
		session_set_save_handler(
					array( "$class_name", 'open' ), 
					array( "$class_name", 'close' ), 
					array( "$class_name", 'read' ), 
					array( "$class_name", 'write' ), 
					array( "$class_name", 'destroy' ), 
					array( "$class_name", 'gc' )
			);

		log_info( "system",  "åϥɥ[$session_handler_name]ɤޤ", __FILE__, __LINE__ );

		// ɤåϥɥֵ
		return $session_handler;
	}

	/*
	 * SQLӥ
	 */
	public static function createSQLBuilder( $builder_name )
	{
		log_info( "system",  "SQLӥ[$builder_name]ɤޤ", __FILE__, __LINE__ );

		// builderConfig
		$config = ConfigLoader::loadConfig( $builder_name, "sql_builder" );

		// 饹̾
		$class_name = $config->getString( "class_name" );

		// 饹̾γǧ
		if ( !$class_name || !ClassUtil::validateClassName($class_name) ){
			throw new SQLBuilderConfigException( 'class_name', 'mandatory' );
		}

		// SQLӥΥ󥹥
		$builder = ClassUtil::newInstance( $class_name );

		// 󥹥󥹤Ibuilder󥿥եƤ뤫ǧ
		if ( !($builder instanceof ISQLBuilder) ){
			// 㳰
			throw new InterfaceImplementException( $class_name, "ISQLBuilder" );
		}

		log_info( "system",  "SQLӥ[$builder_name]ޤ", __FILE__, __LINE__ );

		// SQLӥ
		$builder->init( $config );

		log_info( "system",  "SQLӥ[$builder_name]ɤޤ", __FILE__, __LINE__ );

		// ɤSQLӥֵ
		return $builder;
	}

	/*
	 * ơ֥ǥ
	 */
	public static function createTableModel( $table_model_name )
	{
		log_info( "system",  "ơ֥ǥ[$table_model_name]ɤޤ", __FILE__, __LINE__ );

		// Config
		$config = ConfigLoader::loadConfig( $table_model_name, "table_model" );

		// ɬܹܤΥå
		if ( !$config->keyExists("class_name") ){
			throw new TableModelConfigException( $table_model_name, "[class_name] is mandatory" );
		}

		// 饹̾
		$class_name = $config->getString( "class_name" );

		// 饹̾γǧ
		if ( !$class_name || !ClassUtil::validateClassName($class_name) ){
			throw new TableModelConfigException( 'class_name', 'mandatory' );
		}

		// ơ֥ǥΥ󥹥
		$table_model = ClassUtil::newInstance( $class_name );

		// 󥹥󥹤ITableModel󥿥եƤ뤫ǧ
		if ( !($table_model instanceof ITableModel) ){
			// 㳰
			throw new InterfaceImplementException( $class_name, "ITableModel" );
		}

		// ǥID
		$table_model->setModelID( $table_model_name );

		log_info( "system",  "ơ֥ǥ[$table_model_name]ɤޤ", __FILE__, __LINE__ );

		// ɤơ֥ǥֵ
		return $table_model;
	}

	/*
	 * ޥ͡
	 */
	public static function createTaskManager( $task_manager_name )
	{
		log_info( "system",   "ޥ͡[$task_manager_name]ɤޤ", __FILE__, __LINE__ );

		// DispatcherConfig
		$config = ConfigLoader::loadConfig( $task_manager_name, "task_manager" );

		// 饹̾
		$class_name = $config->getString( "class_name" );

		// 饹̾γǧ
		if ( !$class_name || !ClassUtil::validateClassName($class_name) ){
			throw new TaskManagerConfigException( 'class_name', 'mandatory' );
		}

		// ޥ͡Υ󥹥
		$task_manager = ClassUtil::newInstance( $class_name );

		// 󥹥󥹤ITaskManager󥿥եƤ뤫ǧ
		if ( !($task_manager instanceof ITaskManager) ){
			// 㳰
			throw new InterfaceImplementException( $class_name, "ITaskManager" );
		}

		log_info( "system",   "ޥ͡[$task_manager_name]ޤ", __FILE__, __LINE__ );

		// ޥ͡
		$task_manager->init( $config );

		log_info( "system",   "ޥ͡[$task_manager_name]ɤޤ", __FILE__, __LINE__ );

		// ɤޥֵ͡
		return $task_manager;
	}

	/*
	 * ȥ󥹥եޤ
	 */
	public static function createTransformer( $transformer_name )
	{
		log_info( "system",  "ȥ󥹥ե[$transformer_name]ɤޤ", __FILE__, __LINE__ );

		// Config
		$config = ConfigLoader::loadConfig( $transformer_name, "transformer" );

		// 饹̾
		$class_name = $config->getString( "class_name" );

		// 饹̾γǧ
		if ( !$class_name || !ClassUtil::validateClassName($class_name) ){
			throw new TransformerConfigException( 'class_name', 'mandatory' );
		}

		// ȥ󥹥եޤΥ󥹥
		$transformer = ClassUtil::newInstance( $class_name );

		// 󥹥󥹤IValidator󥿥եƤ뤫ǧ
		if ( !($transformer instanceof ITransformer) ){
			// 㳰
			throw new InterfaceImplementException( $class_name, "ITransformer" );
		}

		log_info( "system",  "ȥ󥹥ե[$transformer_name]ޤ", __FILE__, __LINE__ );

		// ȥ󥹥եޤ
		$transformer->init( $config );

		log_info( "system",  "ȥ󥹥ե[$transformer_name]ɤޤ", __FILE__, __LINE__ );

		// ɤȥ󥹥եޤֵ
		return $transformer;
	}

	/*
	 * URLޥåѡ
	 */
	public static function createURLMapper( $url_mapper_name )
	{
		log_info( "system",  "URLޥåѡ[$url_mapper_name]ɤޤ", __FILE__, __LINE__ );

		// Config
		$config = ConfigLoader::loadConfig( $url_mapper_name, "url_mapper" );

		// ɬܹܤΥå
		if ( !$config->keyExists("class_name") ){
			throw new URLMapperConfigException( $url_mapper_name, "[class_name] is mandatory" );
		}

		// 饹̾
		$class_name = $config->getString( "class_name" );

		// 饹̾γǧ
		if ( !$class_name || !ClassUtil::validateClassName($class_name) ){
			throw new URLMApperConfigException( 'class_name', 'mandatory' );
		}

		// URLޥåѡΥ󥹥
		$url_mapper = ClassUtil::newInstance( $class_name );

		// 󥹥󥹤IValidator󥿥եƤ뤫ǧ
		if ( !($url_mapper instanceof IURLMapper) ){
			// 㳰
			throw new InterfaceImplementException( $class_name, "IURLMapper" );
		}

		log_info( "system",  "URLޥåѡ[$url_mapper_name]ޤ", __FILE__, __LINE__ );

		// URLޥåѡ
		$url_mapper->init( $config );

		log_info( "system",  "URLޥåѡ[$url_mapper_name]ɤޤ", __FILE__, __LINE__ );

		// ɤURLޥåѡֵ
		return $url_mapper;
	}

	/*
	 * Хǡ
	 */
	public static function createValidator( $validator_name )
	{
		Logger::writeln( LogLevel::INFO,  "Хǡ[$validator_name]ɤޤ", __FILE__, __LINE__ );

		// ValidatorConfig
		$validator_config = ConfigLoader::loadConfig( $validator_name, "validator" );

		// 饹̾
		$class_name = $validator_config->getString( "class_name" );

		// 饹̾γǧ
		if ( !$class_name || !ClassUtil::validateClassName($class_name) ){
			throw new ValidatorConfigException( 'class_name', 'mandatory' );
		}

		// ХǡΥ󥹥
		$validator = ClassUtil::newInstance( $class_name );

		// 󥹥󥹤IValidator󥿥եƤ뤫ǧ
		if ( !($validator instanceof IValidator) ){
			// 㳰
			throw new InterfaceImplementException( $class_name, "IValidator" );
		}

		Logger::writeln( LogLevel::INFO,  "Хǡ[$validator_name]ޤ", __FILE__, __LINE__ );

		// Хǡ
		$validator->initValidator( $validator_config );

		Logger::writeln( LogLevel::INFO,  "Хǡ[$validator_name]ɤޤ", __FILE__, __LINE__ );

		// ɤХǡֵ
		return $validator;
	}

	/*
	 * ꥯȤ
	 */
	public static function createRequest( $request_name )
	{
		log_info( "system",  "ꥯ[$request_name]ɤޤ", __FILE__, __LINE__ );

		// Config
		$config = ConfigLoader::loadConfig( $request_name, "request" );

		// 饹̾
		$class_name = $config->getString( "class_name" );

		// 饹̾γǧ
		if ( !$class_name || !ClassUtil::validateClassName($class_name) ){
			throw new RequestConfigException( 'class_name', 'mandatory' );
		}

		// ꥯȤΥ󥹥
		$request = ClassUtil::newInstance( $class_name );

		// 󥹥󥹤IRequest󥿥եƤ뤫ǧ
		if ( !($request instanceof IRequest) ){
			// 㳰
			throw new InterfaceImplementException( $class_name, "IRequest" );
		}

		log_info( "system",  "ꥯ[$request_name]ɤޤ", __FILE__, __LINE__ );

		// ɤꥯȤֵ
		return $request;
	}

	/*
	 * 
	 */
	public static function createTask( $task_name )
	{
		log_info( "system",  "[$task_name]ɤޤ", __FILE__, __LINE__ );

		// ValidatorConfig
		$task_config = ConfigLoader::loadConfig( $task_name, "task" );

		// 饹̾
		$class_name = $task_config->getString( "class_name" );

		// 饹̾γǧ
		if ( !$class_name || !ClassUtil::validateClassName($class_name) ){
			throw new TaskConfigException( 'class_name', 'mandatory' );
		}

		// Υ󥹥
		$task = ClassUtil::newInstance( $class_name );

		// 󥹥󥹤ITask󥿥եƤ뤫ǧ
		if ( !($task instanceof ITask) ){
			// 㳰
			throw new InterfaceImplementException( $class_name, "ITask" );
		}

		log_info( "system",  "[$task_name]ޤ", __FILE__, __LINE__ );

		// 
		$task->init( $task_config );

		log_info( "system",  "[$task_name]ɤޤ", __FILE__, __LINE__ );

		// ɤֵ
		return $task;
	}

}
