<?php
/**
* ե졼ѥ饹
*
* PHP version 5
*
* @package    core
* @author     stk2k <stk2k@sazysoft.com>
* @copyright  2008 stk2k, sazysoft
*/

class FrameworkClassLoader
{
	static $class_paths;

	/*
	 * 饹ѥν
	 */
	public static function initClassPath()
	{
		self::$class_paths = array(

		// base classes
				'Boolean'					=> 'base',
				'CharcoalException'			=> 'base',
				'ConfigException'			=> 'base',
				'Integer'					=> 'base',
				'Object'					=> 'base',
				'Stack'						=> 'base',
				'String'					=> 'base',

		// debug classes
				'BackTrace'					=> 'debug',
				'BackTraceElement'			=> 'debug',
				'MethodSpec'				=> 'debug',
				'FunctionSpec'				=> 'debug',
				'CallHistory'				=> 'debug',
				'PhpSourceElement'			=> 'debug',
				'PhpSourceInfo'				=> 'debug',
				'PhpSourceParser'			=> 'debug',
				'PhpSourceRenderer'			=> 'debug',

		// core classes
				'Annotation'				=> 'core',
				'AnnotationUtil'			=> 'core',
				'Benchmark'					=> 'core',
				'CacheFile'					=> 'core',
				'CacheFileHeader'			=> 'core',
				'ClassLoader'				=> 'core',
				'ClassUtil'					=> 'core',
				'CommandLineUtil'			=> 'core',
				'Config'					=> 'core',
				'ConfigLoader'				=> 'core',
				'ConfigUtil'				=> 'core',
				'DB'						=> 'core',
				'DBRelation'				=> 'core',
				'DIContainer'				=> 'core',
				'DTO'						=> 'core',
				'EncodingConverter'			=> 'core',
				'EventQueue'				=> 'core',
				'EventQueueEntry'			=> 'core',
				'ExceptionStack'			=> 'core',
				'ExceptionStackEntry'		=> 'core',
				'Factory'					=> 'core',
				'Framework'					=> 'core',
				'Logger'					=> 'core',
				'MemoryUsage'				=> 'core',
				'ProcedureContext'			=> 'core',
				'Profile'					=> 'core',
				'ResourceCache'				=> 'core',
				'ResourceLocator'			=> 'core',
				'Response'					=> 'core',
				'Session'					=> 'core',
				'SQLCriteria'				=> 'core',
				'System'					=> 'core',

		// interface classes
				'IClassLoader'				=> 'interfaces',
				'IComponent'				=> 'interfaces',
				'IConfigSpec'				=> 'interfaces',
				'IConfigProvider'			=> 'interfaces',
				'IDataSource'				=> 'interfaces',
				'IEvent'					=> 'interfaces',
				'IFilter'					=> 'interfaces',
				'IFlowEngine'				=> 'interfaces',
				'IForm'						=> 'interfaces',
				'IFormModel'				=> 'interfaces',
				'ILayoutManager'			=> 'interfaces',
				'ILogger'					=> 'interfaces',
				'IModel'					=> 'interfaces',
				'IModule'					=> 'interfaces',
				'IObject'					=> 'interfaces',
				'IProcedure'				=> 'interfaces',
				'IRenderer'					=> 'interfaces',
				'IRequest'					=> 'interfaces',
				'IResource'					=> 'interfaces',
				'ISessionHandler'			=> 'interfaces',
				'ISQLBuilder'				=> 'interfaces',
				'ITableModel'				=> 'interfaces',
				'ITask'						=> 'interfaces',
				'ITaskManager'				=> 'interfaces',
				'ITransformer'				=> 'interfaces',
				'IURLMapper'				=> 'interfaces',
				'IValidator'				=> 'interfaces',

		// HTML objects
				'HTMLChoiceGroupObject'		=> 'html_objects',
				'HTMLContainerObject'		=> 'html_objects',
				'HTMLFormFactory'			=> 'html_objects',
				'HTMLFormObject'			=> 'html_objects',
				'HTMLInputObject'			=> 'html_objects',
				'HTMLLeafObject'			=> 'html_objects',
				'HTMLListObject'			=> 'html_objects',
				'HTMLObject'				=> 'html_objects',
				'HTMLPanelObject'			=> 'html_objects',
				'HTMLSelectObject'			=> 'html_objects',
				'HTMLTextObject'			=> 'html_objects',
				'HTMLTextAreaObject'		=> 'html_objects',

		// event classes
				'DefaultEvent'				=> 'events',

		// logger classes
				'FileLogger'				=> 'loggers',
				'ScreenLogger'				=> 'loggers',
				'PopupScreenLogger'				=> 'loggers',

		// constant classes
				'ComponentScope'			=> 'constants',

		// exception classes
				'AnnotaionException'				=> 'exceptions',
				'ArrayFormatException'				=> 'exceptions',
				'BooleanFormatException'			=> 'exceptions',
				'ClassLoaderConfigException'		=> 'exceptions',
				'ClassNotFoundException'			=> 'exceptions',
				'ComponentConfigException'			=> 'exceptions',
				'ComponentNotRegisteredException'	=> 'exceptions',
				'ConfigFileNotFoundException'		=> 'exceptions',
				'DBException'						=> 'exceptions',
				'EmptyStackException'				=> 'exceptions',
				'EncodingConverterException'		=> 'exceptions',
				'EventConfigException'				=> 'exceptions',
				'FilterConfigException'				=> 'exceptions',
				'HttpException'						=> 'exceptions',
				'InterfaceImplementException'		=> 'exceptions',
				'InternalException'					=> 'exceptions',
				'IntegerFormatException'			=> 'exceptions',
				'InvalidClassNameException'			=> 'exceptions',
				'InvalidDBRelationException'		=> 'exceptions',
				'LayoutException'					=> 'exceptions',
				'LayoutManagerConfigException'		=> 'exceptions',
				'LoggerConfigException'				=> 'exceptions',
				'ModuleConfigException'				=> 'exceptions',
				'ModuleGraphConfigException'		=> 'exceptions',
				'ModuleGraphTransitionException'	=> 'exceptions',
				'ModuleGraphNodeException'			=> 'exceptions',
				'NonArrayException'					=> 'exceptions',
				'NonObjectException'				=> 'exceptions',
				'NullPointerException'				=> 'exceptions',
				'ParameterException'				=> 'exceptions',
				'PhpSourceParserException'			=> 'exceptions',
				'ProcedureConfigException'			=> 'exceptions',
				'ProfileException'					=> 'exceptions',
				'RendererException'					=> 'exceptions',
				'RendererConfigException'			=> 'exceptions',
				'StringFormatException'				=> 'exceptions',
				'TableModelException'				=> 'exceptions',
				'TableModelConfigException'			=> 'exceptions',
				'TaskConfigException'				=> 'exceptions',
				'TemplateFileNotFoundException'		=> 'exceptions',
				'UnexpectedRunModeException'		=> 'exceptions',
				'URLMapperConfigException'			=> 'exceptions',


		// config provider classes
				'IniConfigProvider'					=> 'config_providers',
				'PhpConfigProvider'					=> 'config_providers',
				'SpycConfigProvider'				=> 'config_providers',
				'CachedSpycConfigProvider'			=> 'config_providers',

		// layout manager classes
				'DefaultLayoutManager'				=> 'layout_managers',

		// task manager classes
				'DefaultTaskManager'				=> 'task_managers',

		// task classes
				'ModuleDelegateTask'				=> 'tasks',

		// table model classes
				'DefaultTableModel'					=> 'table_models',

		// form model classes
				'DefaultFormModel'					=> 'form_models',

		// data source classes
				'PearDbDataSource'					=> 'data_sources',

		// request classes
				'ShellRequest'						=> 'requests',
				'HttpRequest'						=> 'requests',

		// session hanlder classes
				'DefaultSessionHandler'				=> 'session_handlers',

		// SQL Builder classes
				'DefaultSQLBuilder'					=> 'sql_builders',
				'MySQL_SQLBuilder'					=> 'sql_builders',
				'PostgreSQL_SQLBuilder'				=> 'sql_builders',

		// form classes
				'SimpleForm'						=> 'forms',

		// procedure classes
				'HttpProcedure'						=> 'procedures',
				'ShellProcedure'					=> 'procedures',

		// renderer classes
				'SmartyRenderer'					=> 'renderers',
				'PHPTALRenderer'					=> 'renderers',

		// filter classes
				'FormOutputFilter'					=> 'filters',
				'FormReadOnlyOutputFilter'			=> 'filters',
				'EncodingInputFilter'				=> 'filters',
				'EncodingOutputFilter'				=> 'filters',
				'CharcoalPagerOutputFilter'			=> 'filters',

		// component classes
				'Linker'							=> 'components/charcoal',
				'BreadcrumbList'					=> 'components/charcoal',
				'CharcoalPager'						=> 'components/charcoal',
				'Calendar'							=> 'components/charcoal',
				'CharcoalMail'						=> 'components/mail/CharcoalMail.class.php',

		// transformer classes
				'SimpleTransformer'					=> 'transformers',

		// URL Mapper classes
				'SimpleURLMapper'					=> 'url_mappers',

		);

		return self::$class_paths;
	}

	/*
	 * 饹
	 */
	public static function loadClass( $class_name )
	{
		$class_paths = self::$class_paths;
		if ( !$class_paths ){
			// 饹ѥν
			$class_paths = self::initClassPath();
		}

		// ե졼Υ饹ǤϤʤFALSEֵ
		if ( !isset($class_paths[ $class_name ]) ){
			return FALSE;
		}

		// 饹̾饯饹ѥ
		$class_path = $class_paths[ $class_name ] . "/$class_name.class.php";

		// ɤ߹
/*
		require_once( 'ClassUtil.class.php' );
		$loaded = ClassUtil::loadClass( $class_path, $class_name );
*/
		require( $class_path );

		return $loaded;
	}
}
