<?php
/**
* Ķ̤򰷤饹
*
* PHP version 5
*
* @package    core
* @author     stk2k <stk2k@sazysoft.com>
* @copyright  2008 stk2k, sazysoft
*/

class Profile
{
	static $config_file;
	static $config;
	static $profile_name;

	/*
	 * ץե̾
	 */
	public static function getProfileName()
	{
		return self::$profile_name;
	}

	/*
	 * ե̾
	 */
	public static function getConfigFile()
	{
		return self::$config_file;
	}

	/*
	 * ХͤȤƼ
	 */
	public static function getInteger( $key, $defaultValue = NULL )
	{
		if ( !isset(self::$config[ $key ]) ){
			return i($defaultValue);
		}
		$value = i(self::$config[ $key ]);
		return $value;
	}

	/*
	 * ХͤʸȤƼ
	 */
	public static function getString( $key, $defaultValue = '' )
	{
		if ( !isset(self::$config[ $key ]) ){
			return s($defaultValue);
		}
		$value = s(self::$config[ $key ]);
		return $value;
	}

	/*
	 * Хͤ֡ͤȤƼ
	 */
	public static function getBoolean( $key, $defaultValue = FALSE  )
	{
		if ( !isset(self::$config[ $key ]) ){
			return $defaultValue;
		}
		$value = self::$config[ $key ];
		return $value;
	}

	/*
	 * ХͤȤƼ
	 */
	public static function getArray( $key, $defaultValue = array() )
	{
		if ( !isset(self::$config[ $key ]) ){
			return $defaultValue;
		}
		$value = self::$config[ $key ];

		// ޤʬ䤷֤
		return explode( "," , $value );
	}

	/*
	 * Хեɤ߹
	 */
	public static function load( $profile_name )
	{
		// եξ
		$config_file = ResourceLocator::getWebAppPath( 'config/profiles', "$profile_name.global.ini" );

		// sectionʤiniեѡ
		$config = parse_ini_file($config_file,FALSE);

		// ץե̾
		if ( $config['PROFILE_NAME'] ){
			$profile_name = $config['PROFILE_NAME'];
		}

		// ¸
		self::$config = $config;
		self::$config_file = basename($config_file);
		self::$profile_name = $profile_name;
	}
}
