<?php
/**
* Хåȥ졼饹
*
* PHP version 5
*
* @package    debug
* @author     stk2k <stk2k@sazysoft.com>
* @copyright  2008 stk2k, sazysoft
*/

class BackTrace extends Object
{
	private $_backtraces;

	/*
	 *	󥹥ȥ饯
	 */
	public function __construct()
	{
		parent::__construct();

		$this->_backtraces = debug_backtrace();

		array_shift($this->_backtraces);
	}

	/*
	 *	ܺپ
	 */
	public function build()
	{
		$details = array();

		$backtraces = $this->_backtraces;
		$level = 0;
		foreach( $backtraces as $trace )
		{
			$class     = isset($trace[ 'class' ]) ? $trace[ 'class' ] : NULL;
			$function  = $trace[ 'function' ];
			$line      = $trace[ 'line' ];
			$file      = $trace[ 'file' ];
			$args      = $trace[ 'args' ];

			// ᥽åɻ
			$spec      = $class ? new MethodSpec( $class, $function ) : new FunctionSpec( $function );
			// 
			$source    = new PhpSourceInfo( $file, $line );
			// ƤӽФ
			$history   = new CallHistory( $args );

			// Ǥɲ
			$details[$level++] = new BackTraceElement( $spec, $source, $history );
		}

		return $details;
	}

}
