<?php
/**
* ؿƤӽФ򥯥饹
*
* PHP version 5
*
* @package    debug
* @author     stk2k <stk2k@sazysoft.com>
* @copyright  2008 stk2k, sazysoft
*/

class FunctionSpec extends Object
{
	private $_function;
	private $_args;
	private $_args_cnt;

	/*
	 *	󥹥ȥ饯
	 */
	public function __construct( $function )
	{
		parent::__construct();

		$ref = new ReflectionFunction($function);
		$this->_function = $function;
		$this->_args     = $ref->getParameters();
		$this->_args_cnt = $ref->getNumberOfParameters();
	}

	/*
	 *	ʸ
	 */
	public function toString()
	{
		$function = $this->_function;
		$args     = $this->_args;
		$args_cnt = $this->_args_cnt;

		$str = $function->getName() . '(' . PHP_EOL;
		foreach( $args as $p ){
			$class           = $p->getClass();
			$param_name      = $p->getName();
			$is_array        = $p->isArray();
			$reference       = $p->isPassedByReference();
			$default_exsits  = $p->isDefaultValueAvailable();
			$default_value   = $default_exsits ? $p->getDefaultValue() : '';

			$str .= str_repeat('&nbsp;',3);
			$str .= ($class ? $class->getName() : NULL);
			$str .= ($is_array ? '[] ' : ' ') . ($reference ? '&amp;' : '');
			$str .= $param_name;
			if ( $default_exsits ){
				$str .= ' = ' . ($default_value ? $default_value : 'NULL');
			}
			if ( --$args_cnt > 0 ){
				$str .= ',';
			}
			$str .= PHP_EOL;
		}
		$str .= ')' . PHP_EOL;

		return $str;
	}
}
