<?php
/**
* PHP󥯥饹
*
* PHP version 5
*
* @package    debug
* @author     stk2k <stk2k@sazysoft.com>
* @copyright  2008 stk2k, sazysoft
*/

class PhpSourceInfo extends Object
{
	private $_file;
	private $_line;

	/*
	 *	󥹥ȥ饯
	 */
	public function __construct( $file, $line )
	{
		parent::__construct();

		$this->_file = $file;
		$this->_line = $line;
	}


	/*
	 *	ե̾
	 */
	public function getFile()
	{
		return $this->_file;
	}

	/*
	 *	ֹ
	 */
	public function getLine()
	{
		return $this->_line;
	}

	/*
	 *	ʸ
	 */
	public function toString()
	{
		$keyword_file = ResourceLocator::getSystemPath( 'data', 'php.kwd' );

		$file = $this->_file;
		$line = $this->_line;

		$p = new PhpSourceParser();
		$p->init( $keyword_file );
		$tokens = $p->parse( $this->_file );
		$html = PhpSourceRenderer::render( $tokens, '%4d:', NULL, $line - 5, $line + 5 );

		return $html;
	}
}
