<?php
/**
* HTML꡼ե֥ȥ饹
*
* PHP version 5
*
* @package    html_objects
* @author     stk2k <stk2k@sazysoft.com>
* @copyright  2008 stk2k, sazysoft
*/

abstract class HTMLLeafObject extends HTMLObject
{
	/*
	 *	󥹥ȥ饯
	 */
	public function __construct( $tag, $attributes )
	{
		parent::__construct( $tag, $attributes );
	}

	/*
	 *	HTML
	 */
	public function toHTML()
	{
		$conv = EncodingConverter::fromString( 'PHP_TO_HTML' );

		$tag = $this->_tag;
		$html = '<'. $tag;

		// °
		$attributes = $this->_attributes;
		if ( $attributes ){
			foreach( $attributes as $name => $value ){
				if ( $name && $value !== NULL ){
					$value = $conv->convertEncoding( $value );
					$html .= ' ' . $name . '="' . $value . '"';
				}
			}
		}

		$html .= ' />';

		return $html;
	}
}
