<?php
/**
* HTML饯饹
*
* PHP version 5
*
* @package    html_objects
* @author     stk2k <stk2k@sazysoft.com>
* @copyright  2008 stk2k, sazysoft
*/

class HTMLTextObject  extends HTMLLeafObject
{
	private $_text;

	/*
	 *	󥹥ȥ饯
	 */
	public function __construct( $text, $attributes = NULL  )
	{
		parent::__construct( 'span', $attributes );

		$this->_text = $text;
	}

	/*
	 *	HTML
	 */
	public function toHTML()
	{
		$conv = EncodingConverter::fromString( 'PHP_TO_HTML' );
		$text = $conv->convertEncoding( $this->_text );
		return parent::startTag() . $text . parent::endTag();
	}
}
