<?php
/**
* ñʥ쥤ȥޥ͡륯饹
*
* PHP version 5
*
* @package    layout_managers
* @author     stk2k <stk2k@sazysoft.com>
* @copyright  2008 stk2k, sazysoft
*/

class DefaultLayoutManager extends Object implements ILayoutManager
{
	private $_response;
	private $_context;

	/**
	 *   󥹥ȥ饯
	 */
	public function __construct()
	{
		parent::__construct();

		$this->_tasks = NULL;
	}

	/**
	 *   쥤ȥޥ̾͡
	 */
	public function getLayoutManagerName()
	{
		return "Default Layout Manager";
	}

	/**
	 *   쥤ȥޥ͡
	 */
	public function init( Config $config )
	{
		$this->_response     = $config->getAssoc( "response" );
		$this->_context      = $config->getAssoc( "context" );
	}

	/**
	 *   쥤Ȥ
	 */
	public function layout( $layout_name, ITaskManager $task_manager, ProcedureContext $context, Response $response )
	{
		log_info( "system",  "쥤Ȥ򳫻Ϥޤ", __FILE__, __LINE__ );

		// ƥȡ󥸥
		$context_injections = $this->_context;
		if ( $context_injections && is_array($context_injections) ){
			foreach( $context_injections as $key => $value ){
				$context->set( $key, $value );
			}
		}

		// 쥹ݥ󥹡󥸥
		$response_injections = $this->_response;

		if ( $response_injections && is_array($response_injections) ){
			foreach( $response_injections as $key => $value ){
				// value饹ޤ
				$pos = strpos($value,'.');
				$schema   = substr($value,0,$pos);
				$value    = substr($value,$pos+1);
				// ޤȤ˥쥹ݥͤ
				$response_value = NULL;
				switch( $schema ){
				case 'Task':
					{
						// ޤθϡ֥̾.ץѥƥ
						$pos = strpos($value,'.');
						$task_name  = substr($value,0,$pos);
						$property   = substr($value,$pos+1);
						// 
						$task = $task_manager->getTask($task_name);
						// ͤ
						$response_value = property_exists($task,$property) ? $task->$property : '';
					}
					break;
				case 'Profile':
					{
						// ޤθϡ̾
						$const_name  = $value;
						// ͤ
						$response_value = Profile::getString( $const_name );
					}
					break;
				case 'String':
					{
						// ޤθϡʸ
						$string  = $value;
						// ͤ
						$response_value = $string;
					}
					break;
				default:
					{
						throw new LayoutException( $layout_name, "Illegal schema name:$schema" );
					}
					break;
				}
				// 쥹ݥͤ򥻥å
				$response->set( $key, $response_value );
			}
		}

		log_info( "system",  "쥤Ȥλޤ", __FILE__, __LINE__ );
	}
}
