<?php
/**
* HTTPץ
*
* PHP version 5
*
* @package    procedures
* @author     stk2k <stk2k@sazysoft.com>
* @copyright  2008 stk2k, sazysoft
*/
class HttpProcedure extends Object implements IProcedure
{
	var $_events;
	var $_input_filters;
	var $_output_filters;
	var $_renderer;
	var $_task_manager;
	var $_layout_manager;

	/*
	 * 󥹥ȥ饯
	 */
	public function __construct()
	{
		parent::__construct();
	}

	/*
	 * ץ̾
	 */
	public function getProcedureName()
	{
		return "Default Procedure";
	}

	/*
	 * ץ
	 */
	public function init( Config $config )
	{
		$this->_events              = $config->getAssoc( "events" );
		$this->_output_filters      = $config->getArray( "output_filters" );
		$this->_input_filters       = $config->getArray( "input_filters" );
		$this->_renderer            = $config->getString( "renderer" );
		$this->_task_manager        = $config->getString( "task_manager" );
		$this->_layout_manager      = $config->getString( "layout_manager" );
	}

	/*
	 * ץ¹Ԥ
	 */
	public function execute( IRequest $request, ProcedureContext $context, Response $response )
	{
		$proc_name = $context->getProcedureName();

		log_info( "system",  "ץ[$proc_name]¹Ԥޤ", __FILE__, __LINE__ );

		//=======================================
		// ޥ͡κ
		//

		// ޥ͡
		$task_manager_name = $this->_task_manager;
		$task_manager = Factory::createTaskManager( $task_manager_name );

		//=======================================
		// ϥե륿μ¹
		//

		if ( $this->_input_filters ) {
			log_info( "system",  "ϥե륿¹Ԥޤ", __FILE__, __LINE__ );

print "input_filters:" . gettype($this->_input_filters) . "<BR>";
print "input_filters:" . get_class($this->_input_filters) . "<BR>";
print "input_filters:" . count($this->_input_filters) . "<BR>";
print "input_filters:" . implode(':',$this->_input_filters) . "<BR>";

			foreach( $this->_input_filters as $filter_name ) {
				// ե륿
				$filter = Factory::createFilter( $filter_name );
				// ե륿μ¹
				$filter->filter( $request, $context, $response );
			}
	
			log_info( "system",  "ϥե륿¹Ԥޤ", __FILE__, __LINE__ );
		}

		//=======================================
		// ٥ȥǥѥå
		//

		$task_manager->dispatchEvents( $request, $this->_events );

		//=======================================
		// ٥Ƚ
		//

		$task_manager->processEvents( $context );

		//=======================================
		// ϥɥ
		//

		// ϥɥ
		$screen_name = $task_manager->handleTasks( $response );

		//=======================================
		// 쥤
		//

		// 쥤ȥޥ͡κ
		$layout_manager_name = $this->_layout_manager;
		if ( $layout_manager_name && !$layout_manager_name->isEmpty() ){

			// ꤵƤ
			$layout_manager = Factory::createLayoutManager( $layout_manager_name );
			// 쥤ȼ¹
			$layout_manager->layout( $screen_name, $task_manager, $context, $response );
		}

		//=======================================
		// ϥե륿μ¹
		//
		if ( $this->_output_filters ) {
			log_info( "system",  "ϥե륿¹Ԥޤ", __FILE__, __LINE__ );

			foreach( $this->_output_filters as $filter_name ) {
				// ե륿
				$filter = Factory::createFilter( $filter_name );
				// ե륿μ¹
				$filter->filter( $request, $context, $response );
			}

			log_info( "system",  "ϥե륿¹Ԥޤ", __FILE__, __LINE__ );
		}

		//=======================================
		// μ¹
		//
		if ( $this->_renderer && strlen($this->_renderer) > 0 ) {
			log_info( "system",  "¹Ԥޤ", __FILE__, __LINE__ );

			$renderer = Factory::createRenderer( $this->_renderer );
			if ( $renderer ) {
				$renderer->render( $context, $response );
			}
			log_info( "system",  "¹Ԥޤ", __FILE__, __LINE__ );

		}

		log_info( "system",  "ץ[$proc_name]¹Ԥޤ", __FILE__, __LINE__ );
	}
}
