<?php
/**
* ñʥޥ͡륯饹
*
* PHP version 5
*
* @package    task_managers
* @author     stk2k <stk2k@sazysoft.com>
* @copyright  2008 stk2k, sazysoft
*/

class DefaultTaskManager extends Object implements ITaskManager
{
	private $_tasks;
	private $_queue;

	/*
	 * 󥹥ȥ饯
	 */
	public function __construct()
	{
		parent::__construct();

		$this->_tasks  = NULL;
		$this->_queue  = new EventQueue();
	}

	/*
	 * ޥ̾͡
	 */
	public function getTaskManagerName()
	{
		return "Default Task Manager";
	}

	/*
	 * ޥ͡
	 */
	public function init( Config $config )
	{
	}

	/*
	 * 
	 */
	public function getTask( $task_name )
	{
		// Ѥߤʤ餽֤
		if ( isset($this->_tasks[$task_name]) ){
			return $this->_tasks[$task_name];
		}
		// 
		$task = Factory::createTask( $task_name );

		// ¸
		$this->_tasks[$task_name] = $task;

		return $task;
	}

	/*
	 * ٥ȥǥѥåԤ
	 *
	 */
	public function dispatchEvents( IRequest $request, $events )
	{
		log_info( "system",  "٥ȥǥѥå򳫻Ϥޤ", __FILE__, __LINE__ );

		$queue = $this->_queue;

		if ( $events && is_array($events) ){
			foreach( $events as $task_name => $event_name ){
				// μ
				$task = $this->getTask( $task_name );
				// ٥Ȥκ
				$event = Factory::createEvent( $event_name, $request );
				// ٥Ȥ򥤥٥ȥ塼ɲ
				$queue->enqueue( new EventQueueEntry($task,$event) );
			}
		}

		log_info( "system",  "٥ȥǥѥåλޤ", __FILE__, __LINE__ );
	}

	/**
	 *   ٥ȽԤ
	 *
	 */
	public function processEvents( ProcedureContext $context )
	{
		$queue = $this->_queue;

		// ̵¥롼פ򤱤뤿ᡢMAX_EVENT_COUNTʾϽʤʥǥեȤ100ޤǡ
		$max_event_count = Profile::getInteger( 'MAX_EVENT_COUNT', 100 )->getValue();

		$event_count = 0;
		while( !$queue->isEmpty() ){
			// ٥Ȥ
			$entry = $queue->dequeue();
			// åȥ
			$task = $entry->getTarget();
			// ٥Ȥ
			$event = $entry->getEvent();
			// ٥Ȥ
			$result = $task->processEvent( $event, $context );
			// ̤٥Ȥä饭塼˺ɲ
			if ( $result instanceof IEvent ){
				$queue->enqueue( $result );
			}
			// ٥ȥȤΥ󥯥
			$event_count ++;
			// ٥ȥȤĶƤ˥󥰤Фƽλ
			if ( $event_count > $max_event_count ){
				log_warning( 'system', "٥Ƚ[$max_event_count]Ķᡢ٥ȽǤޤ", __FILLE__, __LINE__ );
				break;
			}
		}
	}

	/**
	 *   ϥɥ󥰤
	 */
	public function handleTasks()
	{
	}
}
