<?php
/**
* ñURLޥåѡ륯饹
*
* PHP version 5
*
* @package    url_mappers
* @author     stk2k <stk2k@sazysoft.com>
* @copyright  2008 stk2k, sazysoft
*/
class SimpleURLMapper implements IURLMapper
{
	var $_mapping_rules;

	/*
	 * 󥹥ȥ饯
	 */
	public function __construct()
	{
		$this->_mapping_rules = null;
	}

	/**
	 * URLޥåѡ̾
	 */
	public function getURLMapperName()
	{
		return "Simple URL Mapper";
	}

	/**
	 * URLޥåѡ
	 */
	public function init( Config $config )
	{
		$this->_mapping_rules = $config->getArray( 'mapping_rules' );

	}

	/**
	 * URLޥåԥ󥰤
	 */
	public function mapURL( Request $request )
	{
		// ѥ
		$request_uri = $_SERVER["REQUEST_URI"];
		$script_name = $_SERVER["SCRIPT_NAME"];
		$dir_name    = dirname($script_name);

		$pos = strpos( $request_uri, $dir_name );
		$url = substr( $request_uri, $pos + strlen($dir_name) );

		log_info( 'url_mapper', "mapping url:$url", __FILE__, __LINE__ );
		log_info( 'system', "SimpleURLMapperˤޥåԥ󥰤ԤޤURL=[$url]", __FILE__, __LINE__ );

		if ( $this->_mapping_rules ){
			foreach( $this->_mapping_rules as $proc => $rule ){
				$a = self::_match( $rule, $url );
				// ˥ޥå
				if ( $a !== NULL ){
					$request->setArray( $a );
					$request->set( PROC_KEYWORD, $proc );
					log_info( 'system', "URLޥåԥ󥰥롼˥ޥåޤ롼=[$rule] ץ=[$proc]", __FILE__, __LINE__ );
					return;
				}
			}
		}
		else{
			// mapping_rulesꤵƤʤ
			throw new URLMapperConfigException( $this->getURLMapperName(), '[mapping_rules] is not defined.' );
		}
	}

	/**
	 * URLѥ˹פ뤫
	 */
	private static function _match( $rule, $url )
	{
		$url_dir_array = explode( '/', $url );
		$rule_dir_array = explode( '/', $rule );

		$a = array();

		foreach( $rule_dir_array as $rule_dir ){
			$url_dir = array_shift( $url_dir_array );
			if ( strpos($rule_dir,':') === 0 ){
				// ǻϤޤ볬ؤѿ̾
				$key = substr($rule_dir,1);
				$a[ $key] = $url_dir;
			}
			else if ( $rule_dir !== $url_dir ){
				// ޥåʤä
				log_info( 'url_mapper', "[$rule] did not matched to [$url]", __FILE__, __LINE__ );
				return NULL;
			}
		}

		log_info( 'url_mapper',"[$rule] matched to [$url]", __FILE__, __LINE__ );
		log_info( 'system', "URLޥåԥ󥰥롼˥ޥåޤ롼=[$rule]", __FILE__, __LINE__ );

		return $a;
	}

}
