<?php
class MyModule extends Object implements IModule
{
	/*
	 *    󥹥ȥ饯
	 */
	public function __construct()
	{
		parent::__construct();
	}

	/*
	 * ⥸塼̾
	 */
	public function getModuleName()
	{
		return "My module";
	}

	/*
	 * ⥸塼
	 */
	public function init( Config $module_config )
	{
	}

	/*
	 * ⥸塼ν¹Ԥ
	 */
	public function execute( $action, IEvent $event, ProcedureContext $context )
	{
		// ǡեΥѥ
		$data_file = $context->getWebAppPath( 'data', 'data.txt' );
		
		// ǡեɤ߹
		$data_list = array();
		if ( is_file($data_file) ){
			// եƤ
			$fp = fopen( $data_file, "r" );
			while ( $line = fgets($fp) ) {
				$data = explode( ',', $line );
				if ( count($data) >= 2 ){
					$id = $data[0];
					$name = $data[1];
					$data_list[$id] = $name;
				}
			}
			fclose($fp);
		}

		$modified = FALSE;

		switch ( $action ){
		case 'list':
			{
				return $data_list;
			}
			break;
		case 'add':
			{
				// 󥹥եɤ߹
				$seq_file = $context->getWebAppPath( 'data', 'seq.txt' );
				if ( is_file($seq_file) ){
					// եƤ
					$fp = fopen( $seq_file, "r" );
					$line = fgets($fp);
					fclose($fp);
					$seq = intval($line);
				}
				else{
					$seq = 0;
				}

				$name = $event->get('name');
				$id = ++ $seq;
				$data_list[$id] = $name;

				$modified = TRUE;

				// 󥹥ե¸
				$fp = fopen($seq_file, 'w');
				fwrite( $fp, $seq );
				fclose($fp);
			}
			break;
		case 'delete':
			{
				$id = $event->get('id');
				unset( $data_list[$id] );

				$modified = TRUE;
			}
			break;
		}

		// ǡե¸
		if ( $modified ){
			$fp = fopen($data_file, 'w');
			foreach( $data_list as $id => $name ){
				$line = "$id,$name\n";
				fwrite( $fp, $line );
			}
			fclose($fp);
		}
	}
}
