<?php
/**
* ǡž饹
*
* PHP version 5
*
* @package	core
* @author	 stk2k <stk2k@sazysoft.com>
* @copyright  2008 stk2k, sazysoft
*/

class DTO extends Object implements ArrayAccess
{
	/*
	 *	󥹥ȥ饯
	 */
	public function __construct( $array = NULL )
	{
		parent::__construct();

		if ( $array ){
			foreach( $array as $key => $value ){
				$this->$key = $value;
			}
		}
	}

	/*
	 * 󥳡ǥѴ
	 */
	public function convertEncoding( String $converter_str )
	{
		$conv = EncodingConverter::fromString($converter_str);

		foreach( $this->getPropertyList()  as $key => $value ){

			if ( is_string($value) ){
				$value = $conv->convertEncoding( $value );
				$this->setProperty( s($key), $value );
			}
		}
	}

	/*
	 *	ArrayAccess󥿥ե:offsetGetμ
	 */
	public function offsetGet($offset)
	{
		if ( $offset instanceof String ){
			$offset = "$offset";
		}
		return property_exists( $this, $offset ) ? $this->$offset : NULL;
	}

	/*
	 *	ArrayAccess󥿥ե:offsetSetμ
	 */
	public function offsetSet($offset, $value)
	{
		if ( $offset instanceof String ){
			$offset = "$offset";
		}
		if ( property_exists( $this, $offset ) ){
			$this->$offset = $value;
		}
	}

	/*
	 *	ArrayAccess󥿥ե:offsetExistsμ
	 */
	public function offsetExists($offset)
	{
		if ( $offset instanceof String ){
			$offset = "$offset";
		}
		return property_exists( $this, $offset );
	}

	/*
	 *	ArrayAccess󥿥ե:offsetUnsetμ
	 */
	public function offsetUnset($offset)
	{
		if ( $offset instanceof String ){
			$offset = "$offset";
		}
		if ( property_exists( $this, $offset ) ){
			unset($this->$offset);
		}
	}

	/*
	 * ʸ
	 */
	public function __toString()
	{
		$body = '';
		foreach( get_object_vars($this) as $key => $value ){
			$body .= " [$key]$value";
		}
		return "[DTO:$body]";
	}

	/*
	 * 
	 */
	public function dump( $converter_str = NULL )
	{
		$conv = $converter_str ? EncodingConverter::fromString($converter_str) : NULL;
		$id = $this->hashCode();

		print "---------[ DTO@$id ]---------<BR>";
		foreach( $this->getValue() as $key => $value ){
			if ( $conv && is_string($value) ){
				$value = $conv->convertEncoding( $value );
			}
			if ( is_array($value) ){
				$value = print_r($value,TRUE);
			}
			print "[$key]=$value<BR>";
		}
		print "-----------------------------<BR>";
	}

}

return __FILE__;