/*
 * CKEditor - RichText Editor Plugin
 * Original Written By Jeff Whitfield - April 30, 2007
 * Modify By yama - January 10, 2010
 *
 * Version 3.1
 * CKeditor v3.1
 *
 * Events: OnRichTextEditorInit, OnRichTextEditorRegister, OnInterfaceSettingsRender
 *
 */

// Set the name of the plugin folder
$pluginfolder = "ckeditor";

global $_lang;
include_once MODX_BASE_PATH .'assets/plugins/'.$pluginfolder.'/ckeditor.lang.php';
include_once MODX_BASE_PATH .'assets/plugins/'.$pluginfolder.'/ckeditor.functions.php';

// Set path and base setting variables
if(!isset($ckPath)) { 
	global $ckPath;
	$ckPath = MODX_BASE_PATH .'assets/plugins/'.$pluginfolder; 
}
$base_url = $modx->config['base_url'];
$displayStyle = ( ($_SESSION['browser']=='mz') || ($_SESSION['browser']=='op') || ($_SESSION['browser']=='sf') ) ? "table-row" : "block";

// Handle event
$e = &$modx->Event; 
switch ($e->name)
{ 
	case "OnRichTextEditorRegister": // register only for backend
		$e->output("CKEditor");
		break;

	case "OnRichTextEditorInit": 
		if($editor=="CKEditor") {
			$elementList = implode(",", $elements);
			if(isset($forfrontend)||$modx->isFrontend()){
				$frontend = 'true';
				$frontend_language = isset($modx->config['fe_editor_lang']) ? $modx->config['fe_editor_lang']:"";
				$ck_language = getCKEditorLang($frontend_language);
				$webuser = (isset($modx->config['rb_webuser']) ? $modx->config['rb_webuser'] : null);
				$html = getCKEditorScript($elementList,
				                         (isset($ckwebset) ? $ckwebset:"basic"),
				                         (isset($ckwebcustom) && ($ckwebset == "custom") ? $ckwebcustom:""),
				                          $width,
				                          $height,
				                          $ck_language,
				                          $frontend,
				                          $base_url,
				                          $modx->config['editor_css_path'],
				                          $modx->config['use_browser'],
				                          $ckwebautolang,
				                          null,
				                          $pluginfolder,
				                          $webuser);
			} else {
				$frontend = 'false';
				$manager_language = $modx->config['manager_language'];
				$ck_language = getCKEditorLang($manager_language);
				$html = getCKEditorScript($elementList,(!empty($modx->config['ck_editor_toolbar']) ? $modx->config['ck_editor_toolbar']:"basic"),(!empty($modx->config['ck_editor_custom_toolbar']) && ($modx->config['ck_editor_toolbar'] == "custom") ? $modx->config['ck_editor_custom_toolbar']:""),$width,$height,$ck_language,$frontend,$base_url,$modx->config['editor_css_path'], $modx->config['use_browser'],$modx->config['ck_editor_autolang'],$modx->config['ck_editor_style'],$pluginfolder,null);
			}
			$e->output($html);
		}		
		break;

	case "OnInterfaceSettingsRender":
		$manager_language = $modx->config['manager_language'];
		$html = getCKEditorSettings($_lang,
		                            $ckPath,
		                            $modx->config['manager_language'],
		                            $modx->config['use_editor'],
		                            $modx->config['ck_editor_toolbar'],
		                            $modx->config['ck_editor_custom_toolbar'],
		                            $modx->config['ck_editor_autolang'],
		                            $displayStyle,
		                            $modx->config['ck_editor_style']);
		$e->output($html);
		break;

   default :    
      return; // stop here - this is very important. 
      break; 
}
