#!/bin/sh

# $Id: build.sh,v 1.5 2007/02/20 16:25:22 okamura Exp $

# グローバル変数
Version=`sed '1,/<key>CFBundleShortVersionString<\/key>/d' Info.plist | head -1 | sed 's/.*<string>\(.*\)<\/string>.*/\1/'`
WorkDir=/tmp/`basename $0`.$$

# 作業ディレクトリ作成
mkdir -p "${WorkDir}/FreshClamDaemon-${Version}"
sudo chown root:admin "${WorkDir}/FreshClamDaemon-${Version}"

# パッケージ作成
sudo chown    root:admin Contents/Library
sudo chown -R root:wheel Contents/Library/StartupItems/FreshClamDaemon
#sudo chown    root:wheel Contents/usr
#sudo chown -R root:admin Contents/usr/local
sudo packagemaker -build -p "${WorkDir}/FreshClamDaemon-${Version}/FreshClamDaemon-${Version}.pkg" -f Contents -s -ds -v -r Resources -i Info.plist -d Description.plist
sudo chown -R `id -u`:`id -g` Contents/Library
#sudo chown -R `id -u`:`id -g` Contents/usr

# ディスクイメージ作成
sudo install -o root -g admin -m 0644 freshclam.conf "${WorkDir}/FreshClamDaemon-${Version}/"
sudo install -o root -g admin -m 0644 changelog*.txt "${WorkDir}/FreshClamDaemon-${Version}/"
sudo install -o root -g admin -m 0644 FreshClamDaemon-update.conf "${WorkDir}/FreshClamDaemon-${Version}/"
rm -f "FreshClamDaemon-${Version}.dmg"
sudo hdiutil create -srcfolder "${WorkDir}/FreshClamDaemon-${Version}" -fs HFS+ -volname "FreshClamDaemon-${Version}" -uid 0 -gid 80 "FreshClamDaemon-${Version}.dmg"
sudo chown `id -u`:`id -g` "FreshClamDaemon-${Version}.dmg"

# 作業ディレクトリ削除
sudo rm -rf "${WorkDir}"
