/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.amusaj.sp;

import jp.crestmuse.cmx.amusaj.filewrappers.PeakSet;
import jp.crestmuse.cmx.amusaj.filewrappers.TimeSeriesCompatible;
import jp.crestmuse.cmx.amusaj.sp.SPDoubleArray;
import jp.crestmuse.cmx.amusaj.sp.SPElement;
import jp.crestmuse.cmx.amusaj.sp.SPModule;
import jp.crestmuse.cmx.math.BooleanArray;
import jp.crestmuse.cmx.math.DoubleArray;
import jp.crestmuse.cmx.math.Operations;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HarmonicsExtractor<D extends SPElement>
extends SPModule {
    private double f0range;
    private double freqRange;
    private double powerthrs;
    private int nHarmonics;
    private int nHarmsForF0Calc;
    private boolean setParams = false;

    @Override
    protected String getParamCategory() {
        return "harmonics";
    }

    @Override
    protected String[] getUsedParamNames() {
        return new String[]{"F0_SEARCH_RANGE", "HARMONICS_SEARCH_RANGE", "POWER_THRESHOLD", "NUM_OF_HARMONICS", "NUM_OF_HARMONICS_FOR_F0_CALC"};
    }

    private void setParams() {
        this.f0range = this.getParamDouble("F0_SEARCH_RANGE");
        this.freqRange = this.getParamDouble("HARMONICS_SEARCH_RANGE");
        this.powerthrs = this.getParamDouble("POWER_THRESHOLD");
        this.nHarmonics = this.getParamInt("NUM_OF_HARMONICS");
        this.nHarmsForF0Calc = this.getParamInt("NUM_OF_HARMONICS_FOR_F0_CALC");
        this.setParams = true;
    }

    @Override
    public void execute(SPElement[] sPElementArray, TimeSeriesCompatible<SPElement>[] timeSeriesCompatibleArray) throws InterruptedException {
        if (!this.setParams) {
            this.setParams();
        }
        PeakSet peakSet = (PeakSet)sPElementArray[0];
        SPDoubleArray sPDoubleArray = (SPDoubleArray)sPElementArray[1];
        double d = sPDoubleArray.get(0);
        timeSeriesCompatibleArray[0].add(this.extractHarmonics(peakSet, d));
    }

    private PeakSet extractHarmonics(PeakSet peakSet, double d) {
        PeakSet peakSet2 = new PeakSet(this.nHarmonics);
        DoubleArray doubleArray = peakSet.freq();
        DoubleArray doubleArray2 = Operations.div(peakSet.power(), Operations.sum(peakSet.power()));
        double d2 = this.calcAccurateF0(d, doubleArray, doubleArray2);
        for (int i = 0; i < this.nHarmonics; ++i) {
            BooleanArray booleanArray = Operations.or(Operations.lessThan(doubleArray, ((double)(i + 1) - this.freqRange) * d2), Operations.greaterThan(doubleArray, ((double)(i + 1) + this.freqRange) * d2));
            DoubleArray doubleArray3 = Operations.mask(doubleArray2, booleanArray, 0.0);
            Operations.MaxResult maxResult = Operations.max(doubleArray3);
            if (maxResult.argmax > 0) {
                peakSet2.setFreq(i, doubleArray.get(maxResult.argmax));
                peakSet2.setPower(i, maxResult.max);
            } else {
                peakSet2.setFreq(i, 0.0);
                peakSet2.setPower(i, 0.0);
            }
            System.out.print(peakSet2.power(i) + " ");
        }
        System.out.println();
        return peakSet2;
    }

    private double calcAccurateF0(double d, DoubleArray doubleArray, DoubleArray doubleArray2) {
        double d2 = 0.0;
        for (int i = 1; i < this.nHarmsForF0Calc; ++i) {
            BooleanArray booleanArray = Operations.or(Operations.lessThan(doubleArray, (double)i * d / this.f0range), Operations.greaterThan(doubleArray, (double)i * d * this.f0range));
            DoubleArray doubleArray3 = Operations.mask(doubleArray2, booleanArray, Double.NEGATIVE_INFINITY);
            Operations.MaxResult maxResult = Operations.max(doubleArray3);
            if (!(maxResult.max > this.powerthrs)) continue;
            d2 = doubleArray.get(maxResult.argmax) / (double)i;
            break;
        }
        return d2;
    }

    @Override
    public Class<SPElement>[] getInputClasses() {
        return new Class[]{PeakSet.class, SPDoubleArray.class};
    }

    @Override
    public Class<SPElement>[] getOutputClasses() {
        return new Class[]{PeakSet.class};
    }
}

