/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.amusaj.sp;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import jp.crestmuse.cmx.amusaj.filewrappers.MutableTimeSeries;
import jp.crestmuse.cmx.amusaj.filewrappers.TimeSeriesCompatible;
import jp.crestmuse.cmx.amusaj.sp.ProducerConsumerCompatible;
import jp.crestmuse.cmx.amusaj.sp.SPElement;
import jp.crestmuse.cmx.amusaj.sp.SPIllegalConnectionException;
import jp.crestmuse.cmx.amusaj.sp.SPTerminator;
import jp.crestmuse.cmx.misc.QueueReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SPExecutor {
    private List<SPExecutorModule> modules = new LinkedList<SPExecutorModule>();
    private Map<ProducerConsumerCompatible, SPExecutorModule> map = new HashMap<ProducerConsumerCompatible, SPExecutorModule>();
    private Map<String, String> params;
    private int timeunit;
    private long sleepTime = 0L;

    public SPExecutor() {
        this(null);
    }

    public SPExecutor(Map<String, String> map) {
        this(map, 1);
    }

    @Deprecated
    public SPExecutor(Map<String, String> map, int n) {
        this.params = map;
        this.timeunit = n;
    }

    public void addSPModule(ProducerConsumerCompatible producerConsumerCompatible) {
        producerConsumerCompatible.setParams(this.params);
        SPExecutorModule sPExecutorModule = new SPExecutorModule(producerConsumerCompatible);
        this.modules.add(sPExecutorModule);
        this.map.put(producerConsumerCompatible, sPExecutorModule);
    }

    public void connect(ProducerConsumerCompatible producerConsumerCompatible, int n, ProducerConsumerCompatible producerConsumerCompatible2, int n2) {
        if (producerConsumerCompatible.getOutputClasses()[n] != producerConsumerCompatible2.getInputClasses()[n2]) {
            throw new SPIllegalConnectionException("can't connect " + producerConsumerCompatible.getOutputClasses()[n].getName() + " and " + producerConsumerCompatible2.getInputClasses()[n2].getName());
        }
        SPExecutorModule sPExecutorModule = this.map.get(producerConsumerCompatible);
        SPExecutorModule sPExecutorModule2 = this.map.get(producerConsumerCompatible2);
        sPExecutorModule2.src[n2] = sPExecutorModule.dest[n].getQueueReader();
    }

    public void start() {
        for (SPExecutorModule sPExecutorModule : this.modules) {
            sPExecutorModule.start();
        }
    }

    public void stop() {
        for (SPExecutorModule sPExecutorModule : this.modules) {
            sPExecutorModule.interrupt();
        }
    }

    public boolean finished() {
        for (SPExecutorModule sPExecutorModule : this.modules) {
            if (!sPExecutorModule.isAlive()) continue;
            return false;
        }
        return true;
    }

    public boolean finished(ProducerConsumerCompatible producerConsumerCompatible) {
        return !this.map.get(producerConsumerCompatible).isAlive();
    }

    public List<TimeSeriesCompatible<SPElement>> getResult(ProducerConsumerCompatible producerConsumerCompatible) {
        return Arrays.asList(this.map.get((Object)producerConsumerCompatible).dest);
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public void setSleepTime(long l) {
        this.sleepTime = l;
    }

    private class SPExecutorModule
    extends Thread {
        ProducerConsumerCompatible module;
        QueueReader<SPElement>[] src;
        TimeSeriesCompatible<SPElement>[] dest;
        SPElement[] inputElements;
        int inputChannelNum;
        int outputChannelNum;

        SPExecutorModule(ProducerConsumerCompatible producerConsumerCompatible) {
            this.inputChannelNum = producerConsumerCompatible.getInputClasses().length;
            this.outputChannelNum = producerConsumerCompatible.getOutputClasses().length;
            this.module = producerConsumerCompatible;
            this.src = new QueueReader[this.inputChannelNum];
            this.dest = new TimeSeriesCompatible[this.outputChannelNum];
            this.inputElements = new SPElement[this.inputChannelNum];
            for (int i = 0; i < this.outputChannelNum; ++i) {
                this.dest[i] = new MutableTimeSeries<SPElement>();
            }
        }

        public void run() {
            while (!Thread.interrupted()) {
                try {
                    for (int i = 0; i < this.inputChannelNum; ++i) {
                        this.inputElements[i] = this.src[i].take();
                    }
                    if (this.inputChannelNum > 0 && this.inputElements[0] instanceof SPTerminator) {
                        for (TimeSeriesCompatible<SPElement> timeSeriesCompatible : this.dest) {
                            timeSeriesCompatible.add(SPTerminator.getInstance());
                        }
                        break;
                    }
                    this.module.execute(this.inputElements, this.dest);
                    if (this.outputChannelNum > 0 && this.dest[0].isComplete()) break;
                    Thread.sleep(SPExecutor.this.sleepTime);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                    break;
                }
            }
            this.module.stop(this.src, this.dest);
        }
    }
}

