/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.gui.deveditor;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.swing.JOptionPane;
import jp.crestmuse.cmx.filewrappers.CMXFileWrapper;
import jp.crestmuse.cmx.filewrappers.DeviationInstanceWrapper;
import jp.crestmuse.cmx.filewrappers.MusicXMLWrapper;
import jp.crestmuse.cmx.gui.deveditor.CompiledDeviation;
import jp.crestmuse.cmx.sound.MusicPlayer;
import org.xml.sax.SAXException;

public class CorePlayer
implements MusicPlayer {
    private ArrayList<CompiledDeviation> compiledDeviations = new ArrayList();
    private int playingIndex = -1;
    private Sequencer sequencer = null;

    public CorePlayer() {
        try {
            this.sequencer = MidiSystem.getSequencer();
            this.sequencer.open();
        }
        catch (MidiUnavailableException midiUnavailableException) {
            JOptionPane.showMessageDialog(null, "can't find default sequencer");
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.sequencer != null) {
            this.sequencer.close();
        }
    }

    public long getMicrosecondPosition() {
        if (this.sequencer == null) {
            return 0L;
        }
        return this.sequencer.getMicrosecondPosition();
    }

    public long getTickPosition() {
        if (this.sequencer == null) {
            return 0L;
        }
        return this.sequencer.getTickPosition();
    }

    public boolean isNowPlaying() {
        if (this.sequencer == null) {
            return false;
        }
        return this.sequencer.isRunning();
    }

    public void play() {
        if (this.sequencer != null) {
            this.sequencer.start();
        }
    }

    public void stop() {
        if (this.sequencer != null) {
            this.sequencer.stop();
        }
    }

    public void run() {
    }

    public void reset() {
        if (this.sequencer != null) {
            this.sequencer.setTickPosition(0L);
        }
    }

    public void setTickPosition(long l) {
        if (this.sequencer != null) {
            this.sequencer.setTickPosition(l);
        }
    }

    public void setMicrosecondPosition(long l) {
        if (this.sequencer != null) {
            this.sequencer.setMicrosecondPosition(l);
        }
    }

    public CompiledDeviation open(CMXFileWrapper cMXFileWrapper) throws IOException, InvalidMidiDataException {
        DeviationInstanceWrapper deviationInstanceWrapper;
        try {
            deviationInstanceWrapper = DeviationInstanceWrapper.createDeviationInstanceFor((MusicXMLWrapper)cMXFileWrapper);
            deviationInstanceWrapper.finalizeDocument();
        }
        catch (ClassCastException classCastException) {
            try {
                deviationInstanceWrapper = (DeviationInstanceWrapper)cMXFileWrapper;
            }
            catch (ClassCastException classCastException2) {
                throw new IllegalArgumentException("argument must be MusicXMLWrapper or DeviationInstanceWrapper");
            }
        }
        CompiledDeviation compiledDeviation = new CompiledDeviation(deviationInstanceWrapper);
        this.compiledDeviations.add(compiledDeviation);
        return compiledDeviation;
    }

    public void changeDeviation(int n) throws InvalidMidiDataException {
        if (n == this.playingIndex) {
            return;
        }
        try {
            long l = this.sequencer.getTickPosition();
            this.sequencer.setSequence(this.compiledDeviations.get(n).getSequence());
            this.sequencer.setTickPosition(l);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.playingIndex = n;
    }

    public Sequence getCurrentSequence() {
        return this.compiledDeviations.get(this.playingIndex).getSequence();
    }

    public void writeFile(OutputStream outputStream) throws IOException, SAXException {
        this.compiledDeviations.get(this.playingIndex).calcDeviation().write(outputStream);
    }
}

