/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.gui.deveditor;

import java.awt.Color;
import java.awt.Graphics;
import javax.sound.midi.InvalidMidiDataException;
import jp.crestmuse.cmx.gui.deveditor.CompiledDeviation;
import jp.crestmuse.cmx.gui.deveditor.GUI;
import jp.crestmuse.cmx.gui.deveditor.PianoRollPanel;

public class PrintableDeviatedNote {
    private CompiledDeviation.DeviatedNote deviatedNote;
    private PianoRollPanel parent;
    private int x;
    private int y;
    private int width;
    private int height;
    private Color fillColor;
    private Color roundColor;

    public PrintableDeviatedNote(CompiledDeviation.DeviatedNote deviatedNote, PianoRollPanel pianoRollPanel) {
        this.deviatedNote = deviatedNote;
        this.parent = pianoRollPanel;
        this.asTickTime();
        this.y = PianoRollPanel.HEIGHT_PER_NOTE * (127 - deviatedNote.notenum());
        this.height = PianoRollPanel.HEIGHT_PER_NOTE;
        if (deviatedNote.isExtraNote()) {
            this.fillColor = new Color(255, 255, 0, deviatedNote.velocity() * 2);
            this.roundColor = Color.YELLOW;
        } else if (deviatedNote.getNote().voice() == 1) {
            this.fillColor = new Color(255, 0, 0, deviatedNote.velocity() * 2);
            this.roundColor = Color.RED;
        } else {
            this.fillColor = new Color(255, 127, 0, deviatedNote.velocity() * 2);
            this.roundColor = Color.ORANGE;
        }
    }

    public void print(Graphics graphics) {
        graphics.setColor(this.fillColor);
        graphics.fillRect(this.x, this.y, this.width, this.height);
        graphics.setColor(this.roundColor);
        graphics.drawRect(this.x + 1, this.y + 1, this.width - 3, this.height - 3);
    }

    public void printAsHover(Graphics graphics) {
        graphics.setColor(this.roundColor);
        graphics.fillRect(this.x - 5, this.y - 5, this.width + 10, this.height + 10);
    }

    public CompiledDeviation.DeviatedNote getDeviatedNote() {
        return this.deviatedNote;
    }

    public void asTickTime() {
        int n = CompiledDeviation.TICKS_PER_BEAT;
        this.x = (int)((double)this.deviatedNote.onset() / (double)n * (double)PianoRollPanel.WIDTH_PER_BEAT);
        this.width = (int)((double)(this.deviatedNote.offset() - this.deviatedNote.onset()) / (double)n * (double)PianoRollPanel.WIDTH_PER_BEAT);
    }

    public void asRealTime() {
        int n = this.parent.getPreferredSize().width;
        int n2 = (int)(this.parent.getCompiledDeviation().getSequence().getMicrosecondLength() / 1000L);
        this.x = n * this.deviatedNote.onsetInMSec() / n2;
        this.width = n * (this.deviatedNote.offsetInMSec() - this.deviatedNote.onsetInMSec()) / n2;
    }

    public boolean isMouseOver(int n, int n2) {
        return n > this.x && n < this.x + this.width && n2 > this.y && n2 < this.y + this.height;
    }

    public boolean isMouseOnRight(int n, int n2) {
        return this.isMouseOver(n, n2) && n > this.x + this.width / 2;
    }

    public boolean changeDeviation(double d, double d2, double d3, double d4) {
        try {
            if (this.deviatedNote.changeDeviation(d, d2, d3, d4)) {
                if (GUI.Instance().getShowAsTickTime()) {
                    this.asTickTime();
                } else {
                    this.asRealTime();
                }
                this.fillColor = new Color(this.fillColor.getRed(), this.fillColor.getGreen(), this.fillColor.getBlue(), this.deviatedNote.velocity() * 2);
                return true;
            }
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            invalidMidiDataException.printStackTrace();
        }
        return false;
    }

    public void setMissNote(boolean bl) {
        try {
            this.deviatedNote.setMissNote(bl);
            this.fillColor = new Color(this.fillColor.getRed(), this.fillColor.getGreen(), this.fillColor.getBlue(), this.deviatedNote.velocity() * 2);
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            invalidMidiDataException.printStackTrace();
        }
    }

    public NoteMoveHandle getHandle(int n, int n2) {
        if (this.isMouseOver(n, n2)) {
            if (n > this.x + this.width / 2) {
                return new NoteMoveHandle(false, this.x, this.x, this.width);
            }
            return new NoteMoveHandle(true, this.x + this.width, this.x, this.width);
        }
        return null;
    }

    class NoteMoveHandle {
        private boolean noteon;
        private int limit;
        private int prevX;
        private int prevWidth;

        private NoteMoveHandle(boolean bl, int n, int n2, int n3) {
            this.noteon = bl;
            this.limit = n;
            this.prevX = n2;
            this.prevWidth = n3;
        }

        public int press(int n) {
            if (this.noteon) {
                return this.prevX - n;
            }
            return this.prevX + this.prevWidth - n;
        }

        public void drag(int n) {
            if (this.noteon) {
                PrintableDeviatedNote.this.x = Math.min(n, this.limit - 1);
                PrintableDeviatedNote.this.width = this.limit - PrintableDeviatedNote.this.x;
            } else {
                PrintableDeviatedNote.this.width = Math.max(n - PrintableDeviatedNote.this.x, 1);
            }
        }

        public void release() {
            try {
                if (GUI.Instance().getShowAsTickTime()) {
                    if (this.noteon) {
                        PrintableDeviatedNote.this.deviatedNote.changeDeviation((double)(PrintableDeviatedNote.this.x - this.prevX) / (double)PianoRollPanel.WIDTH_PER_BEAT, 0.0);
                    } else {
                        PrintableDeviatedNote.this.deviatedNote.changeDeviation(0.0, (double)(PrintableDeviatedNote.this.width - this.prevWidth) / (double)PianoRollPanel.WIDTH_PER_BEAT);
                    }
                    PrintableDeviatedNote.this.asTickTime();
                } else {
                    int n = (int)(PrintableDeviatedNote.this.parent.getCompiledDeviation().getSequence().getMicrosecondLength() / 1000L);
                    int n2 = ((PrintableDeviatedNote)PrintableDeviatedNote.this).parent.getPreferredSize().width;
                    if (this.noteon) {
                        PrintableDeviatedNote.this.deviatedNote.changeAttackInMsec(PrintableDeviatedNote.this.x * n / n2);
                    } else {
                        PrintableDeviatedNote.this.deviatedNote.changeReleaseInMsec((PrintableDeviatedNote.this.x + PrintableDeviatedNote.this.width) * n / n2);
                    }
                    PrintableDeviatedNote.this.asRealTime();
                }
            }
            catch (InvalidMidiDataException invalidMidiDataException) {
                invalidMidiDataException.printStackTrace();
            }
        }
    }
}

