#!/bin/bash

echo "Thank you for downloading CrestMuseXML Toolkit ver.0.50."
echo "This program uses Apache Xerces, Xalan and Commons Math, distributed "
echo "under Apache License 2.0."
echo "For details of the license, read separate text files."
echo ""

java=`which java`
while [ -L $java ]
do
  ls=(`ls -l $java`)
  java=${ls[${#ls[@]}-1]}
done

java_home=`dirname $java`/../
if [ -e $java_home/jre/lib/ext/ ]; then
  lib_dir=$java_home/jre/lib/ext/
elif [ -e $java_home/lib/ext/ ]; then
  lib_dir=$java_home/lib/ext/
else
  echo [ERROR] No Java JRE or JDK found.
  exit 1
fi

echo "Now I'll be starting to install the libraries. "
echo "The following files are copying to ${lib_dir}."
echo ./lib/*.jar
echo "In general, it is not necessary to copy these files "
echo "if the same files have already been copied."
echo "Be carefully if you overwrite existing files."
echo "IT MAY UNABLE OTHER SOFTWARE TO RUN."

cp -i ./lib/*.jar $lib_dir

if [ -e $lib_dir/cmx*.jar ]; then
  echo "I found other versions (possibly older versions) of "
  echo "CrestMuseXML Toolkit."
  echo $lib_dir/cmx*.jar
  echo "Can I delete these files? [Y/N]"
  echo "DELETING THESE FILES MAY UNABLE OTHER SOFTWARE TO RUN."
  echo -n ">> "
  read YN
  if [ $YN = 'Y' ] || [ $YN = 'y' ]; then
    rm -i $lib_dir/cmx*.jar
  fi
fi

cp -i cmx-0.50.jar $lib_dir

echo "Finished."

