/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.spreadsheet;

import com.google.gdata.data.BaseEntry;
import com.google.gdata.data.Category;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.Kind;
import com.google.gdata.data.Link;
import com.google.gdata.data.spreadsheet.WorksheetEntry;
import com.google.gdata.data.spreadsheet.WorksheetFeed;
import com.google.gdata.util.ServiceException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Kind.Term(value="http://schemas.google.com/spreadsheets/2006#spreadsheet")
public class SpreadsheetEntry
extends BaseEntry<SpreadsheetEntry> {
    public static final String KIND = "http://schemas.google.com/spreadsheets/2006#spreadsheet";
    public static final Category CATEGORY = new Category("http://schemas.google.com/spreadsheets/2006", "http://schemas.google.com/spreadsheets/2006#spreadsheet");

    public SpreadsheetEntry() {
        this.getCategories().add(CATEGORY);
    }

    public SpreadsheetEntry(BaseEntry baseEntry) {
        super(baseEntry);
        this.getCategories().add(CATEGORY);
    }

    public Link getSpreadsheetLink() {
        return super.getHtmlLink();
    }

    public URL getWorksheetFeedUrl() {
        Link link = this.getLink("http://schemas.google.com/spreadsheets/2006#worksheetsfeed", "application/atom+xml");
        try {
            return new URL(link.getHref());
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException("Error in GData server", malformedURLException);
        }
    }

    public List<WorksheetEntry> getWorksheets() throws IOException, ServiceException {
        WorksheetFeed worksheetFeed = this.state.service.getFeed(this.getWorksheetFeedUrl(), WorksheetFeed.class);
        return worksheetFeed.getEntries();
    }

    public WorksheetEntry getDefaultWorksheet() throws IOException, ServiceException {
        Link link = this.getLink("http://schemas.google.com/spreadsheets/2006#worksheetsfeed", "application/atom+xml");
        String string = link.getHref() + "/default";
        return this.state.service.getEntry(new URL(string), WorksheetEntry.class);
    }

    public String getKey() {
        String string = this.state.id;
        int n = string.lastIndexOf("/");
        if (n > 0) {
            string = string.substring(n + 1);
        }
        return string;
    }

    @Override
    public void declareExtensions(ExtensionProfile extensionProfile) {
    }
}

