/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xindice.core.xupdate;

import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.xindice.core.Collection;
import org.apache.xindice.core.data.NodeSet;
import org.apache.xindice.xml.NamespaceMap;
import org.apache.xindice.xml.NodeSource;
import org.apache.xindice.xml.dom.CompressedNode;
import org.apache.xindice.xml.dom.DBNode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;
import org.xmldb.xupdate.lexus.XUpdateQueryImpl;
import org.xmldb.xupdate.lexus.commands.CommandObject;
import org.xmldb.xupdate.lexus.commands.DefaultCommand;

public class XUpdateImpl
extends XUpdateQueryImpl {
    protected int nodesModified = 0;
    protected NamespaceMap nsMap;
    private static final boolean API_NS_PRECEDENCE = true;

    public void setNamespaceMap(NamespaceMap nsMap) {
        if (nsMap == null) {
            return;
        }
        if (this.nsMap == null) {
            this.nsMap = nsMap;
        } else {
            this.nsMap.includeNamespaces(nsMap, true);
        }
    }

    public void setQString(String query) throws SAXException {
        super.setQString(query);
        if (this.nsMap == null) {
            this.nsMap = new NamespaceMap();
        }
        this.nsMap.includeNamespaces(this.namespaces, false);
    }

    public void execute(Node contextNode) throws Exception {
        CompressedNode cn;
        DefaultCommand currentCommand = new DefaultCommand(contextNode);
        Enumeration commands = this.query[0].elements();
        Enumeration attributes = this.query[1].elements();
        Enumeration characters = this.query[2].elements();
        Node origNode = contextNode;
        CommandObject.getXPath().setNamespace(this.nsMap.getContextNode());
        while (commands.hasMoreElements()) {
            block8: {
                int id = (Integer)commands.nextElement();
                if (id == 200) {
                    currentCommand.submitAttributes((Hashtable)attributes.nextElement());
                    continue;
                }
                if (id == 300) {
                    currentCommand.submitCharacters((String)characters.nextElement());
                    continue;
                }
                if (id > 0) {
                    if (currentCommand.submitInstruction(id)) continue;
                    this.commandConstants.setContextNode(contextNode);
                    currentCommand = this.commandConstants.commandForID(id);
                    if (currentCommand == null) {
                        throw new Exception("Operation can not have any XUpdate-instruction!");
                    }
                    currentCommand.reset();
                    continue;
                }
                if (currentCommand.executeInstruction()) continue;
                try {
                    contextNode = currentCommand.execute();
                }
                catch (Exception e) {
                    if ("no nodes selected !".equals(e.getMessage())) break block8;
                    throw e;
                }
            }
            currentCommand = new DefaultCommand(contextNode);
        }
        if (origNode instanceof CompressedNode && (cn = (CompressedNode)origNode).isDirty()) {
            ++this.nodesModified;
        }
    }

    public void execute(Collection col) throws Exception {
        int attribIndex = 0;
        for (int i = 0; i < this.query[0].size(); ++i) {
            int cmdID = (Integer)this.query[0].elementAt(i);
            if (cmdID != 200) continue;
            Hashtable attribs = (Hashtable)this.query[1].elementAt(attribIndex);
            ++attribIndex;
            String selector = (String)attribs.get("select");
            if (selector == null) continue;
            NodeSet ns = col.queryCollection("XPath", selector, this.nsMap);
            Document lastDoc = null;
            while (ns != null && ns.hasMoreNodes()) {
                DBNode node = (DBNode)ns.getNextNode();
                Document doc = node.getOwnerDocument();
                if (doc == lastDoc) continue;
                lastDoc = doc;
                NodeSource source = node.getSource();
                Element contextNode = doc.getDocumentElement();
                this.execute(contextNode);
                col.setDocument(source.getKey(), doc);
            }
        }
    }

    public int getModifiedCount() {
        return this.nodesModified;
    }
}

